﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;

namespace LZBS.Common
{
    /// <summary>
    /// 获取客户端信息
    /// </summary>
    public class ClientInfo
    {
        /// <summary>
        /// 获取客户端IP
        /// </summary>
        /// <returns></returns>
        public static string GetUserIP()
        {
            string result = String.Empty;
            //透过代理服务器取得客户端的真实IP地址
            result = HttpContext.Current.Request.ServerVariables["HTTP_X_FORWARDED_FOR"];
            if (result == null || result == String.Empty)
            {
                // 但如果客户端是使用代理服务器来访问，
                //那取到的就是代理服务器的IP地址，而不是真正的客户端IP地址
                result = HttpContext.Current.Request.ServerVariables["REMOTE_ADDR"];
            }
            if (result == null || result == String.Empty)
            {
                result = HttpContext.Current.Request.UserHostAddress;
            }
            if (result == null || result == String.Empty)
            {
                return "0.0.0.0";
            }
            return result;
        }
    }
}
