﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using LZBS.DBUtility;
using LZBS.Model;

namespace LZBS.DAL
{
    public class D_Download
    {
        /// <summary>
        /// 获取所有文件的编号和名称
        /// </summary>
        /// <returns></returns>
        public DataTable GetFileList()
        {
            string sqlString = "select FileID,FileName from DownLoad order by FileID DESC";
            return SqlHelp.GetDataTable(sqlString);
        }
        /// <summary>
        /// 通过文件编号查找文件的名称和路径
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetFileInfo(M_Download model)
        {
            string sqlString = "select * from DownLoad where FileID=@FileID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@FileID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.FileID;
            return SqlHelp.GetFirstRow(sqlString, paremeters);
        }
        /// <summary>
        /// 上传文件
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int UploadFile(M_Download model)
        {
            string sqlString = "Insert Into Download(FileName,NewFileName) Values(@FileName,@NewFileName)";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@FileName",SqlDbType.NVarChar,100),
                                          new SqlParameter("@NewFileName",SqlDbType.VarChar,25)
                                        };
            paremeters[0].Value = model.FileName;
            paremeters[1].Value = model.NewFileName;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 根据文件编号，删除文件
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteFile(M_Download model)
        {
            string sqlString = "delete from Download where FileID=@FileID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@FileID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.FileID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
    }
}
