﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.Model;
using System.Data;
using LZBS.DBUtility;
using System.Data.SqlClient;

namespace LZBS.DAL
{
    public class D_FAQ
    {
        /// <summary>
        /// 获取常见问题列表
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetFAQ()
        {
            string sqlString = "Select FAQContent From FAQ";
            return SqlHelp.GetFirstRow(sqlString);
        }
        /// <summary>
        /// 更改常见问题
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int UpdateFAQ(M_FAQ model)
        {
            string sqlString = "Update FAQ Set FAQContent=@FAQContent";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@FAQContent",SqlDbType.Text)
                                        };
            paremeters[0].Value = model.FAQContent;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
    }
}
