﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.Model;
using System.Data;
using System.Data.SqlClient;
using LZBS.DBUtility;

namespace LZBS.DAL
{
    public class D_Member
    {
        /// <summary>
        /// 根据账号，返回一个DataTable
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable GetInfoFromMemberID(M_Member model)
        {
            string sqlString = "select * from Members where MemberID=@MemberID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@MemberID",SqlDbType.VarChar,50)
                                       };
            paremeters[0].Value = model.MemberID;
            return SqlHelp.GetDataTable(sqlString, paremeters);
        }
        /// <summary>
        /// 注册账号
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddMember(M_Member model)
        {
            string sqlString = @"Insert Into Members (MemberID,Password,MemberName,Sex,Phone,Tel,Email,QQ,Question,Answer)
                                 Values(@MemberID,@Password,@MemberName,@Sex,@Phone,@Tel,@Email,@QQ,@Question,@Answer)";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@MemberID",SqlDbType.VarChar,50),
                                          new SqlParameter("@Password",SqlDbType.Char,32),
                                          new SqlParameter("@Question",SqlDbType.NVarChar,100),
                                          new SqlParameter("@Answer",SqlDbType.NVarChar,100),
                                          new SqlParameter("@MemberName",SqlDbType.NVarChar,30),
                                          new SqlParameter("@Sex",SqlDbType.NChar,1),
                                          new SqlParameter("@Phone",SqlDbType.Char,11),
                                          new SqlParameter("@Tel",SqlDbType.Char,12),
                                          new SqlParameter("@Email",SqlDbType.VarChar,50),
                                          new SqlParameter("@QQ",SqlDbType.Char,11)
                                      };
            paremeters[0].Value = model.MemberID;
            paremeters[1].Value = model.Password;
            paremeters[2].Value = model.Question;
            paremeters[3].Value = model.Answer;
            paremeters[4].Value = model.MemberName;
            paremeters[5].Value = model.Sex;
            paremeters[6].Value = model.Phone;
            paremeters[7].Value = model.Tel;
            paremeters[8].Value = model.Email;
            paremeters[9].Value = model.QQ;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 根据账号和密码查询会员，返回一个DataTable
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable CheckMember(M_Member model)
        {
            string sqlString = "select * from Members where MemberID=@MemberID and Password=@Password";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@MemberID",SqlDbType.VarChar,50),
                                          new SqlParameter("@Password",SqlDbType.Char,32)
                                        };
            paremeters[0].Value = model.MemberID;
            paremeters[1].Value = model.Password;
            return SqlHelp.GetDataTable(sqlString, paremeters);
        }

        /// <summary>
        /// 修改密码
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int ChangePassword(M_Member model)
        {
            string sqlString = "Update Members Set Password=@Password where MemberID=@MemberID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@MemberID",SqlDbType.VarChar,50),
                                          new SqlParameter("@Password",SqlDbType.Char,32)
                                        };
            paremeters[0].Value = model.MemberID;
            paremeters[1].Value = model.Password;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 修改用户信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int ChangeInfo(M_Member model)
        {
            string sqlString = @"Update Members Set MemberName=@MemberName,Sex=@Sex,Phone=@Phone,Tel=@Tel,Email=@Email,QQ=@QQ 
                                 where MemberID=@MemberID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@MemberID",SqlDbType.VarChar,50),
                                          new SqlParameter("@MemberName",SqlDbType.NVarChar,30),
                                          new SqlParameter("@Sex",SqlDbType.NChar,1),
                                          new SqlParameter("@Phone",SqlDbType.Char,11),
                                          new SqlParameter("@Tel",SqlDbType.Char,12),
                                          new SqlParameter("@Email",SqlDbType.VarChar,50),
                                          new SqlParameter("@QQ",SqlDbType.Char,11)
                                      };
            paremeters[0].Value = model.MemberID;
            paremeters[1].Value = model.MemberName;
            paremeters[2].Value = model.Sex;
            paremeters[3].Value = model.Phone;
            paremeters[4].Value = model.Tel;
            paremeters[5].Value = model.Email;
            paremeters[6].Value = model.QQ;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 获取所有会员信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetAllMembers()
        {
            string sqlString = "select * from Members";
            return SqlHelp.GetDataTable(sqlString);
        }
        /// <summary>
        /// 根据账号删除会员
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteMember(M_Member model)
        {
            string sqlString = "Delete from Members where MemberID=@MemberID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@MemberID",SqlDbType.VarChar,50)
                                       };
            paremeters[0].Value = model.MemberID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
    }
}
