﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.Model;
using System.Data;
using System.Data.SqlClient;
using LZBS.DBUtility;

namespace LZBS.DAL
{
    public class D_Product
    {
        /// <summary>
        /// 获取所有产品
        /// </summary>
        /// <returns></returns>
        public DataTable GetProductList()
        {
            string sqlString = "select ProductID,ProductName,Version,Brand,ImageUrl,Price,MOQ From Product order by ProductID DESC";
            return SqlHelp.GetDataTable(sqlString);
        }
        /// <summary>
        /// 通过产品编号获取产品信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetProductInfo(M_Product model)
        {
            string sqlString = "select * from Product where ProductID=@ProductID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@ProductID",SqlDbType.VarChar,50)
                                       };
            paremeters[0].Value = model.ProductID;
            return SqlHelp.GetFirstRow(sqlString, paremeters);
        }
        /// <summary>
        /// 添加产品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddProduct(M_Product model)
        {
            string sqlString = @"Insert Into Product(ProductName,Version,Brand,Description,ImageUrl,BigImage,Price,MOQ)
                                Values(@ProductName,@Version,@Brand,@Description,@ImageUrl,@BigImage,@Price,@MOQ)";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@ProductName",SqlDbType.NVarChar,50),
                                          new SqlParameter("@Version",SqlDbType.VarChar,50),
                                          new SqlParameter("@Brand",SqlDbType.NVarChar,20),
                                          new SqlParameter("@Description",SqlDbType.Text),
                                          new SqlParameter("@ImageUrl",SqlDbType.VarChar,100),
                                          new SqlParameter("@BigImage",SqlDbType.VarChar,100),
                                          new SqlParameter("@Price",SqlDbType.Int),
                                          new SqlParameter("@MOQ",SqlDbType.Int)
                                       };
            paremeters[0].Value = model.ProductName;
            paremeters[1].Value = model.Version;
            paremeters[2].Value = model.Brand;
            paremeters[3].Value = model.Description;
            paremeters[4].Value = model.ImageUrl;
            paremeters[5].Value = model.BigImage;
            paremeters[6].Value = model.Price;
            paremeters[7].Value = model.MOQ;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }

        /// <summary>
        /// 通过产品编号删除产品
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteProductByProductID(M_Product model)
        {
            string sqlString = "Delete from Product where ProductID=@ProductID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@ProductID",SqlDbType.VarChar,50)
                                       };
            paremeters[0].Value = model.ProductID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 根据产品编号修改产品信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int UpdateProductInfo(M_Product model)
        {
            string sqlString = "Update Product Set ProductName=@ProductName,Version=@Version,Brand=@Brand,Description=@Description,ImageUrl=@ImageUrl,BigImage=@BigImage,Price=@Price,MOQ=@MOQ where ProductID=@ProductID";
            SqlParameter[] paremeters ={
                                           new SqlParameter("@ProductID",SqlDbType.Int),
                                           new SqlParameter("@ProductName",SqlDbType.NVarChar,50),
                                           new SqlParameter("@Version",SqlDbType.VarChar,50),
                                           new SqlParameter("@Brand",SqlDbType.NVarChar,20),
                                           new SqlParameter("@Description",SqlDbType.Text),
                                           new SqlParameter("@ImageUrl",SqlDbType.VarChar,100),
                                           new SqlParameter("@BigImage",SqlDbType.VarChar,100),
                                           new SqlParameter("@Price",SqlDbType.Int),
                                           new SqlParameter("@MOQ",SqlDbType.Int)
                                       };
            paremeters[0].Value = model.ProductID;
            paremeters[1].Value = model.ProductName;
            paremeters[2].Value = model.Version;
            paremeters[3].Value = model.Brand;
            paremeters[4].Value = model.Description;
            paremeters[5].Value = model.ImageUrl;
            paremeters[6].Value = model.BigImage;
            paremeters[7].Value = model.Price;
            paremeters[8].Value = model.MOQ;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 获取指定数目的最新产品
        /// </summary>
        /// <param name="top"></param>
        /// <returns></returns>
        public object GetTopProduct(int top)
        {
            string sqlString = "select Top " + top + " ProductID,ProductName,ImageUrl from Product Order By ProductID DESC";
            return SqlHelp.GetDataTable(sqlString);
        }
    }
}
