﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using LZBS.Model;
using System.Data;
using System.Data.SqlClient;
using LZBS.DBUtility;

namespace LZBS.DAL
{
    public class D_Recruit
    {
        /// <summary>
        /// 添加招聘信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int Addrecruit(M_Recruit model)
        {
            string sqlString = @"Insert Into Recruit (RecruitObject,Number,Address,Pay,EndTime,Need,LinkMen,LinkTel,Email)
                                 Values(@RecruitObject,@Number,@Address,@Pay,@EndTime,@Need,@LinkMen,@LinkTel,@Email)";
            SqlParameter[] paremeters ={
                                           new SqlParameter("@RecruitObject",SqlDbType.VarChar,50),
                                           new SqlParameter("@Number",SqlDbType.VarChar,10),
                                           new SqlParameter("@Address",SqlDbType.NVarChar,100),
                                           new SqlParameter("@Pay",SqlDbType.VarChar,20),
                                           new SqlParameter("@EndTime",SqlDbType.DateTime),
                                           new SqlParameter("@Need",SqlDbType.Text),        
                                           new SqlParameter("@LinkMen",SqlDbType.NChar,4),
                                           new SqlParameter("@LinkTel",SqlDbType.Char,12),
                                           new SqlParameter("@Email",SqlDbType.VarChar,50)                                      
                                       };
            paremeters[0].Value = model.RecruitObject;
            paremeters[1].Value = model.Number;
            paremeters[2].Value = model.Address;
            paremeters[3].Value = model.Pay;
            paremeters[4].Value = model.EndTime;
            paremeters[5].Value = model.Need;
            paremeters[6].Value = model.LinkMen;
            paremeters[7].Value = model.LinkTel;
            paremeters[8].Value = model.Email;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 获取招聘信息
        /// </summary>
        /// <returns></returns>
        public DataTable GetRecruitInfo()
        {
            string sqlString = "select * from Recruit order by RecruitID DESC";
            return SqlHelp.GetDataTable(sqlString);
        }
        /// <summary>
        /// 根据招聘信息编号删除
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteRecruit(M_Recruit model)
        {
            string sqlString = "Delete From Recruit Where RecruitID=@RecruitID";
            SqlParameter[] paremeters ={
                                           new SqlParameter("@RecruitID",SqlDbType.Int)                                      
                                       };
            paremeters[0].Value = model.RecruitID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 根据招聘信息编号获取详细信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetRecruitInfoByRecruitID(M_Recruit model)
        {
            string sqlString = "select * from Recruit where RecruitID=@RecruitID";
            SqlParameter[] paremeters ={
                                           new SqlParameter("@RecruitID",SqlDbType.Int)                                      
                                       };
            paremeters[0].Value = model.RecruitID;
            return SqlHelp.GetFirstRow(sqlString, paremeters);
        }
        /// <summary>
        /// 修改招聘信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int UpdateRecruit(M_Recruit model)
        {
            string sqlString = @"Update Recruit Set RecruitObject=@RecruitObject,Number=@Number,Address=@Address,Pay=@Pay,EndTime=@EndTime,Need=@Need,
                                    LinkMen=@LinkMen,LinkTel=@LinkTel,Email=@Email where RecruitID=@RecruitID";
            SqlParameter[] paremeters ={
                                           new SqlParameter("@RecruitObject",SqlDbType.VarChar,50),
                                           new SqlParameter("@Number",SqlDbType.VarChar,10),
                                           new SqlParameter("@Address",SqlDbType.NVarChar,100),
                                           new SqlParameter("@Pay",SqlDbType.VarChar,20),
                                           new SqlParameter("@EndTime",SqlDbType.DateTime),
                                           new SqlParameter("@Need",SqlDbType.Text),        
                                           new SqlParameter("@LinkMen",SqlDbType.NChar,4),
                                           new SqlParameter("@LinkTel",SqlDbType.Char,12),
                                           new SqlParameter("@Email",SqlDbType.VarChar,50),
                                           new SqlParameter("@RecruitID",SqlDbType.Int)
                                       };
            paremeters[0].Value = model.RecruitObject;
            paremeters[1].Value = model.Number;
            paremeters[2].Value = model.Address;
            paremeters[3].Value = model.Pay;
            paremeters[4].Value = model.EndTime;
            paremeters[5].Value = model.Need;
            paremeters[6].Value = model.LinkMen;
            paremeters[7].Value = model.LinkTel;
            paremeters[8].Value = model.Email;
            paremeters[9].Value = model.RecruitID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
    }
}
