﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using LZBS.DBUtility;
using System.Data.SqlClient;
using LZBS.Model;

namespace LZBS.DAL
{
    public class D_Reply
    {
        /// <summary>
        /// 根据BookID获取回复的所有信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable GetReplyInfoByBookID(M_Reply model)
        {
            SqlParameter[] paremeters ={
                                          new SqlParameter("@BookID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.BookID;
            return SqlHelp.RunProcedure("ReplyInfo", paremeters);
        }
        /// <summary>
        /// 根据ReplyID删除回复的信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteReplyReplyID(M_Reply model)
        {
            string sqlString = "delete from Reply where ReplyID=@ReplyID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@ReplyID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.ReplyID;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
        /// <summary>
        /// 添加回复
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int AddReply(M_Reply model)
        {
            string sqlString = "Insert Into Reply(Content,BookID,Account) Values(@Content,@BookID,@Account)";
            SqlParameter[] paremeters ={
                                           new SqlParameter("@Content",SqlDbType.Text),
                                           new SqlParameter("@BookID",SqlDbType.Int),
                                           new SqlParameter("@Account",SqlDbType.VarChar,50)
                                        };
            paremeters[0].Value = model.Content;
            paremeters[1].Value = model.BookID;
            paremeters[2].Value = model.Account;
            return SqlHelp.ExecuteSQL(sqlString, paremeters);
        }
    }
}
