﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using LZBS.DBUtility;
using LZBS.Model;

namespace LZBS.DAL
{
    public class D_SysLog
    {
        /// <summary>
        /// 添加日志记录
        /// </summary>
        /// <param name="mLog"></param>
        /// <returns></returns>
        public int AddLog(M_SysLog mLog)
        {
            SqlParameter[] paremeters ={
                                          new SqlParameter("@UserIP",SqlDbType.Char,19),
                                          new SqlParameter("@URL",SqlDbType.VarChar,100),
                                          new SqlParameter("@OPInfo",SqlDbType.NVarChar,50),
                                          new SqlParameter("@Account",SqlDbType.VarChar,50),
                                          new SqlParameter("@UserType",SqlDbType.Int)
                                        };
            paremeters[0].Value = mLog.UserIP;
            paremeters[1].Value = mLog.URL;
            paremeters[2].Value = mLog.OPInfo;
            paremeters[3].Value = mLog.Account;
            paremeters[4].Value = mLog.UserType;
            return SqlHelp.GetEffectProcedure("AddLog", paremeters);
        }
        /// <summary>
        /// 获取所有日志列表
        /// </summary>
        /// <returns></returns>
        public DataTable GetAllSysLog()
        {
            string sqlString = @"select LogID,UserIP,URL,OPInfo,Account,OPTime,UserType=
                                    CASE UserType
                                    When 0 Then '管理员'
                                    When 1 Then '会员'
                                    When 2 Then '游客'
                                    End
                                    from SysLog
                                    Order By LogID DESC";
            return SqlHelp.GetDataTable(sqlString);
        }
        /// <summary>
        /// 删除日志
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteLog(M_SysLog model)
        {
            //string sqlString = "Delete From SysLog Where LogID=@LogID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@LogID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.LogID;
            //return SqlHelp.ExecuteSQL(sqlString, paremeters);
            return SqlHelp.GetEffectProcedure("DeleteLog", paremeters);
        }
        /// <summary>
        /// 根据日志时间批量删除日志
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public int DeleteLogByTime(M_SysLog model)
        {
            //string sqlString = "Delete From SysLog Where OPTime>=@StartTime and OPTime<@EndTime";
            //SqlParameter[] paremeters ={
            //                              new SqlParameter("@StartTime",SqlDbType.DateTime),
            //                              new SqlParameter("@EndTime",SqlDbType.DateTime)
            //                            };
            //paremeters[0].Value = model.StartTime;
            //paremeters[1].Value = model.EndTime;

            StringBuilder sqlString = new StringBuilder();
            sqlString.Append("Delete From SysLog");
            sqlString.Append(" Where OPTime>=@StartTime");
            sqlString.Append(" and OPTime<@EndTime");
            if (model.UserType != 3)
                sqlString.Append(" and UserType=@UserType");
            SqlParameter[] paremeters ={
                                          new SqlParameter("@StartTime",SqlDbType.DateTime),
                                          new SqlParameter("@EndTime",SqlDbType.DateTime),
                                          new SqlParameter("@UserType",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.StartTime;
            paremeters[1].Value = model.EndTime;
            paremeters[2].Value = model.UserType;
            return SqlHelp.ExecuteSQL(sqlString.ToString(), paremeters);
        }
        /// <summary>
        /// 通过条件查询日志
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataTable GetSysLogByCondition(M_SysLog model)
        {
            StringBuilder sqlString = new StringBuilder();
            sqlString.Append("select LogID,UserIP,URL,OPInfo,Account,OPTime,UserType=");
            sqlString.Append(" CASE UserType");
            sqlString.Append(" When 0 Then '管理员'");
            sqlString.Append(" When 1 Then '会员'");
            sqlString.Append(" When 2 Then '游客'");
            sqlString.Append(" End");
            sqlString.Append(" from SysLog");
            sqlString.Append(" Where OPTime>=@StartTime");
            sqlString.Append(" and OPTime<@EndTime");
            if(model.UserType!=3)
                sqlString.Append(" and UserType=@UserType");
            sqlString.Append(" Order By LogID DESC");
            SqlParameter[] paremeters ={
                                          new SqlParameter("@StartTime",SqlDbType.DateTime),
                                          new SqlParameter("@EndTime",SqlDbType.DateTime),
                                          new SqlParameter("@UserType",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.StartTime;
            paremeters[1].Value = model.EndTime;
            paremeters[2].Value = model.UserType;
            return SqlHelp.GetDataTable(sqlString.ToString(), paremeters);
        }
        /// <summary>
        /// 通过LogID获取日志信息
        /// </summary>
        /// <param name="model"></param>
        /// <returns></returns>
        public DataRow GetSysLogByLogID(M_SysLog model)
        {
            string sqlString = "Select Account,OPInfo From SysLog Where LogID=@LogID";
            SqlParameter[] paremeters ={
                                          new SqlParameter("@LogID",SqlDbType.Int)
                                        };
            paremeters[0].Value = model.LogID;
            return SqlHelp.GetFirstRow(sqlString, paremeters);
        }
    }
}
