﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class BatchDeleteLog : System.Web.UI.Page
    {
        B_SysLog bll = new B_SysLog();
        M_SysLog model = new M_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
        }

        protected void btnDeleteAll_Click(object sender, EventArgs e)
        {
            model.UserIP = ClientInfo.GetUserIP();
            model.URL = Request.Url.AbsoluteUri.ToString();
            model.Account = Session["UserID"].ToString();
            model.UserType = 0;

            model.StartTime = Convert.ToDateTime(txtStartTime.Text.Trim());
            model.EndTime = Convert.ToDateTime(txtEndTime.Text.Trim()).AddDays(1);
            model.UserType = Convert.ToInt32(ddlUserType.SelectedValue);

            if (bll.DeleteLogByTime(model) > 0)
            {
                model.OPInfo = "删除了从" + model.StartTime + "到" + model.EndTime + "期间的日志记录";
                MyMessageBox.MessageBox("删除成功", this.Page);
            }
            else
            {
                model.OPInfo = "删除从" + model.StartTime + "到" + model.EndTime + "期间的日志记录时出错";
                MyMessageBox.MessageBox("删除失败", this.Page);
            }
            bll.AddLog(model);
        }
        ///// <summary>
        ///// 检索日志
        ///// </summary>
        ///// <param name="sender"></param>
        ///// <param name="e"></param>
        //protected void btnSearch_Click(object sender, EventArgs e)
        //{
        //    //未解决
        //    model.StartTime = Convert.ToDateTime(txtStartTime.Text.Trim());
        //    model.EndTime = Convert.ToDateTime(txtEndTime.Text.Trim()).AddDays(1);
        //    model.UserType = Convert.ToInt32(ddlUserType.SelectedValue);
        //    bll.GetSysLogByCondition(model);
        //}


    }
}
