﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class GuestBookManage : System.Web.UI.Page
    {
        B_GuestBook bll = new B_GuestBook();
        M_GuestBook model = new M_GuestBook();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
            {
                BindToGridView();
            }
        }
        /// <summary>
        /// 给GridView绑定数据信息
        /// </summary>
        private void BindToGridView()
        {
            gvGuestBook.DataSource = bll.GetGuestBook();
            gvGuestBook.DataBind();

        }
        /// <summary>
        /// GridView删除事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvGuestBook_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            M_SysLog mLog = new M_SysLog();
            B_SysLog bLog = new B_SysLog();
            M_GuestBook modelBook = new M_GuestBook();
            //获取GridView操作的数据项的索引号
            int Index = e.RowIndex;
            //获取GridView主键字段的值，即GridView控件中DataKeyNames属性设置的字段
            model.BookID = Convert.ToInt32(gvGuestBook.DataKeys[Index].Value.ToString());
            modelBook.BookID = Convert.ToInt32(gvGuestBook.DataKeys[Index].Value.ToString());
            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            DataRow dr = bll.GetGuestBookByBookID(modelBook);
            if (bll.DeleteGuestBook(model) > 0)
                mLog.OPInfo = "删除标题为※" + dr["Title"] + "※的留言成功";
            else
                mLog.OPInfo = "删除标题为※" + dr["Title"] + "※的留言失败";
            bLog.AddLog(mLog);                
            BindToGridView();
        }

        protected void gvGuestBook_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            gvGuestBook.PageIndex = e.NewPageIndex;
            BindToGridView();
        }
    }
}
