﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class NewsManage : System.Web.UI.Page
    {
        B_News bll = new B_News();
        M_News model = new M_News();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
            {
                BindToGridView(); 
            }
        }
        /// <summary>
        /// 给GridView绑定数据信息
        /// </summary>
        private void BindToGridView()
        {
            gvNews.DataSource = bll.GetAllNewsList();
            gvNews.DataBind();
        }
        /// <summary>
        /// GridView删除事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvNews_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            
            //获取GridView操作的数据项的索引号
            int Index = e.RowIndex;
            //获取GridView主键字段的值，即GridView控件中DataKeyNames属性设置的字段
            model.NewsID = Convert.ToInt32(gvNews.DataKeys[Index].Value.ToString());
            DataRow dr=bll.GetNewsInfo(model);
            if (bll.DeleteNews(model) > 0)
            {
                mLog.OPInfo = "删除标题为" + dr["Title"] + "的新闻成功";
                MyMessageBox.MessageBox("新闻删除成功", this.Page);
            }
            else
            {
                mLog.OPInfo = "删除标题为" + dr["Title"] + "的新闻失败";
                MyMessageBox.MessageBox("新闻删除失败", this.Page);
            }
            bLog.AddLog(mLog);
            BindToGridView();
        }

        protected void gvNews_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            gvNews.PageIndex = e.NewPageIndex;
            BindToGridView();
        }
    }
}
