﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="ProductManage.aspx.cs" Inherits="LZBS.Web.Admin.ProductManage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>产品管理</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:GridView ID="gvProduct" runat="server" AllowPaging="True" 
            AutoGenerateColumns="False" CellPadding="4" ForeColor="#333333" 
            GridLines="None" DataKeyNames="ProductID" 
            onpageindexchanging="gvProduct_PageIndexChanging" 
            onrowdeleting="gvProduct_RowDeleting" PageSize="7" Width="900px">
            <RowStyle BackColor="#EFF3FB" />
            <Columns>
                <asp:BoundField DataField="ProductName" HeaderText="产品名称" 
                    SortExpression="ProductName" >
                    <ItemStyle Width="275px" />
                </asp:BoundField>
                <asp:BoundField DataField="Version" HeaderText="产品型号" 
                    SortExpression="Version" >
                    <ItemStyle Width="100px" />
                </asp:BoundField>
                <asp:BoundField DataField="Brand" HeaderText="产品品牌" SortExpression="Brand" >
                    <ItemStyle Width="100px" />
                </asp:BoundField>
                <asp:BoundField DataField="Price" HeaderText="产品价格" SortExpression="Price" >
                    <ItemStyle Width="75px" />
                </asp:BoundField>
                <asp:BoundField DataField="MOQ" HeaderText="最少订量" SortExpression="MOQ" >
                    <ItemStyle Width="75px" />
                </asp:BoundField>
                <asp:ImageField DataImageUrlField="ImageUrl" 
                    DataImageUrlFormatString="~/Admin/UploadFiles/Product/{0}" HeaderText="产品图片">
                    <ControlStyle Height="56px" Width="185px" />
                    <ItemStyle Width="185px" />
                </asp:ImageField>
                <asp:HyperLinkField DataNavigateUrlFields="ProductID" 
                    DataNavigateUrlFormatString="ProductEdit.aspx?ProductID={0}" HeaderText="编辑" 
                    Text="编辑" >
                    <ItemStyle Width="50px" />
                </asp:HyperLinkField>
                <asp:HyperLinkField DataNavigateUrlFields="ProductID" 
                    DataNavigateUrlFormatString="~/ProductInfo.aspx?ProductID={0}" HeaderText="查看详细" 
                    Text="查看" Target="_blank" >
                    <ItemStyle Width="75px" />
                </asp:HyperLinkField>
                <asp:CommandField HeaderText="删除" ShowDeleteButton="True" ShowHeader="True" >
                    <ItemStyle Width="50px" />
                </asp:CommandField>
            </Columns>
            <FooterStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" />
            <PagerStyle BackColor="#2461BF" ForeColor="White" HorizontalAlign="Center" />
            <SelectedRowStyle BackColor="#D1DDF1" Font-Bold="True" ForeColor="#333333" />
            <HeaderStyle BackColor="#507CD1" Font-Bold="True" ForeColor="White" />
            <EditRowStyle BackColor="#2461BF" />
            <AlternatingRowStyle BackColor="White" />
        
        </asp:GridView>
    </div>
    </form>
</body>
</html>
