﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.Model;
using LZBS.BLL;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class RecruitEdit : System.Web.UI.Page
    {
        M_Recruit model = new M_Recruit();
        B_Recruit bll = new B_Recruit();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
            {
                if (Request.QueryString["RecruitID"] == null)
                {
                    MyMessageBox.MessageBox("非法传值", this.Page, "Right.aspx");
                }
                else
                {
                    model.RecruitID = Convert.ToInt32(Request.QueryString["RecruitID"].ToString());
                    DataRow dr = bll.GetRecruitInfoByRecruitID(model);
                    txtObject.Text = dr["RecruitObject"].ToString();
                    txtNumber.Text = dr["Number"].ToString();
                    txtAddress.Text = dr["Address"].ToString();
                    txtPay.Text = dr["Pay"].ToString();
                    txtEndTime.Text = dr["EndTime"].ToString().Substring(0,9);
                    ftbContent.Text = dr["Need"].ToString();
                    txtLinkMen.Text = dr["LinkMen"].ToString();
                    txtLinkTel.Text = dr["LinkTel"].ToString();
                    txtEmail.Text = dr["Email"].ToString();
                }
            }
        }
        /// <summary>
        /// 修改
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btnSave_Click(object sender, EventArgs e)
        {
            model.RecruitID = Convert.ToInt32(Request.QueryString["RecruitID"].ToString());
            model.RecruitObject = txtObject.Text.Trim();
            model.Number = txtNumber.Text.Trim();
            model.Address = txtAddress.Text.Trim();
            model.Pay = txtPay.Text.Trim();
            model.EndTime = Convert.ToDateTime(txtEndTime.Text.Trim());
            model.Need = ftbContent.Text;
            model.LinkMen = txtLinkMen.Text.Trim();
            model.LinkTel = txtLinkTel.Text.Trim();
            model.Email = txtEmail.Text.Trim();

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            DataRow dr = bll.GetRecruitInfoByRecruitID(model);
            if (bll.UpdateRecruit(model) > 0)
            {
                mLog.OPInfo = "修改招聘  " + dr["RecruitObject"].ToString() + "  的信息成功";
                MyMessageBox.MessageBox("招聘信息修改成功", this.Page, "RecruitManage.aspx");
            }
            else
            {
                mLog.OPInfo = "修改招聘  " + dr["RecruitObject"].ToString() + "  的信息失败";
                MyMessageBox.MessageBox("招聘信息修改失败，请重试", this.Page);
            }
            bLog.AddLog(mLog);
        }
    }
}
