﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class RecruitInsert : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
        }

        protected void btnSave_Click(object sender, EventArgs e)
        {
            B_Recruit bll = new B_Recruit();
            M_Recruit model = new M_Recruit();
            M_SysLog mLog = new M_SysLog();
            B_SysLog bLog = new B_SysLog();
            model.RecruitObject = txtObject.Text.Trim();
            model.Number = txtNumber.Text.Trim();
            model.Address = txtAddress.Text.Trim();
            model.Pay = txtPay.Text.Trim();
            model.EndTime = Convert.ToDateTime(txtEndTime.Text.Trim());
            model.Need = ftbContent.Text;
            model.LinkMen = txtLinkMen.Text.Trim();
            model.LinkTel = txtLinkTel.Text.Trim();
            model.Email = txtEmail.Text.Trim();

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
           
            if (bll.Addrecruit(model) > 0)
            {
                mLog.OPInfo = "添加  " + txtObject.Text.Trim() + "   招聘信息成功";
                if (chkAddContinue.Checked == true)
                {
                    Response.Redirect("RecruitInsert.aspx", true);
                }
                else
                {
                    Response.Redirect("RecruitManage.aspx", true);
                }
            }
            else
            {
                mLog.OPInfo = "添加  " + txtObject.Text.Trim() + "   招聘信息失败";
                MyMessageBox.MessageBox("招聘信息添加失败", this.Page);
            }
            bLog.AddLog(mLog);    
        }
    }
}
