﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class Reply : System.Web.UI.Page
    {
        B_Reply bll = new B_Reply();
        M_Reply model = new M_Reply();
        B_GuestBook bbook = new B_GuestBook();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (Request.QueryString["BookID"] == null)
            {
                Response.Redirect("GuestBookManage.aspx", true);
            }
            if (!IsPostBack)
            {
                /////////////////////////////////////////输入判断语句，是否合法
                model.BookID = Convert.ToInt32(Request.QueryString["BookID"].ToString());
                BindToRepeater(model);
                DataRow dr = bbook.GetGuestBookByBookID(model);
                lblTitle.Text = dr["Title"].ToString();
                lblContent.Text = dr["Content"].ToString();
                lblTime.Text = dr["LeaveDate"].ToString();
                if (dr["MemberID"] != null)
                    lblMemberID.Text = dr["MemberID"].ToString();
            }
        }

        /// <summary>
        /// Repeater绑定数据信息
        /// </summary>
        private void BindToRepeater(M_Reply model)
        {
            rptReply.DataSource = bll.GetReplyInfoByBookID(model);
            rptReply.DataBind();
        }
        /// <summary>
        /// 删除
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void lbDelete_Command(object sender, CommandEventArgs e)
        {
            model.ReplyID = Convert.ToInt32(e.CommandName.ToString());
            model.BookID = Convert.ToInt32(Request.QueryString["BookID"].ToString());

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            if (bll.DeleteReplyReplyID(model) > 0)
            {
                mLog.OPInfo = "删除 " + lblTitle.Text + " 的回复留言成功";
                MyMessageBox.MessageBox("成功删除回复！", this.Page, "GuestBookManage.aspx");
            }
            else
            {
                mLog.OPInfo = "删除 " + lblTitle.Text + " 的回复留言失败";
                MyMessageBox.MessageBox("删除回复失败！", this.Page, "GuestBookManage.aspx");
            }
            BindToRepeater(model);
        }

        protected void btnConfirm_Click(object sender, EventArgs e)
        {
            model.Content = txtContent.Text.ToString();
            model.Account = Session["UserID"].ToString();
            model.BookID = Convert.ToInt32(Request.QueryString["BookID"].ToString());

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;

            if (bll.AddReply(model) > 0)
            {
                mLog.OPInfo = "回复留言 " + lblTitle.Text + " 成功";
                MyMessageBox.MessageBox("回复留言成功！", this.Page, "GuestBookManage.aspx");
            }
            else
            {
                mLog.OPInfo = "回复留言 " + lblTitle.Text + " 失败";
                MyMessageBox.MessageBox("回复留言失败，请重试！", this.Page);
            }
            bLog.AddLog(mLog);   
        }
    }
}
