﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.Model;
using LZBS.BLL;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class UserInsert : System.Web.UI.Page
    {
        M_User model = new M_User();
        B_User bll = new B_User();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
        }

        protected void btnAdd_Click(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                model.UserID = txtUserID.Text.Trim();
                model.Password = txtPwd.Text.Trim();
                model.UserName = txtName.Text.Trim();

                mLog.UserIP = ClientInfo.GetUserIP();
                mLog.URL = Request.Url.AbsoluteUri.ToString();
                mLog.Account = Session["UserID"].ToString();
                mLog.UserType = 0;
                
                if (bll.AddUser(model) > 0)
                {
                    mLog.OPInfo = "添加用户 " + txtUserID.Text.Trim() + " 成功";
                    MyMessageBox.MessageBox("添加成功", this.Page);
                }
                else
                {
                    mLog.OPInfo = "添加用户 " + txtUserID.Text.Trim() + " 失败";
                    MyMessageBox.MessageBox("添加失败", this.Page);
                }
                bLog.AddLog(mLog);
            }
        }

        protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
        {
            model.UserID = txtUserID.Text.Trim();
            if (bll.IsExistUser(model) == true)
                args.IsValid = false;
            else
                args.IsValid = true;
        }
    }
}
