﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web.Admin
{
    public partial class UserManage : System.Web.UI.Page
    {
        B_User bll = new B_User();
        M_User model = new M_User();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Session["UserID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            if (!IsPostBack)
            {
                BindToGridView();
            }
        }

        private void BindToGridView()
        {
            gvUsers.DataSource = bll.GetUserInfo();
            gvUsers.DataBind();
        }

        /// <summary>
        /// GridView编辑事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvUsers_RowEditing(object sender, GridViewEditEventArgs e)
        {
            gvUsers.EditIndex = e.NewEditIndex;
            BindToGridView();
        }
        /// <summary>
        /// GridView取消编辑事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvUsers_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
        {
            gvUsers.EditIndex = -1;
            BindToGridView();
        }
        /// <summary>
        /// GridView更新事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvUsers_RowUpdating(object sender, GridViewUpdateEventArgs e)
        {
            //获取GridView操作的数据项的索引号
            int Index = e.RowIndex;
            //获取GridView主键字段的值，即GridView控件中DataKeyNames属性设置的字段
            model.UserID = gvUsers.DataKeys[Index].Value.ToString();
            model.UserName = ((TextBox)gvUsers.Rows[Index].Cells[1].FindControl("txtName")).Text;
            bll.UpdateUser(model);
            gvUsers.EditIndex = -1;
            BindToGridView();
        }

        /// <summary>
        /// GridView删除事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvUsers_RowDeleting(object sender, GridViewDeleteEventArgs e)
        {
            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Session["UserID"].ToString();
            mLog.UserType = 0;
            
            //获取GridView操作的数据项的索引号
            int Index = e.RowIndex;
            //获取GridView主键字段的值，即GridView控件中DataKeyNames属性设置的字段
            model.UserID = gvUsers.DataKeys[Index].Value.ToString();
            if (Session["UserID"].ToString() == model.UserID)
            {
                MyMessageBox.MessageBox("你不能删除自己的账号", this.Page);
            }
            else
            {
                if (bll.DeleteUser(model) > 0)
                {
                    mLog.OPInfo = "删除  " + gvUsers.DataKeys[Index].Value.ToString() + "  账号成功";
                    MyMessageBox.MessageBox("删除成功", this.Page);
                }
                else
                {
                    mLog.OPInfo = "删除  " + gvUsers.DataKeys[Index].Value.ToString() + "  账号失败";
                    MyMessageBox.MessageBox("删除失败，请重试", this.Page);
                }
                bLog.AddLog(mLog);
                BindToGridView();
            }
        }
        /// <summary>
        /// GridView处理分页事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void gvUsers_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            gvUsers.PageIndex = e.NewPageIndex;
            BindToGridView();
        }
        
    }
}
