﻿using System;
using System.Collections;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;
using System.Xml.Linq;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.Web.SessionState;
using LZBS.Common;

namespace LZBS.Web
{
    /// <summary>
    /// $codebehindclassname$ 的摘要说明
    /// </summary>
    [WebService(Namespace = "http://tempuri.org/")]
    [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
    //在实现IHttpHandler的同时，也要实现IRequiresSessionState接口，其命名空间为：System.Web.SessionState
    public class DrawHandler : IHttpHandler, IRequiresSessionState
    {
        Bitmap image;
        Graphics g;
        Random rand = new Random((int)DateTime.Now.Ticks);
        public void ProcessRequest(HttpContext context)
        {
            context.Response.ContentType = "img/jpg";
            string checkCode = RandomBuilder.GetRandomCode(4);
            //Session["CheckCode"] = checkCode;
            context.Session["CheckCode"] = checkCode;//必须使用context

            int iwidth = (int)(checkCode.Length * 16);//iwidth为图片宽度,根据字符长度自动更改图片宽度
            image = new Bitmap(iwidth, 20);//用指定的大小初始化 Bitmap 类的新实例(宽度,高度)
            g = Graphics.FromImage(image);

            DrawString(checkCode);
            DrawPoint();
            DrawLine();

            //输出随机码图片
            image.Save(context.Response.OutputStream, ImageFormat.Gif);
            context.Response.End();
            //释放资源
            this.g.Dispose();
            this.image.Dispose();
        }
        /// <summary>
        /// 绘制图片
        /// </summary>
        /// <param name="checkCode"></param>
        private void DrawString(string checkCode)
        {
            Color color = Color.FromArgb(rand.Next(255), rand.Next(255), rand.Next(255));
            g.Clear(ColorTranslator.FromHtml("#ffffff"));
            this.g.DrawString(checkCode, new Font(GetFont(), 16), new SolidBrush(color), new PointF(0, 0), new StringFormat());
            this.g.Flush();
        }

        /// <summary>
        /// 绘制噪点
        /// </summary>
        private void DrawPoint()
        {
            //获取随机噪点个数
            int PointNum = rand.Next(76);
            //获取随即噪点颜色
            Color color = new Color();
            for (int i = 0; i < PointNum; i++)
            {
                color = Color.FromArgb(rand.Next(255), rand.Next(255), rand.Next(255));
                image.SetPixel(rand.Next(image.Width), rand.Next(image.Height), color);
            }
        }
        /// <summary>
        /// 绘制直线
        /// </summary>
        private void DrawLine()
        {
            int lineNum = rand.Next(3);
            Pen blackPen = new Pen(Color.Black, 0);
            //获取随即噪点颜色
            Color color = Color.FromArgb(rand.Next(255), rand.Next(255), rand.Next(255));
            for (int i = 0; i < lineNum; i++)
            {
                int y = rand.Next(image.Height);
                g.DrawLine(blackPen, rand.Next(image.Width), rand.Next(image.Height), rand.Next(image.Width), rand.Next(image.Height));
            }
        }
        /// <summary>
        /// 获得字体
        /// </summary>
        /// <returns></returns>
        private string GetFont()
        {
            string allFont = "宋体,Arial,Impact,Courier,Verdana";
            string[] allFontArray = allFont.Split(',');
            string font = allFontArray[rand.Next(5)];
            return font;
        }

        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }
}
