﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.Model;
using LZBS.BLL;
using LZBS.Common;

namespace LZBS.Web
{
    public partial class GuestBook : System.Web.UI.Page
    {
        B_GuestBook bll = new B_GuestBook();
        M_GuestBook model = new M_GuestBook();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {

        }

        protected void btnConfirm_Click(object sender, EventArgs e)
        {
            if (txtContent.Text.Trim() == "")
            {
                MyMessageBox.MessageBox("请输入留言内容", this.Page);
            }
            else
            {
                if (txtTitle.Text.Trim() == "")
                    model.Title = CutString.SubStr(txtContent.Text.Trim(), 20);
                else
                    model.Title = txtTitle.Text.Trim();
                model.Content = txtContent.Text.Trim();
                mLog.UserIP = ClientInfo.GetUserIP();
                mLog.URL = Request.Url.AbsoluteUri.ToString();
                mLog.OPInfo = "留言";
                int result = 0;
                if (Request.Cookies["MemberID"] == null)
                {
                    //用户未登陆
                    result = bll.AddGuestBook(model);
                    mLog.Account = "游客";
                    mLog.UserType = 2;
                }
                else
                {
                    model.MemberID = Request.Cookies["MemberID"].Value.ToString();
                    mLog.Account = Request.Cookies["MemberID"].Value.ToString();
                    mLog.UserType = 1;
                    result = bll.AddGuestBookLogined(model);
                }
                if (result > 0)
                {
                    mLog.OPInfo = "留言成功";
                    bLog.AddLog(mLog);
                    MyMessageBox.MessageBox("留言成功", this.Page, "Index.aspx");
                }

                else
                {
                    mLog.OPInfo = "留言失败";
                    bLog.AddLog(mLog);
                    MyMessageBox.MessageBox("留言失败，请重试", this.Page);
                }
            }

        }
    }
}
