﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.Model;
using LZBS.BLL;

namespace LZBS.Web
{
    public partial class Index : System.Web.UI.Page
    {
        protected Control control;
        protected void Page_Load(object sender, EventArgs e)
        {
            BindToRepeaterNews(10);
            BindToDataListProduct(2);
            //if (Request.Cookies["MemberID"] == null)
            //{
            //    Login1.Visible = true;
            //}
            //else
            //{
            //    Login1.Visible = false;
            //    //control = Page.LoadControl("~/Login.ascx");
            //    //Panel1.Controls.Add(control);
            //}
        }

        protected void Page_PreRender(object sender, EventArgs e)
        {
            if (Request.Cookies["MemberID"] == null)
            {
                Login1.Visible = true;
            }
            else
            {
                Login1.Visible = false;
                //动态加载用户控件
                control = Page.LoadControl("~/PersonalInfo.ascx");
                Panel1.Controls.Add(control);
            }
        }


        /// <summary>
        /// 新闻列表绑定
        /// </summary>
        /// <param name="top"></param>
        private void BindToRepeaterNews(int top)
        {
            rptNewsList.DataSource = new B_News().GetTopNews(top);
            rptNewsList.DataBind();
        }
        /// <summary>
        /// 产品绑定列表
        /// </summary>
        /// <param name="top"></param>
        private void BindToDataListProduct(int top)
        {
            dlProduct.DataSource = new B_Product().GetTopProduct(top);
            dlProduct.DataBind();
        }
    }
}
