﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web
{
    public partial class MyReply : System.Web.UI.Page
    {
        B_Reply bll = new B_Reply();
        M_Reply model = new M_Reply();
        B_GuestBook bbook = new B_GuestBook();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {

                /////////////////////////////////////////输入判断语句，是否合法
                if (Request.QueryString["BookID"] == null)
                {
                    Response.Redirect("MyGuestBook.aspx", true);
                }
                model.BookID = Convert.ToInt32(Request.QueryString["BookID"].ToString());
                BindToRepeater(model);
                DataRow dr = bbook.GetGuestBookByBookID(model);
                lblTitle.Text = dr["Title"].ToString();
                lblContent.Text = dr["Content"].ToString();
                lblTime.Text = dr["LeaveDate"].ToString();
                if (dr["MemberID"] != null)
                    lblMemberID.Text = dr["MemberID"].ToString();
            }
        }
        /// <summary>
        /// Repeater绑定数据信息
        /// </summary>
        private void BindToRepeater(M_Reply model)
        {
            rptReply.DataSource = bll.GetReplyInfoByBookID(model);
            rptReply.DataBind();
        }

        protected void lbDelete_Command(object sender, CommandEventArgs e)
        {
            model.ReplyID = Convert.ToInt32(e.CommandName.ToString());
            model.BookID = Convert.ToInt32(Request.QueryString["BookID"].ToString());
            bll.DeleteReplyReplyID(model);
            BindToRepeater(model);
        }

        protected void btnConfirm_Click(object sender, EventArgs e)
        {
            model.Content = txtContent.Text.ToString();
            model.Account = Request.Cookies["MemberID"].Value.ToString();
            model.BookID = Convert.ToInt32(Request.QueryString["BookID"].ToString());

            mLog.UserIP = ClientInfo.GetUserIP();
            mLog.URL = Request.Url.AbsoluteUri.ToString();
            mLog.Account = Request.Cookies["MemberID"].Value.ToString();
            mLog.UserType = 1;

            if (bll.AddReply(model) > 0)
            {
                mLog.OPInfo = "回复留言成功";
                bLog.AddLog(mLog);
                Response.Write( "<script language=javascript>window.location.href=document.URL;</script>" ); 
                MyMessageBox.MessageBox("回复留言成功！", this.Page,true);
            }
            else
            {
                mLog.OPInfo = "回复留言失败";
                bLog.AddLog(mLog);
                MyMessageBox.MessageBox("回复留言失败，请重试！", this.Page);
            }


        }
    }
}
