﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using LZBS.BLL;
using LZBS.Model;
using LZBS.Common;

namespace LZBS.Web
{
    public partial class Password : System.Web.UI.Page
    {
        M_Member model = new M_Member();
        B_Member bll = new B_Member();
        M_SysLog mLog = new M_SysLog();
        B_SysLog bLog = new B_SysLog();
        protected void Page_Load(object sender, EventArgs e)
        {
            if (Request.Cookies["MemberID"] == null)
            {
                Response.Redirect("Login.aspx", true);
            }
            lblMemberID.Text = Request.Cookies["MemberID"].Value.ToString();
        }

        protected void CustomValidator1_ServerValidate(object source, ServerValidateEventArgs args)
        {
            model.MemberID = lblMemberID.Text;
            model.Password = txtOldPwd.Text.Trim();
            args.IsValid=bll.CheckMember(model);
        }

        protected void btnConfirm_Click(object sender, EventArgs e)
        {
            if (Page.IsValid)
            {
                model.MemberID = lblMemberID.Text;
                model.Password = txtNewPwd.Text.Trim();

                mLog.UserIP = ClientInfo.GetUserIP();
                mLog.URL = Request.Url.AbsoluteUri.ToString();
                mLog.Account = Request.Cookies["MemberID"].Value.ToString();
                mLog.UserType = 1;
                if (bll.ChangePassword(model) > 0)
                {
                    mLog.OPInfo = "密码修改成功";
                    bLog.AddLog(mLog);
                    MyMessageBox.MessageBox("密码修改成功", this.Page);
                }
                else
                {
                    mLog.OPInfo = "密码修改失败";
                    bLog.AddLog(mLog);
                    MyMessageBox.MessageBox("密码修改失败", this.Page);
                }
                    
            }
        }
    }
}
