﻿var colNameArr = ['ID', '所属机构', '最高车速(km/h)', '操作'];
var colModelStr = "[" +
                    "{name: 'AI_ID', index: 'AI_ID',sortable: false, align:'center', hidden:true}," +
                    "{name: 'AI_CI_ID', index: 'CI_NAME',sortable: false, align: 'center',width: 75, height: 35}," +
                    "{name: 'AI_SPEED', index: 'DR_REMARK',sortable: false,align:'center', width: 80, height: 35}," +
                    "{name: 'Operate', index: 'Operate',sortable: false,align:'center', width: 100, height: 35}" +
                    "]";
var colModelArr = eval("(" + colModelStr + ")");
$(function () {
    loadGridData();
});

//加载JqGrid数据
function loadGridData() {
    $("#dataShow").jqGrid({
        url: '../Alarm/Handler/AlarmSettingHandler.ashx?flag=0&timeout' + new Date().getTime(),
        mtype: 'GET',
        datatype: "json",
        colNames: colNameArr,
        colModel: colModelArr,
        rowNum: 20,
        rowList: [10,20, 30, 50],
        pager: '#pager',
        sortname: 'AI_ID',
        viewrecords: true,
        multiselect: false,
        sortable: false,
        sortorder: "desc",
        jsonReader: {
            id: "AI_ID", //设置主键列
            page: "page",
            total: "total",
            root: "rows",
            repeatitems: false
        },
        emptyrecords: '无数据',
        altclass: 'jqGridRowStyle',
        height: "100%",
        autowidth: true,
        rownumbers: true,
        mtype: "GET",
        loadtext: '数据加载中，请稍后..',
        loadComplete: function (data) {
            jQuery(this).closest(".ui-jqgrid-bdiv").css({ 'overflow-x': 'hidden' });
            //获得总记录数
            var itemCount = parseInt($(this).getGridParam("records"), 10);
            if (itemCount == 0) {
                //增加一行提示信息
                $(this).addRowData("-1", { "AI_CI_ID": "<span style='color:red;'>当前没有数据！</span>", "": "", "": "" }, "first");
            }
        },
        loadError: function (xhr, status, error) {
            if (xhr.responseText == "sessionmissing") {
                window.top.location = "../_Error/Error.aspx";
            }
        }
    });
}

function search() {
    var AI_SPEED = $("#txt_ALSpeed").val();
    var ci_id = $("#hiddenCiid").val();
    $("#dataShow").jqGrid('setGridParam', {
        url: '../Alarm/Handler/AlarmSettingHandler.ashx?flag=0&' + new Date().getTime()
         + "&AI_SPEED=" + AI_SPEED
        + "&ci_id=" + ci_id
    }).trigger("reloadGrid");
}




function Driver() {
    var url = "Alarm/AddAlarmSetting.aspx";
    tzWindow.open("addASDialog", "新建最高车速报警", url);
   // myWinOpen("addASDialog", "新建最高车速报警", '374', '230', url);
}

function updateData(id) {
    var url = "Alarm/AddAlarmSetting.aspx?id=" + id;
    tzWindow.open("addASDialog", "修改最高车速报警", url);
    //myWinOpen("addASDialog", "修改最高车速报警", '374', '230', url);
}


function deleteData(id) {
    if (!confirm('确认删除？')) { return; }
    $.ajax({
        type: "get",
        url: "Handler/AlarmSettingHandler.ashx?flag=3&timeout=" + new Date().getTime(),
        data: { AI_ID: id },
        success: function (data) {
            if (data == "sessionmissing") {
                window.top.location = "../_Error/Error.aspx";
                return;
            }

            if (data == "1") {
                search();
            }
            else {
                alert("删除！请稍后操作");
                return false;
            }
        }

    });
} 