﻿/*Function:My97的二次开发
*author:yh
*date:2011/08/08
*使用时将页面布局尽量不做改动[即便要做修改，也尽量不要对ID作变动]
*页面首先应该引用jQuery库文件，之后需要引用my97的js库文件[my97的整个文件包必须完整且无改动]
*只需在页面上给触发显示日期选择的按钮注册点击事件，调用如下showDatePickerFun(...)函数或即可，参数说明如下注释
*然后给selectComplete(...)函数中的处理天、周、月的各个方法注册回调函数即可
*/

/*
*API接口方法
*/
function showDatePickerFun(rangeNum, x1, y1, x2, y2) {
    //绑定弹出日历控件的按钮，采用绑定方式，为了设备操作等其他需要自定义弹出日历的
    //页面可以解除绑定，并重新自定义实现逻辑
    $("#div_datePick").show('fast');
    
    var btnDatePicker = document.getElementById("btn_showDatePicker");
    if (typeof (btnDatePicker) != "undefined" && btnDatePicker != null) {
        if (btnDatePicker.style.display != "none") {
        //修改整个日历区域都为触发日历弹出的可点击区域
        //并且点击可切换隐藏和显示  Modified By:yh  Date:11/08/19
            $(".calendar_s").toggle(function() {
                showCalendar(rangeNum, x1, y1, x2, y2);
            },
            function() {
                hideCalendar();
            });
        }
    }
}

function showCalendar(rangeNum, x1, y1, x2, y2) {
    $('#div_showDate').show('fast');

    //注册文本框的焦点事件(并设置日历控件的默认呈现)
    registerFocusEvent(rangeNum, x1, y1, x2, y2);

    $('#select_datetype').change(function() {
        registerFocusEvent(rangeNum, x1, y1, x2, y2);
    });

}

function hideCalendar() {
    $('#div_showDate').hide('fast');
}

//根据选择，重新绑定焦点事件
//参数设置：
//rangeNum:日期范围，默认为一周(7)
//x1:设置开始日期时，日期控件的left值【距离浏览器左侧的距离】
//y1:设置开始日期时，日期控件的top值【距离浏览器窗口顶端的距离】
//x2:设置截止日期时，日期控件的left值【距离浏览器左侧的距离】
//y2:设置截止日期时，日期控件的top值【距离浏览器窗口顶端的距离】
function registerFocusEvent(rangeNum, x1, y1, x2, y2) {
    var dateType = $('#select_datetype').val();
    clearFocusEvent(); //清空焦点的事件
    clearInputText(); //清空输入框中的值
    switch (dateType) {
        case "0":
            focusDayCalendarShow(rangeNum, x1, y1, x2, y2);
            break;
        case "1":
            focusWeekCalenderShow(rangeNum, x1, y1, x2, y2);
            break;
        case "2":
            focusMonthCalendarShow(rangeNum, x1, y1, x2, y2);
            break;
    }
}

//显示格式为:日期-日历,加入日期范围的限制
function focusDayCalendarShow(rangeNum, x1, y1, x2, y2) {
    $('#input_from').focus(function() {
        WdatePicker({
            position: { left: x1, top: y1 },
            readyonly: true,
            startDate: '%y-%M-%d 00:00:00',
            dateFmt: 'yyyy-MM-dd HH:mm:ss',
            errDealMode: 1,
            onpicked: function() { $dp.$('input_to').focus(); }, //$dp.$是一个内置函数,相当于document.getElementById
            minDate: '#F{$dp.$D(\'input_to\',{d:-' + rangeNum + '});}', //设置开始日期的最小值为：截止日期减七
            maxDate: '#F{$dp.$D(\'input_to\',{d:0});}'//设置开始日期的最大值为：截止日期的值
        });
    });
    $('#input_to').focus(function () {
        WdatePicker({
            position: { left: x2, top: y2 },
            readyonly: true,
            startDate: '%y-%M-%d 23:59:59',
            dateFmt: 'yyyy-MM-dd HH:mm:ss',
            errDealMode: 1,
            maxDate: '#F{$dp.$D(\'input_from\',{d:' + rangeNum + '});}', //设置截止日期的最大值为：开始日期加七
            minDate: '#F{$dp.$D(\'input_from\',{d:0});}'//设置截止日期的最小值为：开始日期
        });
    });
}

//显示格式为:周-日历,加入日期范围的限制
function focusWeekCalenderShow(rangeNum, x1, y1, x2, y2) {
    $('#input_from').focus(function() {
        WdatePicker({
            firstDayOfWeek: 1,   //设置一个星期的第一天为日！值范围为0-6
            isShowWeek: true,
            position: { left: x1, top: y1 },
            readyonly: true,
            dateFmt: 'WW, yyyy-MM-dd',
            minDate: '#F{$dp.$D(\'input_to\',{d:-' + rangeNum + '*7});}', //设置开始周的最小值为：截止周减去七乘以7(一周的天数)
            maxDate: '#F{$dp.$D(\'input_to\',{d:0});}'//设置开始周的最大值为：截止周的值
        });
    });

    $('#input_to').focus(function() {
        WdatePicker({
            firstDayOfWeek: 1,   //设置一个星期的第一天为日！值范围为0-6
            isShowWeek: true,
            position: { left: x2, top: y2 },
            readyonly: true,
            dateFmt: 'WW, yyyy-MM-dd',
            maxDate: '#F{$dp.$D(\'input_from\',{d:' + rangeNum + '*7});}', //设置截止周的最大值为：开始周加七乘以7(一周的天数)
            minDate: '#F{$dp.$D(\'input_from\',{d:0});}'//设置截止周的最小值为：开始周
        });
    });
}

//显示格式为:月-日历,加入日期范围的限制
function focusMonthCalendarShow(rangeNum, x1, y1, x2, y2) {
    $('#input_from').focus(function() {
        WdatePicker({
            isShowWeek: false,
            position: { left: x1, top: y1 },
            readyonly: true,
            dateFmt: 'yyyy-MM',
            minDate: '#F{$dp.$D(\'input_to\',{M:-' + rangeNum + '});}', //设置开始月份的最小值为：截止月份减七
            maxDate: '#F{$dp.$D(\'input_to\',{M:0});}'//设置开始月份的最大值为：截止月份的值
        });
    });

    $('#input_to').focus(function() {
        WdatePicker({
            isShowWeek: false,
            position: { left: x2, top: y2 },
            readyonly: true, dateFmt: 'yyyy-MM',
            maxDate: '#F{$dp.$D(\'input_from\',{M:' + rangeNum + '});}', //设置截止月份的最大值为：开始月份加七
            minDate: '#F{$dp.$D(\'input_from\',{M:0});}'//设置截止月份的最小值为：开始月份
        });
    });
}

//清除绑定事件
function clearFocusEvent() {
    $('#input_from,#input_to').unbind('focus');
}

//清空输入框中的值
function clearInputText() {
    $('#input_from,#input_to').val('');
}

//定义选择完成的回调方法--注：selectComplete由使用者自行定义，这里只是将选择的日期的值提供出去
function sure(selectComplete) {
    if (typeof (MAP_OPTIONS) != "undefined" && MAP_OPTIONS != null) {
        MAP_OPTIONS = null;
        FIRST_PLAY = true;
        CURRENT_PAGE = 0;
        LOADED = 0;
        TMap.Map.removeAllOverlays();
        $("#pauseandcont").removeClass('pause');
        $("#pauseandcont").addClass('star');
        $("#pauseandcont_a").attr("title", "播放");
    }
    var s_date = $('#input_from').val();
    var e_date = $('#input_to').val();

    if (typeof (selectComplete) != "undefined" && s_date != "" && e_date != "") {
        //判断日期类型0:天，1：周，2：月
        var dateType = 0;
        if (s_date.indexOf(',') != -1 && e_date.indexOf(',') != -1) {
            dateType = 1;
        }
        else if (s_date.lastIndexOf('-') == 4 && e_date.lastIndexOf('-') == 4) {
            dateType = 2;
        }
        selectComplete(s_date, e_date, dateType);
        hideCalendar();
    }
}

/*
*里程分析页面的回调方法
*/
//设置日期范围选择的“确定”按钮的回调方法
var selectComplete = function(sdate, edate, dt) {
    switch (dt) {
        case 0:
            if (typeof (handleDateOfDay) != "undefined") {
                handleDateOfDay(sdate, edate, dt);
            }
            break;
        case 1:
            if (typeof (handleDateOfWeek) != "undefined") {
                handleDateOfWeek(sdate, edate, dt);
            }
            break;
        case 2:
            if (typeof (handleDateOfMonth) != "undefined") {
                handleDateOfMonth(sdate, edate, dt);
            }
            break;
    }  
};


