﻿$(function () {
    customizeDatePicker();
    //var loadTableDataInterval = setInterval(function () { $.pager.reset(); loadData(1); }, 180000);   
});

var startDate, endDate;
function loadData(index) {
   var guid = $("#hidGuid").val();
   $.ajax({
       type: "get",
       url: "Handler/LgHandler.ashx?getTrackTable=true",
       data: { guid: guid, pageIndex: index, startDate: $("#hidStartDate").val(), endDate: $("#hidEndDate").val() },
       dataType: "text",
       success: function (data) {
           $("#loadDataMsg").hide();
           if (data == "sessionmissing") {
               window.top.location = "../_Error/Error.aspx";
               return "";
           }
           if (data == "") {
               $("#tbodylist").html("<tr><td colspan='12' style='color:Red'><span>无数据</span></td></tr>");
               $.pager.init(0);
               return;
           }
           var result = data.split('@');
           $("#tbodylist").html(result[0]);
           var allRecords = parseInt(result[1]);
           $.pager.init(allRecords);
       }
   });
}

//设置默认时间范围
function setDefaultDate() {
    startDate = document.getElementById("hidStartDate").value;
    endDate = document.getElementById("hidEndDate").value;
    $('#span_date').text(startDate + " -- " + endDate);
    //加载线路
    loadTrackLine(startDate, endDate);
    //加载列表
    //loadData($.pager.indexpage, startDate, endDate);
    //活动状态
   // resizeActivityBar();
}
function customizeDatePicker() {
    //显示日历            
    showDatePickerFun(6, 340, 98, 355, 122);
    if (document.getElementById('select_datetype').style.display != "none") {
        document.getElementById('select_datetype').style.display = "none";
    }
    if (document.getElementById('span_select').style.display != "none") {
        document.getElementById('span_select').style.display = "none";
    }
    //设置默认时间范围
    setDefaultDate();
}

//日历控件的回调方法：处理天
function handleDateOfDay(sdate, edate, dt) {
    startTime = sdate;
    endTime = edate;
    if (typeof (dt) != "undefined")
        dateType = dt;
    if (startTime == "" || endTime == "") {
        return;
    }
    var minTime = document.getElementById("hidStartDate").value, maxTime = document.getElementById("hidMaxDate").value;
    if (sdate < minTime || edate > maxTime) {
        alert("该车只能查看 " + minTime + " 到 " + maxTime + "的轨迹信息");
        return;
    }
    document.getElementById("hidStartDate").value = sdate;
    document.getElementById("hidEndDate").value = edate;
    $('#span_date').text(startTime + " -- " + endTime);
    //获取轨迹
    loadTrackLine(sdate, edate);
    //获取列表
    $.pager.reset();
    //loadData(1);
    //活动状态列表加载
    resizeActivityBar();
}

function loadTrackLine(sdate, edate) {
    var guid = $("#hidGuid").val();
    $.ajax({
        type: "get",
        url: "Handler/LgHandler.ashx?getTrackGPS=true",
        dataType: "text",
        data: { guid: guid, startDate: sdate, endDate: edate, lgState: $('#hidLgState').val() },
        success: function (data) {
            var result = $.parseJSON(data);
            if (result.dataJson.length > 0) {
                tzMap.addMarker({ id: 'startA', lng: result.dataJson[0].lng, lat: result.dataJson[0].lat, content: '', icon: '../_Css/images/start.png', sizeX: 15, sizeY: 33 });
                var index = result.dataJson.length - 1;
                tzMap.addMarker({ id: 'EndB', lng: result.dataJson[index].lng, lat: result.dataJson[index].lat, content: '', icon: '../_Css/images/end.png', sizeX: 15, sizeY: 33 });
            }
            trackData = result.dataJson;
            //显示里程
            if ($('#hidLgState').val() == "2" || $('#hidLgState').val() == "3") {
                var licheng = "单程物流行驶里程数：" + result.licheng + "km";
                $('#Mileage').text(licheng);
            }
            tzMap.removeById('GLFeature');
            tzMap.addLine(result.dataJson, true, "line_trackview");
        }
    });
}

$(document).ajaxStart(function () {
    $.blockUI({
        message: '<image src="../_Css/images/loading.gif"></image>',
        css: {
            width: "20px",  
            top: "50%",
            left: "50%"
        }
    });   
});
$(document).ajaxStop(function () {
    $.unblockUI();
    //$("#table-content").show();
});

function resizeActivityBar() {   
    var hidstartDate = document.getElementById("hidStartDate").value;
    var hidendDate = document.getElementById("hidEndDate").value;
    var guid = document.getElementById("hidGuid").value;
    getTrackActive(guid, hidstartDate, hidendDate);    
}

function getTrackActive(guid, startDate, endDate) {
    $.ajax({
        type: "GET",
        url: "Handler/LgStockHandler.ashx?getTrackActive=true&startDate=" + startDate + "&endDate=" + endDate + "&guid=" + guid,
        cache: false,
        success: function (data) {
            $(".active-day").hide();
            var result = $.parseJSON(data);
            for (var i = 0; i < result.length; i++) {
                $(".active-day:eq(" + i + ") .headerspace").text(result[i].day);
                $(".active-day:eq(" + i + ") div").remove();
                $(".active-day:eq(" + i + ")").append(result[i].Info);
                $(".active-day:eq(" + i + ")").show();
            }
            bindActiveClickFun();
        }
    });
}
var trackData;
function showGLLine(stime, etime) {

    if (trackData == null || typeof trackData == undefined || trackData.length == 0) {
        return;
    }
    var lineArray = new Array();

    for (var i = 0; i < trackData.length; i++) {
        var mytime = trackData[i].time;

        if (mytime > etime) {
            break;
        }

        if (mytime > stime) {
            lineArray.push(trackData[i]);
            continue;
        }        
    }   
    tzMap.polylineOption.strokeColor = "#50A035";
    tzMap.polylineOption.strokeWeight = 4;
    tzMap.addLine(lineArray, true, 'GLFeature');
    tzMap.setZoomAndCenter(lineArray[0].lng, lineArray[0].lat, tzMap.map.getZoom());
    tzMap.polylineOption.strokeColor = "#0000FF";
    tzMap.polylineOption.strokeWeight = 2;
}

function bindActiveClickFun() {
    $(".sprun").click(function () {
        tzMap.removeById('GLFeature');
        var info = $(this).attr("info").split(',');
        showGLLine(info[0], info[1]);
    });

    $(".spstop").click(function () {
        tzMap.removeById('GLFeature');
        var info = $(this).attr("info");       
        var latLng = info.split(',');
        tzMap.addMarker({ id: 'GLFeature', lng: latLng[1], lat: latLng[0], content: '', icon: '../_Css/images/stop.png', sizeX: 7, sizeY: 18, becenter: true });
    });
}