﻿$(function () {
    $('#btnSign').attr("disabled", "disabled");
    $('#btnOutSign').attr("disabled", "disabled");
    loadData();
    $("#btn_search").click(function () {
        searchLg();
    });

    $("#btn_vehsearch").click(function () {
        $("#loadDataMsg").show();
        window.frames["LgStock"].searchData();
    });

    if ($.browser.msie) {
        $("input[type='text']").css("width", "135px");
    }
    //表头绑定查询方法 设备编号
    $("#txtDeviceId").keypress(function (event) {
        if (event.which == 13) {
            searchLg();
        }
    });
    //表头绑定查询方法 物流通知
    $("#txtLgNotice").keypress(function (event) {
        if (event.which == 13) {
            searchLg();
        }
    });
    //表头绑定查询方法 物流公司
    $('#selLgCom').change(function () { searchLg(); });
});




//查询
function searchLg() {
    orderIndex = 0;
    $("#loadDataMsg").show();
    $.pager.reset();
    loadData();
    $("#time1").text('预计收货日期▲▼');
    $("#time2").text(' 发货时间▲▼');
    $("#time3").text('签收时间▲▼');
    //设置按钮的disable
    switch ($('#selLgStatus').val()) {
        case "-1":
            $('#btnSign').attr("disabled", "disabled");
            $('#btnOutSign').attr("disabled", "disabled");
            break;
        case "1":
            $('#btnSign').attr("disabled", false);
            $('#btnOutSign').attr("disabled", "disabled");
            break;
        case "2":
            $('#btnSign').attr("disabled", "disabled");
            $('#btnOutSign').attr("disabled", false);
            break;
        case "3":
            $('#btnSign').attr("disabled", "disabled");
            $('#btnOutSign').attr("disabled", "disabled");
            break;
    }
}

function loadData() {
    var deviceId = $("#txtDeviceId").val() == "设备编号" ? "" : $("#txtDeviceId").val();
    var orderNo = $("#txtOrderNo").val();
    var lgComId = $("#selLgCom").val();
    var lgStatus = $('#selLgStatus').val();
    var lgNotice = $('#txtLgNotice').val() == "发车通知" ? "" : $("#txtLgNotice").val();
    $("#popoverRemark").hide();

    $.ajax({
        type: "get",
        url: "Handler/LgHandler.ashx?getLgTodaySignInfo=true",
        dataType: "text",
        data: { deviceId: deviceId, orderNo: orderNo, lgComId: lgComId, lgStatus: lgStatus, lgNotice: lgNotice, orderIndex: orderIndex, pageIndex: $.pager.indexpage },
        success: function (data) {
            $("#loadDataMsg").hide();
            if (data == "sessionmissing") {
                window.top.location = "../_Error/Error.aspx";
                return;
            }
            if (data == "") {
                $("#tbodylist").html("<tr><td colspan='12' style='color:Red'><span>无数据</span></td></tr>");
                $.pager.init(0);
                return;
            }
            var result = data.split('@');
            $("#tbodylist").html(result[0]);
            var allRecords = parseInt(result[1]);
            $.pager.init(allRecords);
            //alert(allRecords);
        }

    });
}

//排序
var orderIndex = 0;

//排序
function orderByIndex(num) {
    orderIndex = num;
    loadData();
}

//排序按钮初始化
$(function () {
    $("#time1").toggle(function () {
        $("#time1").text('预计收货日期▲');
        $("#time2").text(' 发货时间▲▼');
        $("#time3").text('签收时间▲▼');
        orderByIndex(1);
    }, function () {
        $("#time1").text('预计收货日期▼');
        $("#time2").text(' 发货时间▲▼');
        $("#time3").text('签收时间▲▼');
        orderByIndex(-1);
    });
    $("#time2").toggle(function () {
        $("#time2").text(' 发货时间▲');
        $("#time3").text('签收时间▲▼');
        $("#time1").text('预计收货日期▲▼');
        orderByIndex(2);
    }, function () {
        $("#time2").text(' 发货时间▼');
        $("#time3").text('签收时间▲▼');
        $("#time1").text('预计收货日期▲▼');
        orderByIndex(-2);
    });
    $("#time3").toggle(function () {
        $("#time3").text('签收时间▲');
        $("#time1").text('预计收货日期▲▼');
        $("#time2").text(' 发货时间▲▼');
        orderByIndex(3);
    }, function () {
        $("#time3").text('签收时间▼');
        $("#time1").text('预计收货日期▲▼');
        $("#time2").text(' 发货时间▲▼');
        orderByIndex(-3);
    });
});

function getSelectedId() {
    var Id = "";
    $("tbody .chk:checked").each(function (e) {
        Id += $(this).val() + ",";
    });

    return Id;
}
//显示备注
function ShowDesc(item, e) {
    $("#popoverRemark").show();
    //$("#popoverRemark .popover-content").text($(item).next().val());
    $('#remark').val($(item).next().val());
    $('#guidHidden').val($(item).next().next().val());
    var pwidth = $("#popoverRemark").width();

    var mye = mousePosition(e);
    $("#popoverRemark").css("left", mye.x - pwidth - 10);
    $("#popoverRemark").css("top", mye.y - 66);
}

function mousePosition(ev) {//返回一个类
    if (ev.pageX || ev.pageY) {
        return { x: ev.pageX, y: ev.pageY };
    }
    return {
        x: ev.clientX + document.body.scrollLeft - document.body.clientLeft,
        y: ev.clientY + document.body.scrollTop - document.body.clientTop
    }
}

//保存备注
function updateRemark() {
    $.get("Handler/LgHandler.ashx?updateLgReamrk=true", { lgremark: $("#remark").val(), vi_guid: $('#guidHidden').val() }, function (data) {
        if (data == "true") {
            alert("保存成功!");
            $('#popoverRemark').hide();
            loadData();
        }
        else {
            alert("保存失败!");
        }
    });
}


//批量取消签收
function CancelSign(){
    var id = getSelectedId();
    if (id == "") {
        alert("请选择撤销签收车辆！");
    }
    else {
        $.ajax({
            type: "get",
            url: "Handler/LgHandler.ashx?cancelVehSign=true",
            data: { guidStr: id },
            success: function (data) {
                if (data == "true") {
                    alert("撤销签收成功！");
                } else {
                    alert("撤销签收失败!");
                }
                loadData();
             }
        });
    }
}

//单个取消签收
function CancelSingleSign(guid) {
    if (!confirm("确定撤销签收吗?")) {
        return;
    }
    $.ajax({
        type: "get",
        url: "Handler/LgHandler.ashx?cancelVehSign=true",
        data: { guidStr: guid },
        success: function (data) {
            if (data == "true") {
                alert("撤销签收成功！");
            } else {
                alert("撤销签收失败!");
            }
            loadData();
        }
    });
}



