﻿TMap = {
    Map: {},
    managers: {},
    defaults: {},    
    add: function (manager) {
        if (arguments.length == 2) {
            var m = arguments[1];
            if (!this.managers[arguments[0]]) this.managers[arguments[0]] = m;
            return;
        }
        if (this.managers[manager.id]) throw new Error('管理器id已经存在');
        this.managers[manager.id] = manager;
    },
    remove: function (arg) {
        if (typeof arg == "string" || typeof arg == "number") {
            delete TMap.managers[arg];
        } else if (typeof arg == "object") {
            delete TMap.managers[arg.id];
        }
    },
    get: function (arg, idAttrName) {
        idAttrName = idAttrName || "mapFid";
        if (typeof arg == "string" || typeof arg == "number") {
            return TMap.managers[arg];
        } else if (typeof arg == "object") {
            return TMap.managers[arg.id];
        }
        return null;
    }
};

TMap.Map = {
    mapType: 'mapABC',
    map: null,
    mapObjct: null,
    initialise: function (inOptions) {
        var $mapDiv = $("#" + inOptions.mapDiv);
        $mapDiv.css({ width: inOptions.mapWidth, height: inOptions.mapHeight });
        this.createMap($mapDiv, inOptions.mapOptions);
    },
    createMap: function ($mapDiv, inOptions) {
        inOptions.center = new MMap.LngLat(inOptions.center.lng, inOptions.center.lat);

        if (!TMap.get(this.mapType)) {
            this.map = new MMap.Map($mapDiv.get(0), inOptions)
            TMap.add(this.mapType, this.map);
        }
    },
    //绘制静态路线
    drawStaticLineInMap: function (options) {
        var arr = new Array();
        if (options instanceof Array)//判断是否是多点对象
        {
            for (var opt in options) {
                if (typeof options[opt] == "object")//判断是否是对象
                {
                    var option = options[opt];
                    var latlng = new MMap.LngLat(option.latlng.lng, option.latlng.lat);
                    arr.push(latlng);
                }
            }
        }

        var line_id = 'polyline01';
        //var line_color = '#0000FE';
        var line_color = '#0817e0';

        var line = {
            id: 'polyline_' + String(CURRENT_PAGE),
            path: arr,
            strokeColor: line_color,
            strokeOpacity: 0.7,
            strokeWeight: 3,
            strokeStyle: "solid"
        };

        var myPolyline = new MMap.Polyline(line);      //在地图上画线
        if (myPolyline != null) {
            //  this.map.clearOverlays();               //删除地图对象上所有覆盖物
            this.map.addOverlays(myPolyline);        //向地图添加覆盖物
            this.map.setFitView();                  //地图视野自适应
        }
    },
    //绘制动态路线
    drawDynamicLineInMap: function (options) {
        options.id = 'myOptions';
        var myOptions = TMap.get(options.id);
        if (myOptions != null)
            TMap.remove(options.id);

        TMap.add(options);

        var markers = options; //获取markers
        var arr = new Array();
        if (markers instanceof Array)//判断是否是多点对象
        {
            for (var opt in markers) {
                if (typeof markers[opt] == "object")//判断是否是对象
                {
                    var option = markers[opt];
                    var latlng = new MMap.LngLat(option.latlng.lng, option.latlng.lat);
                    arr.push(latlng);
                }
            }
        }

        options.arr = arr;

        TMap.add("start", arr[0]);             //存储开始点        
        TMap.add("vehspeed", 1000);            //设置轨迹回放默认速度
        TMap.add("points" + this.mapType, arr); //所有的点标记存储起来

        //在地图上画线
        var mylineOptions = {
            strokeColor: "#1791fc",
            strokeWeight: 2,
            mapObj: this.map,
            arr: arr
        };

        var myPolyline = new MMap.Polyline(mylineOptions);

        //存储线对象
        if (TMap.get("mypolyline")) {
            TMap.remove("mypolyline");
        }
        TMap.add("mypolyline", myPolyline);

        var index = TMap.get('arrindex');
        if (!index) {
            index = 0;
            TMap.add("arrindex", 0); //存储暂停点
        }

        //合并marker数据
        if (index >= arr.length) {
            index = arr.length - 1;
        }
        this.createMarker(index); //创建并存储marker

        //存储点
        TMap.add("playspendtype", 0);

        this.historicalRouteContinue();
    },
    //创建浮框
    createMarker: function (index) {
        //        if (myMarker != null) {
        //            this.map.clearOverlays()
        //        }
        var mapFOptions = TMap.get('myOptions');

        //构造marker对象        
        var option = mapFOptions[index];
        var latlng = new MMap.LngLat(option.latlng.lng, option.latlng.lat);

        //构造图标
        var icon_path = '../_Css/images/run 1.png';
        //var marker_id = 'marker_' + option.id;
        var marker_id = 'markerT';
        var myMarker = new MMap.Marker({
            id: marker_id,
            position: latlng,
            icon: icon_path,
            offset: new MMap.Pixel(-10, -14),
            draggable: false,
            content: ''
        });

        //构造浮框        
        var con = this.getMarkerContent(option);
        var infoWindow = new MMap.InfoWindow({ autoMove: true });
        infoWindow.setContent(con);
        infoWindow.open(this.map, latlng);

        this.map.addOverlays(myMarker);

        //保存最后一个markder的id
        if (TMap.get("lastmarkerid"))
            TMap.remove("lastmarkerid");

        TMap.add("lastmarkerid", marker_id);
    },
    //获取浮框的HTML
    getMarkerContent: function (option) {
        var d_speed = this.formatSpeed(option.speed);
        var d_status = '';
        switch (option.status) {
            case 0:
                d_status = '工作';
                break;
            case 2:
                d_status = '怠速';
                break;
            case 3:
                d_status = '停止';
                break;
            case 4:
                d_status = '离线';
                break;
            default:
                d_status = '行驶';
                break;
        }

        //      var con ;
        //        con +== "车牌号：";
        //        con += option.licence;
        //        con += "<br/>车型：";
        //        con += option.vehType;
        //        con += "<br/>";
        var con = "位置：";
        con += option.address;
        con += "<br/>速度：";
        con += d_speed;
        con += "km/h<br/>gps时间：";
        con += option.time;
        con += "<br/>状态：";
        con += d_status;

        return con;
    },
    //获取行驶状态图标
    getWorkIcon: function (status) {
        return "/images/vehicleStatus/big_xingshi.png";
    },
    //清楚地图覆盖物以及定时器
    removeAllOverlays: function () {
        if (TMap.get('timeid') != null) {
            clearInterval(TMap.get('timeid'));
            TMap.remove('timeid');
        }
        var tempPoint = TMap.get("points" + this.mapType);
        if (tempPoint) {
            TMap.remove("points" + this.mapType);
        }
        var tempPoint = TMap.get("arrindex");
        if (tempPoint) {
            TMap.remove("arrindex");
        }
        var tempPoint = TMap.get("vehspeed");
        if (tempPoint) {
            TMap.remove("vehspeed");
        }
        var tempPoint = TMap.get("start");
        if (tempPoint) {
            TMap.remove("start");
        }

        this.map.clearOverlays()
    },
    //轨迹回放开始
    historicalRouteStart: function () {
        //清除最后播放的图标
        var marker_id = TMap.get("lastmarkerid");
        this.map.removeOverlays(marker_id);

        //初始化地图开始索引
        TMap.managers["arrindex"] = 0;
        //获取轨迹回访时间间隔
        var timesInterval = TMap.get('vehspeed');

        if (TMap.get('timeid') != null) {
            clearInterval(TMap.get('timeid'));
            TMap.remove('timeid');
        }
        var timeid = setInterval(function () { TMap.Map.setMarkerposition(); }, timesInterval); //按线路移动点
        TMap.add("timeid", timeid);
    },
    //设置浮框位置
    setMarkerposition: function () {
        var myLiner = TMap.get('points' + this.mapType);   //点坐标集合
        var myMpa = this.map;

        var allLength = myLiner.length;
        var index = TMap.get('arrindex');
        var percent = $("#spendPercent").attr("values");        //获取滚动进度
        var flag = $("#spendPercent").attr("flag")
        if (percent && flag) {
            $("#spendPercent").removeAttr("flag")
            var tempIndex = Math.ceil(allLength * percent);
            if (TMap.get('arrindex')) {
                TMap.remove('arrindex');
            }
            index = tempIndex;
            TMap.add('arrindex', index);
        }

        if (index >= allLength) {
            AddMapOptions();
            TMap.managers["arrindex"] = 0;
            TMap.remove('points' + this.mapType);
            if (TMap.get('timeid')) {
                clearInterval(TMap.get('timeid'));
                TMap.remove('timeid');
            }
            if (CURRENT_PAGE >= TOTAL_PAGES) {

                TMap.managers["arrindex"] = 0;
                //设置进度条
                $("#spendPercent").css({ "width": "100%" });

                $("#spendPercent").attr("title", "100%");
                $("#pauseandcont").removeClass('pause');
                $("#pauseandcont").addClass('star');
                $("#pauseandcont_a").attr("title", "播放");
            }
            return;
        }

        //设置图标的位置
        if (myLiner) {
            var options = TMap.get('myOptions');
            var option = options[index];
            var line = myLiner[index];
            var latlng = new MMap.LngLat(option.latlng.lng, option.latlng.lat);

            var marker_id = '';
            if (index == 0) {
                var opt = options[options.length - 1];
                marker_id = opt.id;
            } else {
                var opt = options[index - 1];
                marker_id = opt.id;
            }
            this.map.removeOverlays('marker_' + marker_id);
            this.createMarker(index);

            //设置线路
            var bounds = this.map.getBounds();
            if (line.lng <= bounds.southwest.lng || line.lng >= bounds.northeast.lng || line.lat <= bounds.southwest.lat || line.lat >= bounds.northeast.lat) {
                this.map.panTo(line);
            }

            //设置进度条
            ++index;
            var tmpPercent = 0;
            //            if (CURRENT_PAGE == TOTAL_PAGES+1) {
            if (LOADED == 1) {
                tmpPercent = (index / allLength) * 100;
            } else {
                tmpPercent = (CURRENT_PAGE - 1 + index / allLength) / TOTAL_PAGES * 100;
            }
            tmpPercent = Number(tmpPercent).toFixed(1);
            $("#spendPercent").css({ "width": tmpPercent + "%" });
            $("#spendPercent").attr("title", tmpPercent + "%");

            //保存mark点位置
            TMap.managers["arrindex"] = index;
        }
    },
    //轨迹回放暂停
    historicalRoutesPause: function () {
        clearInterval(TMap.get('timeid'));
    },
    //轨迹回放继续
    historicalRouteContinue: function () {
        //获取轨迹回访时间间隔
        var timesInterval = TMap.get('vehspeed');
        if (TMap.get('timeid')) {
            clearInterval(TMap.get('timeid'));
            TMap.remove('timeid');
        }
        var timeid = setInterval(function () { TMap.Map.setMarkerposition(); }, timesInterval); //按线路移动点
        TMap.add("timeid", timeid);
    },
    //轨迹回放时间设置
    historicalRouteSet: function (inTime) {
        var myplaytype = TMap.get('playspendtype');    //获取播放速度类型值0：正常，1：1倍速度；2：2倍速度；3：3倍速度

        if (myplaytype == "0") {
            TMap.managers["vehspeed"] = 1500;
            TMap.managers["playspendtype"] = 1;
        }
        if (myplaytype == "1") {
            TMap.managers["vehspeed"] = 1000;
            TMap.managers["playspendtype"] = 2;
        }
        if (myplaytype == "2") {
            TMap.managers["vehspeed"] = 500;
            TMap.managers["playspendtype"] = 3;
        }
        if (myplaytype == "3") {
            TMap.managers["vehspeed"] = 2000;
            TMap.managers["playspendtype"] = 0;
        }

        //获取轨迹回访时间间隔
        var timesInterval = TMap.get('vehspeed');

        if (TMap.get('timeid') != null) {
            clearInterval(TMap.get('timeid'));
            TMap.remove('timeid');
        }
        var timeid = setInterval(function () { TMap.Map.setMarkerposition(); }, timesInterval); //按线路移动点
        TMap.add("timeid", timeid);
    },
    //保留2位小数，如：2，会在2后面补上00.即2.00  
    formatSpeed: function (x) {
        var f = parseFloat(x);
        if (isNaN(f)) {
            return false;
        }
        var f = Math.round(x * 100) / 100;
        var s = f.toString();
        var rs = s.indexOf('.');
        if (rs < 0) {
            rs = s.length;
            s += '.';
        }
        while (s.length <= rs + 2) {
            s += '0';
        }

        return s;
    }
}