﻿// create by 王君涛 2012.07
// 图标hover css
$(function () {
    var sessionFlag = $("#hidSession").val();
    if (sessionFlag == "sessionmissing") {
        window.top.location = "../_Error/Error.aspx";
        return;
    }
    //hand
    $(".hand").hover(
    function () {
        $('#hand_img').css('margin-top', '-26px');
    },
    function () {
        $('#hand_img').css('margin-top', '0px');
    });
    //polygon
    $(".polygon").hover(
    function () {
        $('#polygon_img').css('margin-top', '-26px');
    },
    function () {
        $('#polygon_img').css('margin-top', '0px');
    });

    //square
    $(".square").hover(
    function () {
        $('#square_img').css('margin-top', '-26px');
    },
    function () {
        $('#square_img').css('margin-top', '0px');
    });
    //ellipse
    $(".ellipse").hover(
    function () {
        $('#circle').css('margin-top', '-26px');
    },
    function () {
        $('#circle').css('margin-top', '0px');
    });

    $(".line").hover(function () {
        $('#line').css('margin-top', '-26px');
    }, function () {
        $('#line').css('margin-top', '0px');
    });

    var type = document.getElementById('type');  
});

//手形按钮点击事件
function moveOperate() {
    $("#spanTitle").text("可通过鼠标拖动选择区域。");   
    tzMap.clearMap();  
    $("#btn_save").attr("disabled", "disabled").removeClass("hover_save").addClass("btn_save");
}

//选择画刷
function ChooseBrush(graphType) {
    var drawStepMsg = "";
    if (graphType == 1) {
        drawStepMsg = "单击开始 --> 移动鼠标绘图 --> 多次点击选择点 --> 双击完成 。";
    }
    else if (graphType == 2) {
        drawStepMsg = "单击开始 -->  拖动鼠标绘图 --> 双击完成。";
    } else {
        drawStepMsg = "单击开始 -->  拖动鼠标绘图 --> 双击完成。";
    }
    $("#spanTitle").text(drawStepMsg);    
    tzMap.clearMap();    
    tzDraw.drawFence(graphType);
    $("#btn_save").attr("disabled", "disabled").removeClass("hover_save").addClass("btn_save");
}

function ShowMessage(message) {
    $("#div_tip").css("display", "block");
    $("#span_tip").text(message).stop(false, true).fadeIn(0).fadeOut(10000);
}


function SaveDistrict() {
    var vValidate = $("#txt_title").val();
    if (vValidate == "" || vValidate.length == 0) {
        ShowMessage("请输入名称！");
        $("#txt_title").focus();
        return false;
    }
    if (vValidate.length > 50) {
        ShowMessage("输入名称过长！");
        $("#txt_title").focus();
        return false;
    }
    if (!checkInputControlValue()) {
        ShowMessage("您输入内容含有非法字符！");
        $("#txt_title").focus();
        return false;
    }
    var districtName="";

    districtName = $("#txt_title").val().replace(/(^\s+)|(\s+$)/g, "");
    var ciid = getUrlParam('ciid');
    var mtdid = $("#mtdid").val();
    $.get("../_WebClass/FenceManageHandler.ashx?ciid=" + ciid + "&mtd_id=" + mtdid + "&timeout=" + new Date().getTime(), { "flag": 0, "districtName": districtName }, function (data, status) {
        if (status == "success") {
            if (data == "True") {
                ShowMessage("该名称已经存在，请重新输入！");
            }
            else {
                saveMapData(districtName);
            }
        }
    });
}

function getUrlParam(paraName) {
    var sUrl = location.href;
    var sReg = "(?:\\?|&){1}" + paraName + "=([^&]*)"
    var re = new RegExp(sReg, "gi");
    re.exec(sUrl);
    return RegExp.$1;
}

function saveMapData(districtName) {

    if (tzDraw.fenceType == undefined || tzDraw.fenceType == null || tzDraw.polygonArr.length ==0) {
        alert("请在地图上画出电子围栏！");
        return;
    }

    var isMapAbc = tzMap.mapType == "mapabc";

    var centerLat, centerLng, circleRad;
    centerLat = tzDraw.centerLat;
    centerLng = tzDraw.centerLng;
    circleRad = tzDraw.rad;
    var latLngJson = "";

    var arr = tzDraw.polygonArr;

    latLngJson += "[";
            
    for (var i = 0; i < arr.length; i++) {
        latLngJson += "{\"lat\":\"";
        latLngJson += isMapAbc ? arr[i].lat : arr[i].lat();
        latLngJson += "\",";
        latLngJson += "\"lng\":\"";
        latLngJson += isMapAbc ? arr[i].lng : arr[i].lng();
        latLngJson += "\"},";
    }   
    latLngJson = latLngJson.substr(0, latLngJson.length - 1) + "]";
    var mtdType = $("#type").val();

    var ajaxOptions = { addfence: "true", mtdtype: mtdType, "drawType": tzDraw.fenceType, "centerLat": centerLat, "centerLng": centerLng, "circleRad": circleRad, "latLngJson": latLngJson, "districtName": districtName };
    var ciid = getUrlParam('ciid');
    var mtdid = $("#mtdid").val();

    $.get("../_WebClass/FenceManageHandler.ashx?ciid=" + ciid + "&mtd_id=" + mtdid + "&timeout=" + new Date().getTime(), ajaxOptions, function (data, status) {
        if (status == "success") {
            if (data == "true") {
                alert('保存成功');
                var ciid = getUrlParam('ciid');
                // 刷新列表
                if (ciid == "0") {
                    window.parent.$("#siteDialog").window("close");
                    window.top.frames["iframeCenter"].search();
                }
                else {
                    var top_frame=null;
                    if ($.browser.mozilla) {
                        top_frame=window.top.frames[1];
                    }else{
                        top_frame = window.top.frames["iframe_divNewProject"] || window.top.frames["iframe_divUpdateProject"];
                    }

                    if ( top_frame != null && top_frame != undefined) {
                       top_frame.ReLoadDropDownList(mtdType);
                    }                    
                    window.parent.$("#siteDialog").window("close");
                    window.parent.$("#divMaps").window("close");
                }
            }
            else {
                ShowMessage("保存失败！");
            }
        }
    });
}

function onDrawFinished() {
    $("#btn_save").removeAttr("disabled").removeClass("btn_save").addClass("hover_save");
}

function closeDrawfence() {
    window.parent.$("#divMaps").window("close");
    window.parent.$("#siteDialog").window("close");
}
