﻿// create by 王君涛 2012.07
// 图标hover css
$(function () {
    var sessionFlag = $("#hidSession").val();
    if (sessionFlag == "sessionmissing") {
        window.top.location = "../_Error/Error.aspx";
        return;
    }
    //hand
    $(".hand").hover(
    function () {
        $('#hand_img').css('margin-top', '-26px');
    },
    function () {
        $('#hand_img').css('margin-top', '0px');
    });
    //polygon
    $(".polygon").hover(
    function () {
        $('#polygon_img').css('margin-top', '-26px');
    },
    function () {
        $('#polygon_img').css('margin-top', '0px');
    });

    //square
    $(".square").hover(
    function () {
        $('#square_img').css('margin-top', '-26px');
    },
    function () {
        $('#square_img').css('margin-top', '0px');
    });
    //ellipse
    $(".ellipse").hover(
    function () {
        $('#circle').css('margin-top', '-26px');
    },
    function () {
        $('#circle').css('margin-top', '0px');
    });

    $(".line").hover(function () {
        $('#line').css('margin-top', '-26px');
    }, function () {
        $('#line').css('margin-top', '0px');
    });

    var type = document.getElementById('type');

    setTimeout(function () { InitShowHide(); }, 500);

    if ($("#mtdid").val() != "") {
        getMaintainDistrict($("#mtdid").val(),"3");
        var Mtd_pg_type = $("#Mtd_pg_type").val();
        var latlngs = $("#latlngs").val();
        if (Mtd_pg_type == "3" && latlngs != "") {
            var stringbuilder = "{'latlngs':'";
            stringbuilder += latlngs;
            stringbuilder += "','pg_type':'3'}";
            $("#save_line").val(stringbuilder);
        }
    }

    if (type != null && typeof (type) != 'undefined') {
        var typeValue = type.value;
        if (typeValue == '1' || typeValue == '2') {
            $(".line").css('display', 'none');
        } else if (typeValue == '3') {
            $(".polygon").css('display', 'none');
            $(".square").css('display', 'none');
            $(".ellipse").css('display', 'none');
        }
    }


});

//手形按钮点击事件
function moveOperate() {
    $("#spanTitle").text("可通过鼠标拖动选择区域。");
    SaveLine();
    var zoom = tzMap.map.getZoom();
    var center = tzMap.map.getCenter();
    tzMap.clearMap();
    drawMaintainDistrict($("#save_wor").val(),"2");
    drawMaintainDistrict($("#save_sta").val(),"1");
    drawMaintainDistrict($("#save_line").val(),"3");
    tzMap.map.setCenter(center);
    tzMap.map.setZoom(zoom);
    
    $("#btn_save").attr("disabled", "disabled").removeClass("hover_save").addClass("btn_save");
}

//选择画刷
function ChooseBrush(graphType) {
    var drawStepMsg = "";
    if (graphType == 1) {
        drawStepMsg = "单击开始 --> 移动鼠标绘图 --> 多次点击选择点 --> 双击完成 。";
    }
    else if (graphType == 2) {
        drawStepMsg = "单击开始 -->  移动鼠标绘图 --> 双击完成。";
    } else {
        drawStepMsg = "单击开始 -->  移动鼠标绘图 --> 双击完成。";
    }
    $("#spanTitle").text(drawStepMsg);
    var zoom = tzMap.map.getZoom();
    var center = tzMap.map.getCenter();
    tzMap.clearMap();
    drawMaintainDistrict($("#save_wor").val(),"2");
    drawMaintainDistrict($("#save_sta").val(),"1");
    $("#save_line").val("");
    tzMap.map.setCenter(center);
    tzMap.map.setZoom(zoom);
    tzDraw.drawFence(graphType);
    $("#btn_save").attr("disabled", "disabled").removeClass("hover_save").addClass("btn_save");
}

function ShowMessage(message) {
    $("#div_tip").css("display", "block");
    $("#span_tip").text(message).stop(false, true).fadeIn(0).fadeOut(10000);
}


function SaveDistrict() {
    var vValidate = $("#txt_title").val();
    if (vValidate == "" || vValidate.length == 0) {
        ShowMessage("请输入名称！");
        $("#txt_title").focus();
        return false;
    }
    if (vValidate.length > 50) {
        ShowMessage("输入名称过长！");
        $("#txt_title").focus();
        return false;
    }
    if (!checkInputControlValue()) {
        ShowMessage("您输入内容含有非法字符！");
        $("#txt_title").focus();
        return false;
    }
    var districtName="";

    districtName = $("#txt_title").val().replace(/(^\s+)|(\s+$)/g, "");
    var ciid = getUrlParam('ciid');
    var mtdid = $("#mtdid").val();
    $.get("../_WebClass/FenceManageHandler.ashx?ciid=" + ciid + "&mtd_id=" + mtdid + "&timeout=" + new Date().getTime(), { "flag": 0, "districtName": districtName }, function (data, status) {
        if (status == "success") {
            if (data == "True") {
                ShowMessage("该名称已经存在，请重新输入！");
            }
            else {
                saveMapData(districtName);
            }
        }
    });
}

function getUrlParam(paraName) {
    var sUrl = location.href;
    var sReg = "(?:\\?|&){1}" + paraName + "=([^&]*)"
    var re = new RegExp(sReg, "gi");
    re.exec(sUrl);
    return RegExp.$1;
}

function saveMapData(districtName) {
    
    var circleLong = "";
    var circleLat = "";
    var circleRadius = "";
    var latLongSet = "";
    var Mtd_pg_type = $("#Mtd_pg_type").val();
    var drawType = 0;
    var latlngs = $("#latlngs").val();
    var distance = $("#hidDistance").val(); // 线路路程
    if (tzDraw.fenceType == undefined || tzDraw.fenceType == null) {
        return;
    }
    drawType = tzDraw.fenceType;
    if (0 == tzDraw.fenceType) {
        if (typeof (tzDraw.polygonArr) != "undefined" && tzDraw.polygonArr.length > 0) {
            var isMapAbc = typeof (tzDraw.polygonArr[0].lat) == "number";
            circleLat = isMapAbc ? tzDraw.polygonArr[0].lat : tzDraw.polygonArr[0].lat();
            circleLong = isMapAbc ? tzDraw.polygonArr[0].lng : tzDraw.polygonArr[0].lng(); 
            circleRadius = tzDraw.rad;
        }
        else if (Mtd_pg_type == "") {
            ShowMessage("请选择区域！");
            return;
        }
        
    }
    else if (1 == tzDraw.fenceType || 2 == tzDraw.fenceType || 3 == tzDraw.fenceType) {
        if (typeof (tzDraw.polygonArr) != "undefined") {
            var arr = tzDraw.polygonArr;

            latLongSet += "[";
            var isMapAbc = typeof (arr[0].lat) == "number";
            for (var i = 0; i < arr.length; i++) {
                latLongSet += "{\"lat\":\"";
                latLongSet += isMapAbc ? arr[i].lat : arr[i].lat();
                latLongSet += "\",";
                latLongSet += "\"lng\":\"";
                latLongSet += isMapAbc ? arr[i].lng : arr[i].lng();
                latLongSet += "\"},";
            }
            if (3 == tzDraw.fenceType) {
                distance = tzMap.computeLength(arr);
            }
            latLongSet = latLongSet.substr(0, latLongSet.length - 1) + "]";
        }
        else if (Mtd_pg_type == "") {
            ShowMessage("请选择区域！");
            return;
        }
        
    }
    else {
        return;
    }
    if (circleLong == "" && circleLat == "" && circleRadius == "" && latLongSet == "") {
        drawType = parseInt(Mtd_pg_type);
        if (Mtd_pg_type == "0") {
            var latlngstemp = latlngs.split(",");
            circleLong = latlngstemp[0];
            circleLat = latlngstemp[1];
            circleRadius = latlngstemp[2];
        }
        else if (Mtd_pg_type == "1" || Mtd_pg_type == "2" || Mtd_pg_type == "3") {
            latLongSet = latlngs;
        }
    }

    var mtdType = "1";
    var type = document.getElementById('type');
    if (type != null && typeof (type) != 'undefined') {
        mtdType = type.value;
        if (mtdType == "3") {
            circleLong = $("#dp_station").val(); //用来存站ID ...
            circleLat = $("#dp_workplace").val(); //用来存工地ID ...
            if (circleLat == "") {
                ShowMessage("请选择工地");
                return;
            }
        }
    }

    var ajaxOptions = {mtdtype: mtdType, "drawType": drawType, "circleLong": circleLong, "circleLat": circleLat, "circleRadius": circleRadius, "latLongSet": latLongSet, "districtName": districtName, distance: distance };
    var ciid = getUrlParam('ciid');
    var mtdid = $("#mtdid").val();
    var my_url = "../_WebClass/FenceManageHandler.ashx?ciid=" + ciid + "&flag=1&mtd_id=" + mtdid + "&timeout=" + new Date().getTime();
    $.ajax({
        type: "POST",
        dataType: 'text',
        url: my_url,
        data: ajaxOptions,
        success: function (data) {
            if (data == "True") {
                alert('保存成功');
                var ciid = getUrlParam('ciid');
                // 刷新列表
                if (ciid == "0") {
                    window.parent.$("#siteDialog").window("close");
                    window.top.frames["iframeCenter"].search();
                }
                else {
                    var top_frame = null;
                    if ($.browser.mozilla) {
                        top_frame = window.top.frames[1];
                    } else {
                        top_frame = window.top.frames["iframe_divNewProject"] || window.top.frames["iframe_divUpdateProject"];
                    }

                    if (top_frame != null && top_frame != undefined) {
                        top_frame.ReLoadDropDownList(mtdType);
                    }
                    window.parent.$("#siteDialog").window("close");
                    window.parent.$("#divMaps").window("close");
                }
            }
            else {
                ShowMessage("区域设置保存失败！");
            }        
        }
    });    
}

function searchDropList(ciid) {

    
        var strCS = ""; //混凝土站 type1
        var strWS = ""; //工地 type2
        var strLS = ""; //线路 type3

        $.ajax({
            type: "get",
            dataType: 'json',
            url: "../Task/Handler/OrderHandler.ashx?m=1&ciid=" + ciid,
            async: false,
            success: function (objs) {
                if (objs[0].id > 0) {
                    for (var i = 0; i < objs.length; i++) {
                        if (objs[i].type == 1) {
                            strCS += ("<option value=\"" + objs[i].id + "\">" + objs[i].name + "</option>");
                        }
                        else if (objs[i].type == 2) {
                            strWS += ("<option value=\"" + objs[i].id + "\">" + objs[i].name + "</option>");
                        }
                        else if (objs[i].type == 3) {
                            strLS += ("<option value=\"" + objs[i].id + "\">" + objs[i].name + "</option>");
                        }
                    }
                    var iframe = null;
                    if (window.top.frames["iframe_divNewProject"] != null) {
                        iframe = window.top.frames["iframe_divNewProject"];
                    }
                    else if (window.top.frames["iframe_divUpdateProject"] != null) {
                        iframe = window.top.frames["iframe_divUpdateProject"];
                    }
                    iframe.$("#selfta_csid").html("");
                    iframe.$("#selfta_wsid").html("");
                    iframe.$("#selfta_routes1").html("");

                    iframe.$("#selfta_csid").html(strCS);
                    iframe.$("#selfta_wsid").html(strWS);
                    iframe.$("#selfta_routes1").html(strLS);
                }
            }
        });
    
    
}

function myFireEvent(obj, name) {
    if (document.all) {
        obj.fireEvent('on' + name);
    } else {
        var evt = document.createEvent('HTMLEvents');
        evt.initEvent(name, true, true);
        obj.dispatchEvent(evt);
    }
}

function onDrawFinished() {
    $("#btn_save").removeAttr("disabled").removeClass("btn_save").addClass("hover_save");
}

function MapArea() {

}

function ShowMaintainDistrict(type) { //展示所选择的混凝土站和工地
    var sta_id = $("#dp_station").val();
    var wor_id = $("#dp_workplace").val();
    SaveLine();
    tzMap.clearMap();
    
   if (type == "1") {//根据缓存重绘工地和线路，重新加载站
        drawMaintainDistrict($("#save_wor").val(),"2");
        drawMaintainDistrict($("#save_line").val(),"3");
        getMaintainDistrict(sta_id, "1");
    }
    else if (type == "2") {//根据缓存重绘站和线路，重新加载工地
        drawMaintainDistrict($("#save_sta").val(),"1");
        drawMaintainDistrict($("#save_line").val(),"3");
        if (wor_id != "") {
            getMaintainDistrict(wor_id, "2");
        }
        else {
            $("#save_wor").val("");
        }
    }
    
}

function getMaintainDistrict(id, type) { //获取信息并缓存
    
    $.get("../_WebClass/FenceZoneListHandler.ashx?geMaintainDistrict=true&id=" + id + "&datatime=" + Date().toString(), function (data) {
        drawMaintainDistrict(data,type);
        if (type == "1") {
            $("#save_sta").val(data);
        }
        else if (type == "2") {
            $("#save_wor").val(data);
        }
        else if (type == "3") {
            $("#save_line").val(data);
        }
    });
}

function drawMaintainDistrict(data,id) { //画图分离开便于处理缓存
    if (data == "") {
        return;
    }
    var s = eval("(" + data + ")");
    if (s.pg_type == "1") {
        if (s.latlngs != "") {
            var polygonjson = eval("(" + s.latlngs + ")");
            tzMap.addPolygon(polygonjson, true,"","", id);
        }
    }
    else if (s.pg_type == "2") {
        if (s.latlngs != "") {
            var polygonjson = eval("(" + s.latlngs + ")");
            tzMap.addPolygon(polygonjson, true,"","", id);
        }
    }
    else if (s.pg_type == "0") {
        if (s.pg_lng != "0" && s.pg_lat != "0" && s.radius != "0") {
            tzMap.addCircle(s.pg_lng, s.pg_lat, s.radius, true,"","",id);
        }
    } else if (s.pg_type == "3") { //线路
        var linejson = eval("(" + s.latlngs + ")");
        tzMap.addLine(linejson, true, id);
    }
}

function SaveLine() {
    if (tzDraw.fenceType == 3){
        if (typeof (tzDraw.polygonArr) != "undefined") {
            var latLongSet = "";
            var arr = tzDraw.polygonArr;
            latLongSet += "[";
            for (var i = 0; i < arr.length; i++) {
                
                latLongSet += "{\"lat\":\"";
                latLongSet += arr[i].lat;
                latLongSet += "\",";
                latLongSet += "\"lng\":\"";
                latLongSet += arr[i].lng;
                latLongSet += "\"},";
            }
            latLongSet = latLongSet.substr(0, latLongSet.length - 1) + "]";
        }
        var stringbuilder = "{'latlngs':'";
        stringbuilder += latLongSet;
        stringbuilder += "','pg_type':'3'}";
        $("#save_line").val(stringbuilder);
    }
}

function InitShowHide() {
    ShowMaintainDistrict("1");
    ShowMaintainDistrict("2");
}

function closeDrawfence() {
    window.parent.$("#divMaps").window("close");
    window.parent.$("#siteDialog").window("close");
}