﻿// create by 王君涛 2012.06.01
// google v3 API 封装

//var tzOverlayType = { MARKER: 0, POLYLINE: 1, POLYGON: 2, CIRCLE: 3, RECTANGLE: 4 };

function tzMap(mapCanvas) { 
    
}

tzMap.prototype.defaultIcon="../../_Css/images/red.png";
tzMap.prototype.map=null;


tzMap.prototype.init=function(mapCanvas){
    
}

tzMap.prototype.setZoomAndCenter=function(lng, lat, level) {
     if (lat == "" || lat == undefined || lng == "" || lng == undefined || level == "" || level == undefined) {
            return;
        }
        tzMap.prototype.map.setCenter(new google.maps.LatLng(lat, lng));
        tzMap.prototype.map.setZoom(level);
}

var mytz=new tzMap({});


/*
var tzMap = {
    init: function (handel) {
        this.defaultIcon = "../../_Css/images/red.png";
        this.mapOption.center = new google.maps.LatLng(32.397, 118.644);
        this.mapOption.zoom = 4;
        this.mapOption.mapTypeId = google.maps.MapTypeId.ROADMAP;
        this.map = new google.maps.Map(document.getElementById(handel), this.mapOption);
        setTimeout(function () { tzDraw._init() }, 1000);
        setTimeout(function () { tzSelect._init() }, 1000);
        this.isOK = true;

        initMapOption();

        if (typeof (MapLabel) != "undefined") {
            MapLabelProperty();
        }
    },
    hideToolbar: function () {
        //tzMap.map.removeControl(tzMap.toolbar);
    },
    setZoomAndCenter: function (lng, lat, level) {
        if (lat == "" || lat == undefined || lng == "" || lng == undefined || level == "" || level == undefined) {
            return;
        }
        tzMap.map.setCenter(new google.maps.LatLng(lat, lng));
        tzMap.map.setZoom(level);
    },
    openInfoWindow: function (myMarker, content) {
        google.maps.event.addListener(myMarker, 'click', function () {
            var myinfoWindowOption = {
                content: content,
                disableAutoPan: true,
                maxWidth: 400,
                pixelOffset: new google.maps.Size(-2, -2),
                position: myMarker.getPosition()
            };
            var myInfoWindow = new google.maps.InfoWindow(myinfoWindowOption);
            if (tzMap.lastInfoWinfow != null && tzMap.lastInfoWinfow != undefined) {
                tzMap.lastInfoWinfow.open(null);
            }
            myInfoWindow.open(tzMap.map);
            tzMap.lastInfoWinfow = myInfoWindow;
        });
    },
    addPoints: function (pointArray, isCenter) { // [{lng:'',lat:'',iurl:'',tipTxt:''},{lng:'',lat:'',iurl:'',tipTxt:''}]
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var icon = null, content = "", lng = "", lat = "";
        for (var i = 0; i < pointArray.length; i++) {
            lng = pointArray[i]["lng"], lat = pointArray[i]["lat"];

            if (lat == "" || lng == "") { continue; }

            if (pointArray[i]["iurl"] != "") {
                icon = new google.maps.MarkerImage(pointArray[i]["iurl"]);
            } else {
                icon = new google.maps.MarkerImage(tzMap.defaultIcon);
            }
            tzMap.markerOption.icon = icon;
            var latlng = new google.maps.LatLng(lat, lng);
            tzMap.markerOption.position = latlng;
            var myMarker = new google.maps.Marker(tzMap.markerOption);
            var content = pointArray[i]["tipTxt"];
            // 弹出框
            if (content != "" && content != undefined) {
                tzMap.openInfoWindow(myMarker, content);
            }
            tzMap._addToMap(myMarker);
        }
        if (isCenter && pointArray.length == 1 && lat != "" && lng != "") { // 单点时设置中心点
            tzMap.setZoomAndCenter(lng, lat, 7);
        }
    },
    addMarker: function (markerOption) { // {lng:'',lat:'',icon:'',content:'',becenter:false}
        if (markerOption == null || markerOption == "undefined") {
            return;
        }
        if (markerOption.icon != "") { 
            
        }

    },
    addMaplabel: function (labelOption) { // {lng:'',lat:'',icon:'',content:'',becenter:false}
        if (labelOption == null || labelOption == "undefined" || typeof (MapLabel) == "undefined") {
            return;
        }
        MapLabel.btype = tzMap.markerOption.btype;

    },
    _zoomHandler: function (level) {
        if (middleCaller == undefined) { return; }
        var mymiddle = middleCaller || null;
        if (level >= 4) {
            // 回调加载Table数据
            if (mymiddle != null && mymiddle != undefined) {

                var mapBounds = tzMap.map.getBounds(),
                    maxX = mapBounds.getNorthEast().lng(),
                    maxY = mapBounds.getNorthEast().lat(),
                    minX = mapBounds.getSouthWest().lng(),
                    minY = mapBounds.getSouthWest().lat();

                mymiddle.zhch(level, maxX, minX, maxY, minY);
            }
        } else if (level >= 8) {
            // 回调
            if (mymiddle != null && mymiddle != undefined) {

                var mapBounds = tzMap.map.getBounds(),
                    maxX = mapBounds.getNorthEast().lng(),
                    maxY = mapBounds.getNorthEast().lat(),
                    minX = mapBounds.getSouthWest().lng(),
                    minY = mapBounds.getSouthWest().lat();

                mymiddle.zhch(level, maxX, minX, maxY, minY);
            }
        }
    },
    _addToMap: function (obj) {
        if (obj !== undefined && obj != null) {
            tzMap.allFeaturesArr.push(obj);
            obj.setMap(tzMap.map);
        }
    },
    getBounds: function (pointArray) {
        if (typeof (pointArray) == "undefined" || pointArray.length == 0) {
            return null;
        }
        var myBounds = new google.maps.LatLngBounds();
        for (var i = 0; i < pointArray.length; i++) {
            myBounds.extend(pointArray[i]);
        }
        return myBounds;
    },
    fitView: function (bounds) {
        if (typeof (bounds) != "undefined" && bounds != null) {
            tzMap.map.fitBounds(bounds);
        }
    },
    fitAllView: function () { // 自适应视野范围
        if (tzMap.allFeaturesArr != null && tzMap.allFeaturesArr.getLength() > 0) {
            var myBounds = new google.maps.LatLngBounds();
            tzMap.allFeaturesArr.forEach(function (el, index) {
                if (typeof (el.getPosition) != "undefined") {
                    myBounds.extend(el.getPosition());
                } else if (typeof (el.getBounds) != "undefined") {
                    myBounds.extend(el.getBounds().getNorthEast());
                    myBounds.extend(el.getBounds().getSouthWest());
                } else if (typeof (el.getPath) != "undefined") {
                    el.getPath().forEach(function (el, index) {
                        myBounds.extend(el);
                    });
                } else {

                }
            });
            if (!myBounds.isEmpty()) {
                tzMap.map.fitBounds(myBounds);
            }
        }
    },
    hideFeaturesByType: function (btype) {
        tzMap.allFeaturesArr.forEach(function (el, index) {
            if (el.btype == btype) {
                el.setMap(null);
            }
        });
    },
    showFeaturesByType: function (btype) {
        tzMap.allFeaturesArr.forEach(function (el, index) {
            if (el.btype == btype) {
                el.setMap(tzMap.map);
            }
        });
    },
    addLine: function (pointArray, isCenter) { // [{lng:'',lat:''},{lng:'',lat:''}]
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var polylinePath = new Array();
        for (var i = 0; i < pointArray.length; i++) {
            polylinePath.push(new google.maps.LatLng(pointArray[i]["lat"], pointArray[i]["lng"]));
        }
        tzMap.polylineOption.path = polylinePath;
        var polyline = new google.maps.Polyline(tzMap.polylineOption);
        tzMap._addToMap(polyline);
        if (isCenter) {
            tzMap.fitView(tzMap.getBounds(tzMap.polylineOption.path));
        }
    },
    addPolygon: function (pointArray, isCenter) { // [{lng:'',lat:''},{lng:'',lat:''}]
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var polygonPath = new Array();
        for (var i = 0; i < pointArray.length; i++) {
            polygonPath.push(new google.maps.LatLng(pointArray[i]["lat"], pointArray[i]["lng"]));
        }
        tzMap.polygonOption.path = polygonPath;
        var polygon = new google.maps.Polygon(tzMap.polygonOption);
        tzMap._addToMap(polygon);
        if (isCenter) {
            tzMap.fitView(tzMap.getBounds(polygonPath));
        }
    },
    addCircle: function (lng, lat, radius, isCenter) {
        if (lng == "" || lat == "" || radius == "" || lng == undefined || lat == undefined || radius == undefined) {
            return;
        }
        tzMap.circleOption.center = new google.maps.LatLng(lat, lng);
        tzMap.circleOption.radius = parseFloat(radius);
        var myCircle = new google.maps.Circle(tzMap.circleOption);
        tzMap._addToMap(myCircle);
        if (isCenter) {
            tzMap.fitView(myCircle.getBounds());
        }
    },
    clearMap: function () {
        if (tzMap.allFeaturesArr == null) {
            return;
        }
        tzMap.allFeaturesArr.forEach(function (el, index) {
            el.setMap(null);
        });
        if (tzMap.lastInfoWinfow != null) {
            tzMap.lastInfoWinfow.open(null);
        }
        tzMap.polygonOption.path.length = 0;
        tzMap.polylineOption.path.length = 0;
        tzMap.circleOption.center = null;
        tzMap.allFeaturesArr.clear();
    },
    bindMousewheel: function () {
        google.maps.event.addListener(tzMap.map, "zoom_changed", function (e) {
            var level = tzMap.map.getZoom();
            tzMap._zoomHandler(level);
        });
        google.maps.event.addListener(tzMap.map, "dragend", function (e) {
            var level = tzMap.map.getZoom();
            tzMap._zoomHandler(level);
        });
    },
    zoomNext: function (zoomNextOption) {
        if (zoomNextOption == null || zoomNextOption == undefined) {
            return;
        }
        tzMap.setZoomAndCenter(zoomNextOption.lng, zoomNextOption.lat, zoomNextOption.zoomlevel);

        var mymiddle = middleCaller;
        if (mymiddle != null && mymiddle != undefined) {

            var mapBounds = tzMap.map.getBounds(),
                maxX = mapBounds.getNorthEast().lng(),
                maxY = mapBounds.getNorthEast().lat(),
                minX = mapBounds.getSouthWest().lng(),
                minY = mapBounds.getSouthWest().lat();

            mymiddle.zhchById(parseInt(zoomNextOption.zoomlevel), maxX, minX, maxY, minY, zoomNextOption.areaId);
        }
    },
    addGroundOverlay: function (groundOverlayOption) { // [{x1:0,y1:0,x2:0,y2:0,url:''},{{x1:0,y1:0,x2:0,y2:0,url:''}]
        if (groundOverlayOption == null || groundOverlayOption == undefined) {
            return;
        }
        for (var i = 0; i < groundOverlayOption.length; i++) {
            var myLatLngBound = new google.maps.LatLngBounds(new google.maps.LatLng(groundOverlayOption[i]['y1'], groundOverlayOption[i]['x1']), new google.maps.LatLng(groundOverlayOption[i]['y2'], groundOverlayOption[i]['x2']));
            var imgGround = new google.maps.GroundOverlay(groundOverlayOption[i]['url'].replace('MapType', 'GM'), myLatLngBound);
            imgGround.setMap(this.map);
        }
    },
    getAddress: function (lat, lng, address) {
        if (typeof (lat) == 'undefined' || lat == "" || typeof (lng) == 'undefined' || lng == "") {
            return;
        }
        if (typeof (address) == 'undefined') {
            return;
        }

        var latlng = new google.maps.LatLng(lat, lng);
        var geocoder = new google.maps.Geocoder();

        geocoder.geocode({ location: latlng }, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                address = results[0].formatted_address;
            }
            else {
                address = "ERROR";
            }
        });
    },
    map: {},
    isOK: false,
    toolbar: null,
    defaultIcon: '',
    allFeaturesArr: new google.maps.MVCArray(),
    lastInfoWinfow: null,
    mapOption: {},
    markerOption: { clickable: true, cursor: 'pointer', draggable: false, flat: false, icon: null, position: null, visible: true, otype: tzOverlayType.MARKER, btype: 0 },
    polylineOption: { path: new Array(), strokeColor: '#13FE18', fillColor: '#13FE18', strokeOpacity: 1, strokeWeight: 2, editable: false, otype: tzOverlayType.POLYLINE, btype: 4 },
    polygonOption: { path: new Array(), strokeColor: '#1E90FF', strokeOpacity: 0.5, strokeWeight: 1, fillColor: '#1E90FF', fillOpacity: 0.5, otype: tzOverlayType.POLYGON, btype: 2 },
    circleOption: { center: null, radius: 5, strokeColor: "#1E90FF", strokeOpacity: 0.9, strokeWeight: 1, fillColor: "#1E90FF", fillOpacity: 0.5, otype: tzOverlayType.CIRCLE, btype: 2 }
}



var tzDraw = {
    _init: function () {
        var myPolygonOptions = {
            strokeColor: "#DDA0DD",
            fillColor: '#1E90FF',
            fillOpacity: 0.6,
            strokeWeight: 2,
            clickable: false,
            zIndex: 1,
            editable: false
        };
        tzMap.polylineOption.strokeColor = "#13FE18";
        tzMap.polylineOption.strokeWeight = 2;
        tzDraw.drawingManager = new google.maps.drawing.DrawingManager({
            drawingMode: null,
            drawingControl: false,
            circleOptions: myPolygonOptions,
            polygonOptions: myPolygonOptions,
            rectangleOptions: myPolygonOptions,
            polylineOptions: tzMap.polylineOption
        });
        tzDraw.drawingManager.setMap(tzMap.map);
        google.maps.event.addListener(tzDraw.drawingManager, 'overlaycomplete', function (event) {
            tzMap.clearMap();
            if (event.type == google.maps.drawing.OverlayType.POLYGON) {
                tzMap.allFeaturesArr.push(event.overlay);
                tzDraw.polygonArr = new Array();
                event.overlay.getPath().forEach(function (el, index) {
                    tzDraw.polygonArr.push(el);
                });
            } else if (event.type == google.maps.drawing.OverlayType.CIRCLE) {
                tzMap.allFeaturesArr.push(event.overlay);
                tzDraw.rad = event.overlay.getRadius();
                tzDraw.polygonArr = new Array();
                tzDraw.polygonArr.push(event.overlay.center);
            } else if (event.type == google.maps.drawing.OverlayType.RECTANGLE) {
                tzMap.allFeaturesArr.push(event.overlay);
                tzDraw.polygonArr = new Array();
                var ne = event.overlay.bounds.getNorthEast(), sw = event.overlay.bounds.getSouthWest();
                var mypoint1 = new google.maps.LatLng(sw.lat(), ne.lng()), mypoint2 = new google.maps.LatLng(ne.lat(), sw.lng());
                tzDraw.polygonArr.push(mypoint1);
                tzDraw.polygonArr.push(ne);
                tzDraw.polygonArr.push(mypoint2);
                tzDraw.polygonArr.push(sw);
            } else if (event.type == google.maps.drawing.OverlayType.POLYLINE) {
                tzMap.allFeaturesArr.push(event.overlay);
                tzDraw.polygonArr = new Array();
                event.overlay.getPath().forEach(function (el, index) {
                    tzDraw.polygonArr.push(el);
                });
            } else { }
            //drawingManager.setOptions({ drawingMode: null });
            var drawFinished = onDrawFinished;
            if (typeof (drawFinished) != "undefined" && drawFinished != null) {
                drawFinished();
            }
        });
    },
    drawFence: function (type) {
        tzDraw.fenceType = type;
        if (type == 0) {
            // 画圆
            tzDraw.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.CIRCLE });
        }
        else if (type == 1) {
            // 画多边行
            tzDraw.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.POLYGON });
        } else if (type == 2) {
            // 画矩形
            tzDraw.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.RECTANGLE });
        } else if (type == 3) {
            // 画线
            tzDraw.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.POLYLINE });
        } else {
            // 禁用画图模式
            tzDraw.drawingManager.setOptions({ drawingMode: null});
            return;
        }
    },
    fenceType: 0,
    rad: 0,
    polygonArr: new Array(),
    drawingManager: null
}

function initMap() {
    tzMap.init("map");
}

window.onload = initMap;


function initMapOption() {
    google.maps.Marker.otype = tzOverlayType.MARKER;
    google.maps.Polygon.otype = tzOverlayType.POLYGON;
    google.maps.Polyline.otype = tzOverlayType.POLYLINE;
    google.maps.Circle.otype = tzOverlayType.CIRCLE;
    google.maps.Rectangle.otype = tzOverlayType.RECTANGLE;
    // 0 : 车辆图标 ， 1：报警点图标, 2：工地 ，3：搅拌站， 4：线路 
    google.maps.Marker.btype = 0;
    google.maps.Polygon.btype = 2;
    google.maps.Polyline.btyte = 4;
    google.maps.Circle.btype = 2;
}

// Maplabel 属性初始化
function MapLabelProperty() {
    MapLabel.otype = tzOverlayType.MARKER;
    MapLabel.btype = 0;
}

/*

/ 轨迹回放对象
var tzCar = {
    // 初始化 MMap.Map , [{lng:'',lat:''},{lng:'',lat:''}] ,（注释 ： 之后是可选参数 ） {icon:"",content:""},{icon:"",content:""} ,{icon:"",content:""},千米/小时
    init: function (map, pointArray, carOption, startPointOption, endPointOption, speed) {
        if (map == null || map == undefined || pointArray == null || pointArray == undefined) {
            return;
        }
        this.polylineOption.path.length = 0;
        this.map = map || tzMap.map;
        this.speed = speed;
        for (var i = 0; i < pointArray.length; i++) {
            if (pointArray[i]["lng"] != "" && pointArray[i]["lat"] != "") {
                this.polylineOption.path.push(new MMap.LngLat(pointArray[i]["lng"], pointArray[i]["lat"]));
            }
        }
        var icon = "", content = "",
        startLnglat = this.polylineOption.path[0],
        endLnglat = this.polylineOption.path[this.polylineOption.path.length - 1];
        // 初始化 起点、终点、轨迹线、小车图标(位于起点)
        // 起点
        var markerOption = {};
        markerOption.id = "startPoint";
        markerOption.position = tzCar.polylineOption.path[0];
        if (startPointOption != null && startPointOption != undefined) {
            markerOption.icon = "../_Css/images/mapControl/markerS.png";
            markerOption.offset = { x: -26, y: -13 };
        }
        tzCar.startMarker = new MMap.Marker(markerOption);
        markerOption = {};
        content = "";
        markerOption.id = "carmarker";
        markerOption.position = tzCar.polylineOption.path[0];
        if (carOption != null && carOption != undefined) {
            icon = carOption.icon;
            content = carOption.content;
        }
        icon = "../_Css/images/circle.png";
        if (icon != "") {
            markerOption.icon = icon;
            // markerOption.offset = { x: 0, y: 20 };
        }
        tzCar.carMarker = new MMap.Marker(markerOption);
        //终点
        markerOption = {};
        icon = "";
        markerOption.id = "carEndPoint";
        markerOption.position = endLnglat;
        if (endPointOption != null && endPointOption != undefined) {
            icon = endPointOption.icon;
            content = endPointOption.content;
        }
        content = "终点";
        icon = "../_Css/images/mapControl/markerE.png";
        if (icon != "") {
            markerOption.icon = icon;
            markerOption.offset = { x: -26, y: -13 };
        }
        tzCar.endMarker = new MMap.Marker(markerOption);
        // tzCar.searchRoute(tzCar.polylineOption.path);
        tzCar.searchRouteCallback(null);
    },
    //私有方法
    openInfoWindow: function (marker, content) {
        var inforWindow = new MMap.InfoWindow({ content: content, autoMove: true });
        this.map.bind(marker, "click", function (e) {
            inforWindow.open(tzCar.map, marker.getPosition());
        });
    },
    searchRoute: function (path) {
        var route = new MMap.RouteSearch({ routeType: 0 });
        route.getNaviPath(path, tzCar.searchRouteCallback);
    },
    searchRouteCallback: function (data) {
        var carPolyline = null;
        //        if (data.state = "E0" && data.count > 0) {
        //            tzCar.polylineOption.path.length = 0;
        //            var poi_xy_r = data.coors.split(";");
        //            for (var j = 0; j < poi_xy_r.length - 1; j++) {
        //                var xy = poi_xy_r[j].split(",");
        //                tzCar.polylineOption.path.push(new MMap.LngLat(xy[0], xy[1]));
        //            }
        //        }
        // 轨迹线
        carPolyline = new MMap.Polyline(tzCar.polylineOption);
        tzCar.map.addOverlays(tzCar.startMarker);
        tzCar.map.addOverlays(tzCar.carMarker);
        tzCar.map.addOverlays(tzCar.endMarker);
        tzCar.map.addOverlays(carPolyline);
        tzCar.map.setCenter(tzCar.carMarker.getPosition());
        tzCar.map.setZoom(13);
        tzCar.isOK = true;
        tzCar.start(tzCar.speed);
    },
    // 常用属性
    map: null,
    startMarker: null,
    endMarker: null,
    carMarker: null,
    speed: 300,
    isOK: false,
    polylineOption: { id: 'carLine', path: new Array(), strokeColor: '#F00', strokeOpacity: 0.4, strokeWeight: 3, strokeStyle: 'solid', strokeDasharray: [10, 5] },
    // 对外接口
    start: function (speed) {
        tzCar.speed = speed;
        tzCar.carMarker = new MMap.Marker({ id: "carmarker", position: tzCar.polylineOption.path[0], icon: "../_Css/images/circle.png", offset: { x: -20, y: -13} });
        tzCar.map.addOverlays(tzCar.carMarker);
        tzMap.map.removeOverlays("tmpCar");
        tzCar.carMarker.moveAlong(tzCar.polylineOption.path, tzCar.speed);
        tzCar.map.panTo(tzCar.carMarker.getPosition());
        tzCar.map.bind(tzCar.carMarker, "moving", function (e) {
            var lnglat = tzCar.carMarker.getPosition();
            var bounds = tzCar.map.getBounds();
            if (lnglat.lng <= bounds.southwest.lng || lnglat.lng >= bounds.northeast.lng || lnglat.lat <= bounds.southwest.lat || lnglat.lat >= bounds.northeast.lat) {
                tzCar.map.panTo(lnglat);
            }
        });
    },
    pause: function () {
        tzCar.carMarker.stopMove();
        var startLngLat = tzCar.carMarker.getPosition();
        var tmmarker = new MMap.Marker({ id: "tmpCar", position: startLngLat, icon: "../_Css/images/circle.png", offset: { x: -20, y: -13} });
        tzMap.map.addOverlays(tmmarker);
        tzMap.map.removeOverlays("carmarker");
    },
    stop: function () {
        tzCar.carMarker.stopMove();
        var startLngLat = new MMap.LngLat(tzCar.polylineOption.path[0]["lng"], tzCar.polylineOption.path[0]["lat"]);
        //tzCar.carMarker.setPosition(startLngLat);
        var tmmarker = new MMap.Marker({ id: "tmpCar", position: startLngLat, icon: "../_Css/images/circle.png", offset: { x: -20, y: -13} });
        tzMap.map.addOverlays(tmmarker);
        tzMap.map.removeOverlays("carmarker");
    },
    remark: {}
}

tzRouteSearch = {
    //初始化 {lng:"",lat:"",key:"",city:""} , map 为可选参数; lng ,lat 不为空则优先按照经纬度查询
    init: function (startOption, endOption, map) {
        if (map != null && map != undefined) {
            this.map = map || tzMap.map;
        }

        if (startOption == null || startOption == undefined || endOption == null || endOption == undefined) {
            return;
        }
        tzRouteSearch.routeSType = "rs";
        if (startOption.lng != "" && startOption.lat != "" && endOption.lng != "" && endOption.lat != "") {
            this.startOption.start_x = startOption.lng;
            this.startOption.start_y = startOption.lat;
            this.endOption.end_x = endOption.lng;
            this.endOption.end_y = endOption.lat;
        } else if (startOption.key != "" && startOption.city != "" && endOption.key != "" && endOption.city != "") {
            this.endOption.end_name = endOption.key;
            this.endOption.end_cityname = endOption.city;
            this.startOption.start_name = startOption.key;
            this.startOption.start_cityname = startOption.city;
            this.pointSearch(startOption.key, startOption.city);
        } else {
            return;
        }
    },

    // 常用属性
    map: null,
    routeSType: "rs",
    startOption: { start_x: "", start_y: "", start_name: "", start_address: "", start_tel: "", start_pid: "", start_citycode: "", start_cityname: "", start_detailLink: "", start_type: "" },
    endOption: { end_x: "", end_y: "", end_name: "", end_address: "", end_tel: "", end_pid: "", end_citycode: "", end_cityname: "", end_detailLink: "", end_type: "" },
    route_segment: "",
    searchResult: "",
    // 方法
    pointSearch: function (keyword, city) {
        tzRouteSearch.map.clearOverlays();
        var PoiSearchOption = {
            srctype: "POI", //数据来源
            type: "", //数据类别
            number: 1, //每页数量,默认10
            batch: 1, //请求页数，默认1
            range: 3000, //查询范围，默认3000米
            ext: ""//扩展字段
        };
        var MSearch = new MMap.PoiSearch(PoiSearchOption);
        MSearch.byKeywords(keyword, city, tzRouteSearch.pointSearchCallback);
    },
    pointSearchCallback: function (data) {
        if (data.list == undefined && data.error.code != "") {
            tzRouteSearch.searchResult = "error";
            var pageErrorHandler = errHandler || null;
            if (pageErrorHandler != null && pageErrorHandler != undefined) {
                pageErrorHandler.show("地图服务繁忙，请稍后再请求!");
            }            
            return;
        }
        if (tzRouteSearch.routeSType == "rs") {

            if (data.list.length == 0) {
                tzRouteSearch.searchResult = "起点未查找到任何结果!";
            } else {
                tzRouteSearch.startOption.start_x = data.list[0].x;
                tzRouteSearch.startOption.start_y = data.list[0].y;
                //this.startOption.start_name = data.list[0].name;
                tzRouteSearch.startOption.start_address = data.list[0].address;
                tzRouteSearch.startOption.start_tel = data.list[0].tel;
                tzRouteSearch.startOption.start_type = data.list[0].type;
                tzRouteSearch.startOption.start_pid = data.list[0].pguid;
            }
        }
        if (tzRouteSearch.routeSType == "re") {
            if (data.list.length == 0) {
                tzRouteSearch.searchResult = "终点未查找到任何结果!";
            } else {
                tzRouteSearch.endOption.end_x = data.list[0].x;
                tzRouteSearch.endOption.end_y = data.list[0].y;
                //this.endOption.end_name = data.list[0].name;
                tzRouteSearch.endOption.end_address = data.list[0].address;
                tzRouteSearch.endOption.end_tel = data.list[0].tel;
                tzRouteSearch.endOption.end_type = data.list[0].type;
                tzRouteSearch.endOption.end_pid = data.list[0].pguid;
            }
        }
        tzRouteSearch.pointEndSearch();
    },
    pointEndSearch: function () {
        if (tzRouteSearch.routeSType == "rs") {
            tzRouteSearch.routeSType = "re";
            tzRouteSearch.pointSearch(tzRouteSearch.endOption.end_name, tzRouteSearch.endOption.end_cityname);
        } else {
            tzRouteSearch.search();
        }
    },
    search: function () {

        var startXY = new MMap.LngLat(tzRouteSearch.startOption.start_x, tzRouteSearch.startOption.start_y),
        endXY = new MMap.LngLat(tzRouteSearch.endOption.end_x, tzRouteSearch.endOption.end_y);

        var route = new MMap.RouteSearch({ routeType: 0 });
        var pathArr = [];
        pathArr.push(startXY);
        pathArr.push(endXY);
        route.getNaviPath(pathArr, tzRouteSearch.searchByXyCallback);
    },
    searchByXy: function (start_x, start_y, end_x, end_y) {

        if (start_x == "" || start_y == "" || end_x == "" || end_y == "") {
            return;
        }

        tzRouteSearch.startOption.start_x = start_x;
        tzRouteSearch.startOption.start_y = start_y;
        tzRouteSearch.endOption.end_x = end_x;
        tzRouteSearch.endOption.end_y = end_y;
    },
    searchByXyCallback: function (data) {
        var resultStr = "";
        if (data.state = "E0") {
            var route_count = data.count;
            if (route_count == 0 || route_count == undefined) {
                resultStr = "<div>&nbsp;&nbsp;&nbsp;&nbsp;未查找到任何结果!</div>";
            } else {
                var route_text = ""; var road_length = 0;
                var route_content = new Array();
                tzRouteSearch.route_segment = new Array();
                for (var i = 0; i < route_count; i++) {
                    //routeS.route_segment[i] = data.list[i].coor;//每一条路线的XY
                    //road_length += data.list[i].roadLength;//每一条路线的里程
                    if (i == 0) {
                        route_text += "<tr class=\"td_style\" id=\"tr_" + i + "\" onMouseover=\"this.style.backgroundColor='#efefef';\" onMouseout=\"this.style.backgroundColor='';\" onclick=\"tzRouteSearch.drawLine('" + i + "','" + route_count + "','" + data.list[i].coor + "')\"><td align=\"center\">" + (i + 1) + ".</td><td width=\"300\">沿<strong>" + data.list[i].roadName + "</strong>向<strong>" + data.list[i].direction + "</strong><span class=\"gray\">行驶</span></td><td align=\"right\">" + data.list[i].roadLength + "</td><td>&nbsp;</td></tr>";
                    } else {
                        route_text += "<tr class=\"td_style\" id=\"tr_" + i + "\" onMouseover=\"this.style.backgroundColor='#efefef';\" onMouseout=\"this.style.backgroundColor='';\" onclick=\"tzRouteSearch.drawLine('" + i + "','" + route_count + "','" + data.list[i].coor + "')\"><td align=\"center\">" + (i + 1) + ".</td><td width=\"150\">" + data.list[i - 1].action + "<span class=\"gray\">进入</span><strong>" + data.list[i].roadName + "</strong>向<strong>" + data.list[i].direction + "</strong><span class=\"gray\">行驶</span></td><td align=\"right\">" + data.list[i].roadLength + "</td><td>&nbsp;</td></tr>";
                    }
                }
                route_content.push("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"inner_route_result\"><tr><td colspan=\"2\" style=\"background:#e1e1e1;\" width=\"216\">路线</td><td style=\" border-left:1px solid #fff; background:#e1e1e1;\">里程</td><td width=\"17\" style=\"background:#e1e1e1;\">&nbsp;</td> </tr><tr><td width=\"3\" align=\"center\"></td><td colspan=\"2\">起点：" + tzRouteSearch.startOption.start_cityname + " " + tzRouteSearch.startOption.start_name + "</td><td width=\"17\">&nbsp;</td></tr>" + route_text + "<tr><td align=\"center\"></td><td colspan=\"2\">终点：" + tzRouteSearch.endOption.end_cityname + " " + tzRouteSearch.endOption.end_name + "</td></tr><tr><td colspan=\"3\" align=\"right\">" + "</td></tr></table>");

                resultStr = route_content.join("");
                var allover = new Array();
                var arr = new Array();

                var poi_xy_r = data.coors.split(";");

                for (var j = 0; j < poi_xy_r.length - 1; j++) {
                    var xy = poi_xy_r[j].split(",");
                    arr.push(new MMap.LngLat(xy[0], xy[1]));
                }
                var polyline = new MMap.Polyline({
                    id: "searchLine",
                    path: arr,
                    strokeColor: "#005cb5", //线颜色 
                    strokeOpacity: 0.8, //线透明度 
                    strokeWeight: 5 //线宽 
                });
                tzRouteSearch.map.addOverlays(polyline);
                //起点
                var startmarkerOption = {
                    position: new MMap.LngLat(tzRouteSearch.startOption.start_x, tzRouteSearch.startOption.start_y),
                    offset: { x: -8, y: -9 },
                    id: tzRouteSearch.startOption.start_pid
                }
                var startmarker = new MMap.Marker(startmarkerOption);
                var infoWindow = new MMap.InfoWindow();
                infoWindow.content = "起点: " + tzRouteSearch.startOption.start_cityname + " " + tzRouteSearch.startOption.start_name;
                infoWindow.id = "startSearchPoint";
                tzRouteSearch.map.bind(startmarker, "click", function (e) {
                    infoWindow.open(tzRouteSearch.map, startmarker.getPosition());
                });
                allover.push(startmarker);
                //终点
                var endmarkerOption = {
                    position: new MMap.LngLat(tzRouteSearch.endOption.end_x, tzRouteSearch.endOption.end_y),
                    offset: { x: -8, y: -9 },
                    id: tzRouteSearch.endOption.end_pid
                }
                var endmarker = new MMap.Marker(endmarkerOption);
                var infoWindow1 = new MMap.InfoWindow();
                infoWindow1.content = "终点: " + tzRouteSearch.endOption.end_cityname + " " + tzRouteSearch.endOption.end_name;
                infoWindow1.id = "endSearchPoint";
                tzRouteSearch.map.bind(endmarker, "click", function (e) {
                    infoWindow1.open(tzRouteSearch.map, endmarker.getPosition());
                });
                allover.push(endmarker);
                tzRouteSearch.map.addOverlays(allover);

                tzRouteSearch.map.setFitView();
            }
        }
        else if (data.state = "E1") {
            resultStr = "未查找到任何结果!<br />";
        }
        else {
            resultStr = "错误信息：" + data.state;
        }
        var resultdiv = document.getElementById("result");
        if (resultdiv != undefined) {
            resultdiv.innerHTML = resultStr;
        }
    },
    drawLine: function (num, count, coor) {
        var tr_id = "tr_" + num;
        for (var i = 0; i < count; i++) {
            var id = "tr_" + i;
            document.getElementById(id).style.background = '';
            document.getElementById(id).onmouseout = function () { this.style.backgroundColor = ''; };
        }
        document.getElementById(tr_id).style.background = '#efefef';
        document.getElementById(tr_id).onmouseout = function () { this.style.backgroundColor = '#efefef'; };
        var arr1 = new Array();
        var poi_xy = coor.split(";");
        for (var e = 0; e < poi_xy.length - 1; e++) {
            var lineXY = poi_xy[e].split(",");
            arr1.push(new MMap.LngLat(lineXY[0], lineXY[1]));
        }

        var polyline1 = new MMap.Polyline({
            id: "driveline",
            path: arr1,
            strokeColor: "#33CC00", 	 //线颜色 
            strokeOpacity: 0.8, //线透明度 
            strokeWeight: 5  //线宽 
        });
        tzRouteSearch.map.addOverlays(polyline1);
        tzRouteSearch.map.setCenter(arr1[0]);
    }
}