﻿// create by 王君涛 2012.07 
var tzMenu = {
    menu: [{ id: 1, icon: 'icon-sys', title: '', url: '', menus: []}],
    _init: function () {
        for (var i = 0; i < tzMenu.menu.length; i++) {
            var submenu = tzMenu.menu[i];
            tzMenu.menuList = "<ul>";
            tzMenu.isTitle = true;
            tzMenu._menuTree(submenu);
            $("#menu").accordion("add", {
                title: submenu.title,
                content: tzMenu.menuList,
                iconCls: "icon " + submenu.icon
            });
        }
        tzMenu.menuList += "</ul>";
        tzMenu.hover();
        tzMenu.bindClick();
        // 默认展开一个
        $('#menu').accordion('select', '任务管理');
    },
    _menuTree: function (menu) {
        if (menu.menus.length > 0) {
            if (!tzMenu.isTitle) {
                tzMenu.menuList += '<li><div><a class="' + tzMenu.aClass + '"><span class="icon ' + menu.icon
					+ '" >&nbsp;</span><span>' + menu.title + '</span></a>';
            }
            for (var i = 0; i < menu.menus.length; i++) {
                tzMenu.isTitle = false;
                tzMenu._menuTree(menu.menus[i]);
            }
        } else {
            tzMenu.aClass = "haveNotChildClass";
            if (menu.url == "#") {
                tzMenu.menuList += '<li><div> '
            } else {
                tzMenu.menuList += '<li><div><a class="' + tzMenu.aClass + '"ref="' + menu.id + '" href="#" rel="'
					+ menu.url + '" ><span class="icon ' + menu.icon
					+ '" >&nbsp;</span><span class="nav">' + menu.title
					+ '</span></a> '
            }
        }
    },
    hover: function () {
        $(".easyui-accordion").find('a').hover(function () {
            $(this).parent().addClass("hover");
        }, function () {
            $(this).parent().removeClass("hover");
        });
    },
    bindClick: function () {
        $('#menu li a').live('click', function () {
            var tabTitle = $(this).children('.nav').text();

            var url = $(this).attr("rel");
            var menuid = $(this).attr("ref");
            tzMenu.openTab(tabTitle, url, "icon");
            $('#menu li div').removeClass("selected");
            $(this).parent().addClass("selected");
        });
    },
    openTab: function (title, url, icon) {
        if (title == "" || typeof (title) == "undefined") {
            return;
        }

        /* 启用添加新选项卡
        if (!$('#tabs').tabs('exists', title)) {
        $('#tabs').tabs('add', {
        title: title,
        content: tzMenu.loadFrame(title,url),
        closable: true,
        icon: icon
        });
        } else {
        $('#tabs').tabs('select', title);
        var currTab = $('#tabs').tabs('getSelected');
        $('#tabs').tabs('update', {
        tab: currTab,
        options: {
        content: tzMenu.loadFrame(title,url)
        }
        });            
        }
        */
        // 只保留一个选项卡
        $('#tabs').tabs('select', title);
        var currTab = $('#tabs').tabs('getSelected');
        $('#tabs').tabs('update', {
            tab: currTab,
            options: {
                title: title,
                content: tzMenu.loadFrame(url),
                closeable: true,
                icon: icon
            }
        });
    },
    loadFrame: function (url) {
        var s = '<iframe id="tabframe" scrolling="hidden" frameborder="0"  src="' + url + '" style="width:100%;height:100%;"></iframe>';
        return s;
    },
    isTitle: true,
    menuList: "",
    aClass: "haveChildClass"
};
$(function () {
    checkSession();
    //var userName = getParameter("userName");
    setUsername();

    $("#logout").bind("click", function () {
        clearSession();
    });
    $("#changePwd").bind("click", function () {
        var url = "", user = $("#user").val();
        url = "System/UpdatePwd.aspx?userName=" + user;
        tzWindow.open("winPwd", "修改密码", url);
    });
});

// 子页面查询方法
function search() {
    var currTab = $('#tabs').tabs('getSelected');
    currTab.find("iframe")[0].contentWindow.search();
}

function searchFrame() {
    var iframe = parent.$("#divMaps").find("iframe")[0];
    iframe.contentWindow.search();
}

function initMenu() {
    $.ajax({
        type: "GET",
        url: "_WebClass/IndexHandler.ashx?&getMenu=true&timeout=" + new Date().getTime(),
        cache: false,
        success: function (data) {
            var dd = eval("(" + data + ")");
            tzMenu.menu = dd;
            tzMenu._init();
        }
    });
}

function clearSession() {
    $.ajax({
        type: "GET",
        url: "_WebClass/SessionHandler.ashx?&loginout=true&timeout=" + new Date().getTime(),
        cache: false,
        success: function (data) {
            window.location.href = "Login.aspx";
        }
    });
}

function checkSession() {
    $.ajax({
        type: "GET",
        url: "_WebClass/SessionHandler.ashx?&checkSession=true&timeout=" + new Date().getTime(),
        cache: false,
        success: function (data) {
            if (data == "true") {
                initMenu();
            } else {
                window.location.href = "_Error/Error.aspx";
            }
        }
    });
}

function setUsername() {
    $.ajax({
        type: "GET",
        url: "_WebClass/SessionHandler.ashx?&getUserName=true&timeout=" + new Date().getTime(),
        cache: false,
        success: function (data) {
            $("#UserName").text(data);
            document.getElementById("user").value = data;
        }
    });
}

function getParameter(param) {
    var query = window.location.search;
    var iLen = param.length;
    var iStart = query.indexOf(param);
    if (iStart == -1)
        return "";
    iStart += iLen + 1;
    var iEnd = query.indexOf("&", iStart);
    if (iEnd == -1)
        return query.substring(iStart);

    return query.substring(iStart, iEnd);
}


// 任务树

var zTreeObj,
	setting = {
	    data: {
	        key: {
	            name: "Name"
	        },
	        simpleData: {
	            enable: true,
	            idKey: "Id",
	            pIdKey: "PId"
	        }
	    },
	    view: {
	        showTitle: true,
	        showLine: true,
	        showIcon: true
	    }
	},
zTreeNodes;

$(document).ready(function () {
    $.ajax({
        type: "GET",
        url: "_WebClass/IndexHandler.ashx?&getTaskTree=true&timeout=" + new Date().getTime(),
        cache: false,
        success: function (data) {
            $("#tree").empty();
            zTreeNodes = eval("(" + data + ")");
            zTreeObj = $.fn.zTree.init($("#tree"), setting, zTreeNodes);
            zTreeObj.expandAll(true);
            setTimeout(function () { $("#menu").children(".panel:eq(0)").children("div:eq(1)").append($("#tree")); }, 1000);
        }
    });
});

function selectnode(id, name, isTask) {
    if (isTask == "0") {
        tzMenu.openTab("作业简报", "Task/TaskManage.aspx?id=" + id, "icon");
    }
    else {
        tzMenu.openTab("任务跟踪", "Task/TaskMonitor.aspx?id=" + id, "icon");
    }
}

function refreshTree() {
    $.ajax({
        type: "GET",
        url: "_WebClass/IndexHandler.ashx?&getTaskTree=true&timeout=" + new Date().getTime(),
        cache: false,
        success: function (data) {
            $("#tree").html("");
            zTreeNodes = eval("(" + data + ")");
            zTreeObj = $.fn.zTree.init($("#tree"), setting, zTreeNodes);
            zTreeObj.expandAll(true);
            $("#menu").children(".panel:eq(0)").children("div:eq(1)").append($("#tree")); 
        }
    });
}

