﻿var tzSelect = {
    _init: function () {
        var myPolygonOptions = {
            strokeColor: "#DDA0DD",
            fillColor: '#1E90FF',
            fillOpacity: 0.6,
            strokeWeight: 2,
            clickable: false,
            zIndex: 1,
            editable: false
        };
        tzMap.polylineOption.strokeColor = "#0000FF";
        tzMap.polylineOption.strokeWeight = 2;
        tzSelect.drawingManager = new google.maps.drawing.DrawingManager({
            drawingMode: null,
            drawingControl: false,
            circleOptions: myPolygonOptions,
            polygonOptions: myPolygonOptions,
            rectangleOptions: myPolygonOptions,
            polylineOptions: tzMap.polylineOption
        });
        tzSelect.drawingManager.setMap(tzMap.map);
        google.maps.event.addListener(tzSelect.drawingManager, 'overlaycomplete', function (event) {

            if (event.type == google.maps.drawing.OverlayType.POLYGON) {
                tzSelect.polygonArr = new Array();
                var myBounds = new google.maps.LatLngBounds();
                event.overlay.getPath().forEach(function (el, index) {
                    tzSelect.polygonArr.push(el);
                    myBounds.extend(el);
                });
                tzMap.fitView(myBounds);
                tzSelect.Ids = "";
                tzMap.allFeaturesArr.forEach(function (el, index) {
                    if (el.btype == 0 && event.overlay.containsLatLng(el.position)) {
                        tzSelect.Ids += el.id;
                        tzSelect.Ids += ",";
                    } else { }
                });
                if (tzSelect.Ids.length > 0) {
                    tzSelect.Ids = tzSelect.Ids.substring(0, tzSelect.Ids.length - 1);
                    drawSearch(tzSelect.Ids);
                }

                tzSelect.drawingManager.setOptions({ drawingMode: null });
                setTimeout(function () { event.overlay.setMap(null); }, 1000);
            } else if (event.type == google.maps.drawing.OverlayType.CIRCLE) {
                tzSelect.rad = event.overlay.getRadius();
                tzSelect.polygonArr = new Array();
                tzSelect.polygonArr.push(event.overlay.center);
                var myBounds = event.overlay.getBounds();
                tzMap.fitView(myBounds);
                tzSelect.Ids = "";
                tzMap.allFeaturesArr.forEach(function (el, index) {
                    if (el.btype == 0 && myBounds.contains(el.position)) {
                        tzSelect.Ids += el.id;
                        tzSelect.Ids += ",";
                        // el.setMap(null);
                    } else { }

                });

                if (tzSelect.Ids.length > 0) {
                    tzSelect.Ids = tzSelect.Ids.substring(0, tzSelect.Ids.length - 1);
                    drawSearch(tzSelect.Ids);
                }

                tzSelect.drawingManager.setOptions({ drawingMode: null });
                setTimeout(function () { event.overlay.setMap(null); }, 1200);
            } else if (event.type == google.maps.drawing.OverlayType.RECTANGLE) {
                tzSelect.polygonArr = new Array();
                var ne = event.overlay.bounds.getNorthEast(), sw = event.overlay.bounds.getSouthWest();
                var mypoint1 = new google.maps.LatLng(sw.lat(), ne.lng()), mypoint2 = new google.maps.LatLng(ne.lat(), sw.lng());
                tzSelect.polygonArr.push(mypoint1);
                tzSelect.polygonArr.push(ne);
                tzSelect.polygonArr.push(mypoint2);
                tzSelect.polygonArr.push(sw);
                var myBounds = event.overlay.getBounds();
                tzMap.fitView(myBounds);

                tzSelect.Ids = "";
                tzMap.allFeaturesArr.forEach(function (el, index) {
                    if (el.btype == 0 && myBounds.contains(el.position)) {
                        tzSelect.Ids += el.id;
                        tzSelect.Ids += ",";
                        //el.setMap(null);
                    } else { }

                });
                if (tzSelect.Ids.length > 0) {
                    tzSelect.Ids = tzSelect.Ids.substring(0, tzSelect.Ids.length - 1);
                    drawSearch(tzSelect.Ids);
                }
                tzSelect.drawingManager.setOptions({ drawingMode: null });
                setTimeout(function () { event.overlay.setMap(null); }, 1200);
            } else { }
        });
    },
    drawFence: function (type) {
        tzSelect.fenceType = type;
        if (type == 0) {
            // 画圆
            tzSelect.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.CIRCLE });
        }
        else if (type == 1) {
            // 画多边行
            tzSelect.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.POLYGON });
        } else if (type == 2) {
            // 画矩形
            tzSelect.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.RECTANGLE });
        } else {
            tzSelect.drawingManager.setOptions({ drawingMode: null });
            return;
        }
    },
    fenceType: 0,
    rad: 0,
    Ids: "",
    polygonArr: new Array(),
    drawingManager: null
}

function select_zoom(gtype) {
    tzSelect.drawFence(gtype);
}
function drawSearch(guids) {
    firstExpand();
    $.ajax({
        type: "get",
        dataType: "text", //解决火狐下不能执行的问题
        url: "../VehilceMonitor/Handler/SelectVehHandler.ashx?&searchByConditions=true&timeout=" + new Date().getTime(),
        cache: false,
        data: { guids: guids, vehciid: $("#hiddenCiid").val() },
        success: function (data) {
            if (data != "") {
                window.top.document.getElementById('iframeCenter').contentWindow.loadSearchListBySql();
            }
            else {
                return false;
            }
        }
    });
}


