﻿// create by 王君涛 2012.09.20
var tzMenu = {
    menu: [{ id: 1, icon: 'icon-sys', title: '', url: '', menus: []}],
    _init: function (p) {
        for (var i = 0; i < tzMenu.menu.length; i++) {
            var submenu = tzMenu.menu[i];
            tzMenu.menuList = "<ul>";
            tzMenu.isTitle = true;
            tzMenu._menuTree(submenu);
            $("#menu").accordion("add", {
                title: submenu.title,
                content: tzMenu.menuList,
                iconCls: "icon " + submenu.icon
            });
        }
        tzMenu.menuList += "</ul>";
        tzMenu.hover();
        tzMenu.bindClick();

        if (p == "task") {
            $('#menu').accordion('select', '任务管理');
            tzMenu.openTab("工程任务", "Task/ProjectList.aspx", "icon");
            return;
        }

        if (p == "alarm") {
            $('#menu').accordion('select', '报警监控');
            tzMenu.openTab("当天报警", "Alarm/AlarmList.aspx", "icon");
            return;
        }
    },
    _menuTree: function (menu) {
        if (menu.menus.length > 0) {
            if (!tzMenu.isTitle) {
                tzMenu.menuList += '<li><div><a class="' + tzMenu.aClass + '"><span class="icon ' + menu.icon
					+ '" >&nbsp;</span><span>' + menu.title + '</span></a>';
            }
            for (var i = 0; i < menu.menus.length; i++) {
                tzMenu.isTitle = false;
                tzMenu._menuTree(menu.menus[i]);
            }
        } else {
            tzMenu.aClass = "haveNotChildClass";
            if (menu.url == "#") {
                tzMenu.menuList += '<li><div> '
            } else {
                tzMenu.menuList += '<li><div><a class="' + tzMenu.aClass + '"ref="' + menu.id + '" href="#" rel="'
					+ menu.url + '" ><span class="icon ' + menu.icon
					+ '" >&nbsp;</span><span class="nav">' + menu.title
					+ '</span></a> '
            }
        }
    },
    hover: function () {
        $(".easyui-accordion").find('a').hover(function () {
            $(this).parent().addClass("hover");
        }, function () {
            $(this).parent().removeClass("hover");
        });
    },
    bindClick: function () {
        $('#menu li a').live('click', function () {
            var tabTitle = $(this).children('.nav').text();

            var url = $(this).attr("rel");
            var menuid = $(this).attr("ref");
            tzMenu.openTab(tabTitle, url, "icon");
            $('#menu li div').removeClass("selected");
            $(this).parent().addClass("selected");
        });
    },
    bindClick2:function(){
        $('#menu li span').live('click', function () {
            var tabTitle = $(this).text();

            var url = $(this).attr("name");            
            tzMenu.openTab(tabTitle, url, "icon");
            $('#menu li div').removeClass("selected");
            $(this).parent().addClass("selected");
        });
    },
    openTab: function (title, url, icon) {
        if (title == "" || typeof (title) == "undefined") {
            return;
        }
        // 只保留一个选项卡
        $('#tabs').tabs('select', title);
        var currTab = $('#tabs').tabs('getSelected');
        $('#tabs').tabs('update', {
            tab: currTab,
            options: {
                title: title,
                content: tzMenu.loadFrame(url),
                closeable: true,
                icon: icon
            }
        });
    },
    loadFrame: function (url) {
        var s = '<iframe id="tabframe" scrolling="hidden" frameborder="0"  src="' + url + '" style="width:100%;height:100%;"></iframe>';
        return s;
    },
    isTitle: true,
    menuList: "",
    aClass: "haveChildClass"
};
$(function () {
    var p = getParameter("p");
    initMenu(p);   
     
});

// 子页面查询方法
function search() {
    var currTab = $('#tabs').tabs('getSelected');
    currTab.find("iframe")[0].contentWindow.search();
}

function searchFrame() {
    var iframe = parent.$("#divMaps").find("iframe")[0];
    iframe.contentWindow.search();
}

function initMenu(p) {
    $.ajax({
        type: "GET",
        url: "_WebClass/IndexHandler.ashx?&getMenu=true&timeout=" + new Date().getTime(),
        cache: false,
        success: function (data) {

            if (data == "sessionmiss") {
                parent.location.href = "_Error/Error.aspx";
                return;
            }

            $("#menu").append(data);

            tzMenu.bindClick2();
            $(".ulwrraper").find('a').hover(function () {
                $(this).parent().addClass("hover");
            }, function () {
                $(this).parent().removeClass("hover");
            });

            if (p == "task") {
                tzMenu.openTab("工程任务", "Task/ProjectList.aspx", "icon");
                return;
            }

            if (p == "alarm") {
                var num = getParameter("num");
                tzMenu.openTab("当天报警", "Alarm/AlarmList.aspx?num=" + num, "icon");
                return;
            }
        }
    });
}

function getParameter(param) {
    var query = window.location.search;
    var iLen = param.length;
    var iStart = query.indexOf(param);
    if (iStart == -1)
        return "";
    iStart += iLen + 1;
    var iEnd = query.indexOf("&", iStart);
    if (iEnd == -1)
        return query.substring(iStart);

    return query.substring(iStart, iEnd);
}