﻿// create by 王君涛 2012.06.01
// google v3 API 封装

var tzOverlayType = { MARKER: 0, POLYLINE: 1, POLYGON: 2, CIRCLE: 3, RECTANGLE: 4 };

var tzMap = {
    init: function (handel) {
        this.defaultIcon = "_Css/images/run.png";
        this.mapOption.center = new google.maps.LatLng(32.397, 118.644);
        this.mapOption.zoom = 4;
        this.mapOption.mapTypeId = google.maps.MapTypeId.ROADMAP;
        tzMap.map = new google.maps.Map(document.getElementById(handel), this.mapOption);
        this.allFeaturesArr = new google.maps.MVCArray();
        this.isOK = true;
        if (typeof (MapLabel) != "undefined") {
            MapLabelProperty();
        }

        tzPlugin();
        initMapOption();
    },
    addTrafficLayer: function () {
        if (tzMap.trafficLayer == null) {
            tzMap.trafficLayer = new google.maps.TrafficLayer();
        }
        tzMap.trafficLayer.setMap(tzMap.map);
        //$("#sslk").addClass("curs");
    },
    removeTrafficLayer: function () {
        tzMap.trafficLayer.setMap(null);
        //$("#sslk").removeClass("curs");
    },
    setZoomAndCenter: function (lng, lat, level) {
        if (lat == "" || lat == undefined || lng == "" || lng == undefined || level == "" || level == undefined) {
            return;
        }
        tzMap.map.setCenter(new google.maps.LatLng(lat, lng));
        tzMap.map.setZoom(level);
    },
    setCenterById: function (Id) {
        tzMap.allFeaturesArr.forEach(function (el, index) {
            if (el.otype == tzOverlayType.MARKER && el.id == Id) {
                tzMap.map.setCenter(el.getPosition());
                tzMap.map.setZoom(15);
                google.maps.event.trigger(el, "click");
            }
        });
    },
    setCenterByArea: function (Id) {
        tzMap.allFeaturesArr.forEach(function (el, index) {
            if ((el.otype == tzOverlayType.POLYGON || el.otype == tzOverlayType.CIRCLE || el.otype == tzOverlayType.RECTANGLE) && el.id == Id && el.map != null) {
                tzMap.fitView(el.getBounds());
            }
        });
    },
    openInfoWindow: function (myMarker, content) {
        google.maps.event.addListener(myMarker, 'click', function () {
            var myinfoWindowOption = {
                content: content,
                disableAutoPan: false,
                maxWidth: 400,
                pixelOffset: new google.maps.Size(-2, -2),
                position: myMarker.getPosition()
            };
            var myInfoWindow = new google.maps.InfoWindow(myinfoWindowOption);
            if (tzMap.lastInfoWinfow != null && tzMap.lastInfoWinfow != undefined) {
                tzMap.lastInfoWinfow.open(null);
            }
            myInfoWindow.open(tzMap.map);
            tzMap.lastInfoWinfow = myInfoWindow;
        });
    },
    addPoints: function (pointArray, isCenter) { // [{lng:'',lat:'',iurl:'',tipTxt:''},{lng:'',lat:'',iurl:'',tipTxt:''}]
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var icon = null, content = "", lng = "", lat = "";
        for (var i = 0; i < pointArray.length; i++) {
            lng = pointArray[i]["lng"], lat = pointArray[i]["lat"];

            if (lat == "" || lng == "") { continue; }

            if (pointArray[i]["iurl"] != "") {
                icon = new google.maps.MarkerImage(pointArray[i]["iurl"]);
            } else {
                icon = new google.maps.MarkerImage(tzMap.defaultIcon);
            }
            tzMap.markerOption.icon = icon;
            var latlng = new google.maps.LatLng(lat, lng);
            tzMap.markerOption.position = latlng;
            var myMarker = new google.maps.Marker(tzMap.markerOption);
            var content = pointArray[i]["tipTxt"];
            // 弹出框
            if (content != "" && content != undefined) {
                tzMap.openInfoWindow(myMarker, content);
            }
            tzMap._addToMap(myMarker);
        }
        if (isCenter && pointArray.length == 1 && lat != "" && lng != "") { // 单点时设置中心点
            tzMap.setZoomAndCenter(lng, lat, 7);
        }
    },
    addMarker: function (markerOption) { // {lng:'',lat:'',icon:'',content:'',text:'',becenter:false,id:''}
        if (markerOption == null || markerOption == "undefined" || markerOption.lat == "" || markerOption.lng == "") {
            return;
        }
        if (markerOption.icon != "") {
            tzMap.markerOption.icon = markerOption.icon;
        }
        var latlng = new google.maps.LatLng(markerOption.lat, markerOption.lng);
        tzMap.markerOption.position = latlng;
        tzMap.markerOption.id = markerOption.id || '';
        var myMarker = new google.maps.Marker(tzMap.markerOption);

        if (markerOption.content != "") {
            tzMap.openInfoWindow(myMarker, markerOption.content);
        }

        tzMap._addToMap(myMarker);

        if (markerOption.text != "") {
            tzMap.addMaplabel({ lng: markerOption.lng, lat: markerOption.lat, text: markerOption.text });
        }

        if (markerOption.becenter) {
            tzMap.setZoomAndCenter(markerOption.lng, markerOption.lat, 7);
        }
    },
    addMaplabel: function (labelOption) { // {lng:'',lat:'',text:''} 需要支持HTML5
        if (labelOption == null || labelOption == "undefined" || typeof (MapLabel) == "undefined") {
            return;
        }
        MapLabel.btype = tzMap.markerOption.btype;
        var mapLabel = new MapLabel({
            text: labelOption.text,
            position: new google.maps.LatLng(labelOption.lat, labelOption.lng),
            fontSize: 14,
            align: 'center',
            strokeColor: '#000000',
            strokeWeight: 1,
            fontColor: '#000000',
            btype: 0
        });

        tzMap._addToMap(mapLabel);
    },
    addMarkerLabel: function (labelOption) { // {id:'',lng:'',lat:'',labelContent:''}
        if (labelOption == null || labelOption == "undefined" || typeof (MapLabel) == "undefined") {
            return;
        }
        MarkerWithLabel.btype = tzMap.markerOption.btype;
        var markerLabel = new MarkerWithLabel({
            id: labelOption.id || "",
            position: new google.maps.LatLng(labelOption.lat, labelOption.lng),
            draggable: false,
            icon: labelOption.icon,
            labelContent: labelOption.labelContent,
            labelAnchor: new google.maps.Point(60, 0),
            labelClass: "markerlabel", // the CSS class for the label
            labelStyle: { opacity: 0.75 },
            otype: tzOverlayType.MARKER,
            btype: 0
        });

        if (labelOption.content != "") {
            tzMap.openInfoWindow(markerLabel, labelOption.content);
        }

        if (labelOption.becenter) {
            tzMap.setZoomAndCenter(labelOption.lng, labelOption.lat, 7);
        }

        tzMap._addToMap(markerLabel);
    },
    _zoomHandler: function (level) {
        if (middleCaller == undefined) { return; }
        var mymiddle = middleCaller || null;
        if (level >= 4) {
            // 回调加载Table数据
            if (mymiddle != null && mymiddle != undefined) {

                var mapBounds = tzMap.map.getBounds(),
                    maxX = mapBounds.getNorthEast().lng(),
                    maxY = mapBounds.getNorthEast().lat(),
                    minX = mapBounds.getSouthWest().lng(),
                    minY = mapBounds.getSouthWest().lat();

                mymiddle.zhch(level, maxX, minX, maxY, minY);
            }
        } else if (level >= 8) {
            // 回调
            if (mymiddle != null && mymiddle != undefined) {

                var mapBounds = tzMap.map.getBounds(),
                    maxX = mapBounds.getNorthEast().lng(),
                    maxY = mapBounds.getNorthEast().lat(),
                    minX = mapBounds.getSouthWest().lng(),
                    minY = mapBounds.getSouthWest().lat();

                mymiddle.zhch(level, maxX, minX, maxY, minY);
            }
        }
    },
    _addToMap: function (obj) {
        if (obj !== undefined && obj != null) {
            if (tzMap.allFeaturesArr == null) {
                tzMap.allFeaturesArr = new google.maps.MVCArray();
            }
            tzMap.allFeaturesArr.push(obj);
            obj.setMap(tzMap.map);
        }
    },
    getBounds: function (pointArray) {
        if (typeof (pointArray) == "undefined" || pointArray.length == 0) {
            return null;
        }
        var myBounds = new google.maps.LatLngBounds();
        for (var i = 0; i < pointArray.length; i++) {
            myBounds.extend(pointArray[i]);
        }
        return myBounds;
    },
    fitView: function (bounds) {
        if (typeof (bounds) != "undefined" && bounds != null) {
            tzMap.map.fitBounds(bounds);
        }
    },
    fitAllView: function () { // 自适应视野范围
        if (tzMap.allFeaturesArr != null && tzMap.allFeaturesArr.getLength() > 0) {
            var myBounds = new google.maps.LatLngBounds();
            tzMap.allFeaturesArr.forEach(function (el, index) {
                if (typeof (el.getPosition) != "undefined" && el.map != null) {
                    myBounds.extend(el.getPosition());
                } else if (typeof (el.getBounds) != "undefined" && el.map != null) {
                    myBounds.extend(el.getBounds().getNorthEast());
                    myBounds.extend(el.getBounds().getSouthWest());
                } else if (typeof (el.getPath) != "undefined" && el.map != null) {
                    el.getPath().forEach(function (el, index) {
                        myBounds.extend(el);
                    });
                } else {

                }
            });
            if (!myBounds.isEmpty()) {
                tzMap.map.fitBounds(myBounds);
            }
        }
    },
    hideFeaturesByType: function (btype) {
        tzMap.allFeaturesArr.forEach(function (el, index) {
            if (el.btype == btype) {
                el.setMap(null);
            }
        });
    },
    showFeaturesByType: function (btype) {
        tzMap.allFeaturesArr.forEach(function (el, index) {
            if (el.btype == btype) {
                el.setMap(tzMap.map);
            }
        });
    },
    removeById: function (id) {
        tzMap.allFeaturesArr.forEach(function (el, index) {
            if (el.id === id) {
                el.setMap(null);
            }
        });
    },
    addLine: function (pointArray, isCenter, id) { // [{lng:'',lat:''},{lng:'',lat:''}]
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var polylinePath = new Array();
        for (var i = 0; i < pointArray.length; i++) {
            polylinePath.push(new google.maps.LatLng(pointArray[i]["lat"], pointArray[i]["lng"]));
        }
        tzMap.polylineOption.path = polylinePath;
        tzMap.polylineOption.id = id || "";
        var polyline = new google.maps.Polyline(tzMap.polylineOption);
        tzMap._addToMap(polyline);
        if (isCenter) {
            tzMap.fitView(tzMap.getBounds(tzMap.polylineOption.path));
        }
    },
    addPolygon: function (pointArray, isCenter, content, icon, id) { // [{lng:'',lat:''},{lng:'',lat:''}]
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var polygonPath = new Array();
        for (var i = 0; i < pointArray.length; i++) {
            polygonPath.push(new google.maps.LatLng(pointArray[i]["lat"], pointArray[i]["lng"]));
        }
        tzMap.polygonOption.path = polygonPath;
        tzMap.polygonOption.id = id || "";
        var polygon = new google.maps.Polygon(tzMap.polygonOption);
        tzMap._addToMap(polygon);
        if (isCenter) {
            tzMap.fitView(tzMap.getBounds(polygonPath));
        }
        if (content != "" && content != "undefined" && content != null) {
            var bounds = tzMap.getBounds(polygonPath);
            var center = bounds.getCenter();
            tzMap.markerOption.btype = 2; // 工地
            tzMap.addMarker({ lng: center.lng(), lat: center.lat(), icon: icon, content: content, text: '', becenter: false });
        }
    },
    addCircle: function (lng, lat, radius, isCenter, content, icon, id) {
        if (lng == "" || lat == "" || radius == "" || lng == undefined || lat == undefined || radius == undefined) {
            return;
        }
        tzMap.circleOption.center = new google.maps.LatLng(lat, lng);
        tzMap.circleOption.radius = parseFloat(radius);
        tzMap.circleOption.id = id || "";
        var myCircle = new google.maps.Circle(tzMap.circleOption);
        tzMap._addToMap(myCircle);
        if (isCenter) {
            tzMap.fitView(myCircle.getBounds());
        }
        if (content != "" && content != "undefined" && content != null) {
            tzMap.markerOption.btype = 2;
            tzMap.addMarker({ lng: lng, lat: lat, icon: icon, content: content, text: '', becenter: false });
        }
    },
    clearMap: function () {
        if (tzMap.allFeaturesArr == null) {
            return;
        }
        tzMap.allFeaturesArr.forEach(function (el, index) {
            el.setMap(null);
        });
        if (tzMap.lastInfoWinfow != null) {
            tzMap.lastInfoWinfow.open(null);
        }
        tzMap.polygonOption.path.length = 0;
        tzMap.polylineOption.path.length = 0;
        tzMap.circleOption.center = null;
        tzMap.allFeaturesArr.clear();
    },
    clearMapByType: function (overlayType) {
        if (tzMap.allFeaturesArr == null) {
            return;
        }
        tzMap.allFeaturesArr.forEach(function (el, index) {
            if (typeof (el) != "undefined" && overlayType == el.otype && el.btype == 0) {
                el.setMap(null);
                // tzMap.allFeaturesArr.removeAt(index);
            }
        });
    },
    bindMousewheel: function () {
        google.maps.event.addListener(tzMap.map, "zoom_changed", function (e) {
            var level = tzMap.map.getZoom();
            tzMap._zoomHandler(level);
        });
        google.maps.event.addListener(tzMap.map, "dragend", function (e) {
            var level = tzMap.map.getZoom();
            tzMap._zoomHandler(level);
        });
    },
    zoomNext: function (zoomNextOption) {
        if (zoomNextOption == null || zoomNextOption == undefined) {
            return;
        }
        tzMap.setZoomAndCenter(zoomNextOption.lng, zoomNextOption.lat, zoomNextOption.zoomlevel);

        var mymiddle = middleCaller;
        if (mymiddle != null && mymiddle != undefined) {

            var mapBounds = tzMap.map.getBounds(),
                maxX = mapBounds.getNorthEast().lng(),
                maxY = mapBounds.getNorthEast().lat(),
                minX = mapBounds.getSouthWest().lng(),
                minY = mapBounds.getSouthWest().lat();

            mymiddle.zhchById(parseInt(zoomNextOption.zoomlevel), maxX, minX, maxY, minY, zoomNextOption.areaId);
        }
    },
    addGroundOverlay: function (groundOverlayOption) { // [{x1:0,y1:0,x2:0,y2:0,url:''},{{x1:0,y1:0,x2:0,y2:0,url:''}]
        if (groundOverlayOption == null || groundOverlayOption == undefined) {
            return;
        }
        for (var i = 0; i < groundOverlayOption.length; i++) {
            var myLatLngBound = new google.maps.LatLngBounds(new google.maps.LatLng(groundOverlayOption[i]['y1'], groundOverlayOption[i]['x1']), new google.maps.LatLng(groundOverlayOption[i]['y2'], groundOverlayOption[i]['x2']));
            var imgGround = new google.maps.GroundOverlay(groundOverlayOption[i]['url'].replace('MapType', 'GM'), myLatLngBound);
            imgGround.setMap(this.map);
        }
    },
    getAddress: function (lat, lng, address) {
        if (typeof (lat) == 'undefined' || lat == "" || typeof (lng) == 'undefined' || lng == "") {
            return;
        }
        if (typeof (address) == 'undefined') {
            return;
        }

        var latlng = new google.maps.LatLng(lat, lng);
        var geocoder = new google.maps.Geocoder();

        geocoder.geocode({ location: latlng }, function (results, status) {
            if (status == google.maps.GeocoderStatus.OK) {
                address = results[0].formatted_address;
            }
            else {
                address = "ERROR";
            }
        });
    },
    getDistance: function (s, e) {
        if (typeof google.maps.geometry === "undefined") { return ""; }
        return google.maps.geometry.spherical.computeDistanceBetween(s, e).toFixed(2);
    },
    computeLength: function (latLngArray) {
        if (typeof google.maps.geometry === "undefined") { return ""; }
        return google.maps.geometry.spherical.computeLength(latLngArray).toFixed(2);
    },
    computeArea: function (latLngArray) { // 闭合数组
        if (typeof google.maps.geometry === "undefined") { return ""; }
        return google.maps.geometry.spherical.computeArea(latLngArray).toFixed(2);
    },
    map: {},
    isOK: false,
    toolbar: null,
    defaultIcon: '',
    allFeaturesArr: null,
    lastInfoWinfow: null,
    trafficLayer: null,
    mapType: "google",
    mapOption: {},
    markerOption: { id: '', clickable: true, cursor: 'pointer', draggable: false, flat: false, icon: null, position: null, visible: true, otype: tzOverlayType.MARKER, btype: 0 },
    polylineOption: { id: '', path: new Array(), strokeColor: '#0000FF', fillColor: '#0000FF', strokeOpacity: 1, strokeWeight: 2, editable: false, otype: tzOverlayType.POLYLINE, btype: 4 },
    polygonOption: { id: '', path: new Array(), strokeColor: '#1E90FF', strokeOpacity: 0.5, strokeWeight: 1, fillColor: '#1E90FF', fillOpacity: 0.5, otype: tzOverlayType.POLYGON, btype: 2 },
    circleOption: { id: '', center: null, radius: 5, strokeColor: "#1E90FF", strokeOpacity: 0.9, strokeWeight: 1, fillColor: "#1E90FF", fillOpacity: 0.5, otype: tzOverlayType.CIRCLE, btype: 2 }
}



var tzDraw = {
    _init: function () {
        var myPolygonOptions = {
            strokeColor: "#DDA0DD",
            fillColor: '#1E90FF',
            fillOpacity: 0.6,
            strokeWeight: 2,
            clickable: false,
            zIndex: 1,
            editable: false
        };
        tzMap.polylineOption.strokeColor = "#0000FF";
        tzMap.polylineOption.strokeWeight = 2;
        tzDraw.drawingManager = new google.maps.drawing.DrawingManager({
            drawingMode: null,
            drawingControl: false,
            circleOptions: myPolygonOptions,
            polygonOptions: myPolygonOptions,
            rectangleOptions: myPolygonOptions,
            polylineOptions: tzMap.polylineOption
        });
        tzDraw.drawingManager.setMap(tzMap.map);
        google.maps.event.addListener(tzDraw.drawingManager, 'overlaycomplete', function (event) {
            tzMap.clearMap();
            try {
                var zoom = tzMap.map.getZoom();
                var center = tzMap.map.getCenter();
                drawMaintainDistrict($("#save_wor").val());
                drawMaintainDistrict($("#save_sta").val());
                tzMap.map.setCenter(center);
                tzMap.map.setZoom(zoom);
            }
            catch (ex) {

            }
            if (event.type == google.maps.drawing.OverlayType.POLYGON) {
                tzMap.allFeaturesArr.push(event.overlay);
                tzDraw.polygonArr = new Array();
                event.overlay.getPath().forEach(function (el, index) {
                    tzDraw.polygonArr.push(el);
                });
            } else if (event.type == google.maps.drawing.OverlayType.CIRCLE) {
                tzMap.allFeaturesArr.push(event.overlay);
                tzDraw.rad = event.overlay.getRadius();
                tzDraw.polygonArr = new Array();
                tzDraw.polygonArr.push(event.overlay.center);
            } else if (event.type == google.maps.drawing.OverlayType.RECTANGLE) {
                tzMap.allFeaturesArr.push(event.overlay);
                tzDraw.polygonArr = new Array();
                var ne = event.overlay.bounds.getNorthEast(), sw = event.overlay.bounds.getSouthWest();
                var mypoint1 = new google.maps.LatLng(sw.lat(), ne.lng()), mypoint2 = new google.maps.LatLng(ne.lat(), sw.lng());
                tzDraw.polygonArr.push(mypoint1);
                tzDraw.polygonArr.push(ne);
                tzDraw.polygonArr.push(mypoint2);
                tzDraw.polygonArr.push(sw);
            } else if (event.type == google.maps.drawing.OverlayType.POLYLINE) {
                tzMap.allFeaturesArr.push(event.overlay);
                tzDraw.polygonArr = new Array();
                event.overlay.getPath().forEach(function (el, index) {
                    tzDraw.polygonArr.push(el);
                });
            } else { }
            //drawingManager.setOptions({ drawingMode: null });
            var drawFinished = onDrawFinished;
            if (typeof (drawFinished) != "undefined" && drawFinished != null) {
                drawFinished();
            }
        });
    },
    drawFence: function (type) {
        tzDraw.fenceType = type;

        if (tzDraw.drawingManager == null) {
            tzDraw._init();
        }
        if (type == 0) {
            // 画圆
            tzDraw.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.CIRCLE });
        }
        else if (type == 1) {
            // 画多边行
            tzDraw.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.POLYGON });
        } else if (type == 2) {
            // 画矩形
            tzDraw.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.RECTANGLE });
        } else if (type == 3) {
            // 画线
            tzDraw.drawingManager.setOptions({ drawingMode: google.maps.drawing.OverlayType.POLYLINE });
        } else {
            // 禁用画图模式
            tzDraw.drawingManager.setOptions({ drawingMode: null });
            return;
        }
    },
    fenceType: 0,
    rad: 0,
    centerLat: '',
    centerLng: '',
    polygonArr: new Array(),
    drawingManager: null
}

function initMap() {
    var LoadDelay = document.getElementById("LoadDelay");
    if (LoadDelay != null) {
        setTimeout('tzMap.init("map")', 500);
    }
    else {
        tzMap.init("map");
    }
}


window.onload = initMap;

function initMapOption() {
    google.maps.Marker.otype = tzOverlayType.MARKER;
    google.maps.Polygon.otype = tzOverlayType.POLYGON;
    google.maps.Polyline.otype = tzOverlayType.POLYLINE;
    google.maps.Circle.otype = tzOverlayType.CIRCLE;
    google.maps.Rectangle.otype = tzOverlayType.RECTANGLE;
    // 0 : 车辆图标 ， 1：报警点图标, 2：工地 ，3：搅拌站， 4：线路 
    google.maps.Marker.btype = 0;
    google.maps.Polygon.btype = 2;
    google.maps.Polyline.btyte = 4;
    google.maps.Circle.btype = 2;
}

// Maplabel 属性初始化
function MapLabelProperty() {
    MapLabel.otype = tzOverlayType.MARKER;
    MapLabel.btype = 0;

    MarkerWithLabel.otype = tzOverlayType.MARKER;
    MarkerWithLabel.btype = 0;
}

function tzPlugin() {
    if (typeof (tzDraw) != "undefined") {
        setTimeout(function () { tzDraw._init() }, 1200);
    }
    
    if (typeof (tzSelect) != "undefined") {
        setTimeout(function () { tzSelect._init() }, 1200);
    }
}