﻿// create by 王君涛 2012.05.28 
// MapABC v3 API 封装
var tzOverlayType = { MARKER: 0, POLYLINE: 1, POLYGON: 2, CIRCLE: 3, RECTANGLE: 4 };
var tzMap = {
    init: function (handel) {

        tzMap.mapOption.center = new MMap.LngLat(106.08, 36.94);
        tzMap.mapOption.level = 4;
        tzMap.mapOption.jogEnable = true; // 缓动效果
        tzMap.mapOption.continuousZoomEnable = true; // 平滑缩放到下一级别      
        tzMap.map = new MMap.Map(handel, this.mapOption);

        tzMap.map.plugin(["MMap.ToolBar", "MMap.Scale"], function () {
            tzMap.toolbar = new MMap.ToolBar();
            tzMap.toolbar.autoPosition = false; //加载工具条   
            tzMap.map.addControl(tzMap.toolbar);
            var scale = new MMap.Scale(); //加载比例尺  
            tzMap.map.addControl(scale);
        });

        //地图拖拽事件
        tzMap.map.bind(tzMap.map, "dragend", function (e) {
            //大账号情况
            if ($('#hidUserIndex').val() == "1") {
                var level = tzMap.map.getZoom();
                // 大区、省不做事件处理
                if (level <= 6) { return; }
                if (tzMap.isEnableMousewheel) {
                    tzMap._zoomHandler(level);
                }
                //拖拽加载显示车辆
                if (level >= 7) {

                    //                    var bounds = tzMap.map.getBounds(); //返回MLngLatBounds类对象，该对象表示地图视野范围矩形区域西南和东北角点的经纬度坐标 
                    //                    var center = tzMap.map.getCenter();
                    //                    var centerX = center.lng; //通过对象的属性返回经度坐标 
                    //                    var centerY = center.lat; //通过对象的属性返回纬度坐标 
                    //                    $.ajax({
                    //                        type: "GET",
                    //                        url: "../VehilceMonitor/Handler/vehTogetherHandler.ashx?&timeout=" + new Date().getTime(),
                    //                        data: { method: '5', lng: centerX, lat: centerY },
                    //                        dataType: "text",
                    //                        success: function (data) {
                    //                            var provinceName = data;
                    //                            //避免同一省份加载
                    //                            if (provinceName != $('#hidProvinceName').val()) {
                    //                                tzMap.clearMapByType(tzOverlayType.MARKER);
                    //                                $('#hidProvinceName').val(data);
                    //                                //根据省份加载车辆
                    //                                loadVehByProvinceName(provinceName);
                    //                            }
                    //                        }
                    //                    });
                    var bounds = tzMap.map.getBounds(); //返回MLngLatBounds类对象，该对象表示地图视野范围矩形区域西南和东北角点的经纬度坐标 

                    $.ajax({
                        type: "GET",
                        url: "../VehilceMonitor/Handler/vehTogetherHandler.ashx?&timeout=" + new Date().getTime(),
                        data: { method: '6', lng1: bounds.southwest.lng, lat1: bounds.southwest.lat, lng2: bounds.northeast.lng, lat2: bounds.northeast.lat },
                        dataType: "text",
                        success: function (data) {
                            //避免同一省份加载
                            if (data != $('#hidProvinceName').val() && data != "[]") {
                                tzMap.clearMapByType(tzOverlayType.MARKER);
                                $('#hidProvinceName').val(data);
                                var provinceName = eval("(" + data + ")");
                                for (var i = 0; i < provinceName.length; i++) {
                                    //根据省份加载车辆
                                    loadVehByProvinceName(provinceName[i].name);
                                }
                            }
                        }
                    });
                }
            }
        });


        //地图缩放
        tzMap.map.bind(tzMap.map, "zoomchange", function (e) {
            var level = tzMap.map.getZoom();
            //车名车号显示
            if (level > 9) {
                $('.viewdiv').css("display", "block"); ;
            }
            else {
                $('.viewdiv').css("display", "none");
            }
            //大账号情况
            if ($('#hidUserIndex').val() == "1") {
                //大于市级别不显示车辆
                if (level < 7) {
                    tzMap.clearMapByType(tzOverlayType.MARKER);
                }
                //大区 省 图标切换
                if (level < 6) {
                    $('.provinceDiv').css("display", "none");
                    $('.bigareaDiv').css("display", "block");
                }
                else {
                    //显示省图标
                    if (level < 7) {
                        tzMap.clearMapByType(tzOverlayType.MARKER);
                        $('.provinceDiv').css("display", "block");
                        $('.bigareaDiv').css("display", "none");
                    }
                    else {
                        $('.provinceDiv').css("display", "none");
                        $('.bigareaDiv').css("display", "none");
                    }
                }
                //放大加载车辆
                if (level >= 7 && parseInt($('#hidLevel').val()) < 7) {
                    //                    var center = tzMap.map.getCenter();
                    //                    var centerX = center.lng; //通过对象的属性返回经度坐标 
                    //                    var centerY = center.lat; //通过对象的属性返回纬度坐标 
                    //                    $.ajax({
                    //                        type: "GET",
                    //                        url: "../VehilceMonitor/Handler/vehTogetherHandler.ashx?&timeout=" + new Date().getTime(),
                    //                        data: { method: '5', lng: centerX, lat: centerY },
                    //                        dataType: "text",
                    //                        success: function (data) {
                    //                            $('#hidProvinceName').val(data);
                    //                            var provinceName = data;
                    //                            //根据省份加载车辆
                    //                            loadVehByProvinceName(provinceName);
                    //                        }
                    //                    });
                    var bounds = tzMap.map.getBounds(); //返回MLngLatBounds类对象，该对象表示地图视野范围矩形区域西南和东北角点的经纬度坐标 

                    $.ajax({
                        type: "GET",
                        url: "../VehilceMonitor/Handler/vehTogetherHandler.ashx?&timeout=" + new Date().getTime(),
                        data: { method: '6', lng1: bounds.southwest.lng, lat1: bounds.southwest.lat, lng2: bounds.northeast.lng, lat2: bounds.northeast.lat },
                        dataType: "text",
                        success: function (data) {
                            if (data != "[]") {
                                $('#hidProvinceName').val(data);
                                var provinceName = eval("(" + data + ")");
                                for (var i = 0; i < provinceName.length; i++) {
                                    //根据省份加载车辆
                                    loadVehByProvinceName(provinceName[i].name);
                                }
                            }
                        }
                    });
                }
                //记录当前比例尺
                $('#hidLevel').val(level);
            }


            if (tzMap.isEnableMousewheel) {
                tzMap._zoomHandler(level);
            }
        });

        ExMapOption();
        tzMap.isOK = true;

        if (typeof mouseTool === "undefined") {
            tzSelect.init();
        }

        if (typeof first_load !== "undefined") {
            first_load();
        }
    },
    // 隐藏工具条
    hideToolbar: function () {
        tzMap.map.removeControl(tzMap.toolbar);
    },
    addEmptyLayer: function () {
        var emptyLayer = new MMap.TileLayer({
            id: "tzhidden",
            zIndex: 4,
            tileUrl: "http://tm.mapabc.com/trafficengine/mapabc/traffictile?v=1.0&t=1&x=[x]&y=[y]&zoom=[z]",
            getTileUrl: function (x, y, z) { return "http://tm.mapabc.com/trafficengine/mapabc/traffictile?t=1.0&t=1&x=" + x + "&y=" + y + "&zoom=" + (17 - z) }
        });
        tzMap.map.addLayer(emptyLayer);
    },
    removeEmptyLayer: function () {
        tzMap.map.removeLayer("tzhidden");
    },
    // 设置中心点和缩放级别
    setZoomAndCenter: function (lng, lat, level) {
        if (lat == "" || lat == undefined || lng == "" || lng == undefined || level == "" || level == undefined) {
            return;
        }
        tzMap.map.setZoomAndCenter(level, new MMap.LngLat(lng, lat));
    },
    // 设置某个Marker为中心区域
    setCenterById: function (Id) {
        //大账号登录
        if ($('#hidUserIndex').val() == "1") {
            //根据车辆所在省份加载该省份
            $.ajax({
                type: "GET",
                url: "../VehilceMonitor/Handler/vehTogetherHandler.ashx?&timeout=" + new Date().getTime(),
                data: { method: '7', guid: Id },
                dataType: "text",
                success: function (data) {
                    if (data != "[]" && data != "undefined") {
                        tzMap.clearMapByType(tzOverlayType.MARKER);
                        //先加载车辆当前所在省份
                        data = eval("(" + data + ")");
                        provinceClick(data[0].lng, data[0].lat, '15', data[0].name);
                        setTimeout(function () {
                            if (typeof Id !== "undefined") {
                                var markerArray = tzMap.map.getOverlaysByType("marker");
                                for (var i = 0; i < markerArray.length; i++) {
                                    if (markerArray[i].btype == 0 && markerArray[i].id == Id) {
                                        tzMap.map.setZoomAndCenter(15, markerArray[i].getPosition());
                                        tzMap.map.trigger(markerArray[i], "click");
                                        return;
                                    }
                                }
                            }
                        }, '1000');
                    }
                }
            });
        }
        //小账号
        else {
            if (typeof Id !== "undefined") {
                var markerArray = tzMap.map.getOverlaysByType("marker");
                for (var i = 0; i < markerArray.length; i++) {
                    if (markerArray[i].btype == 0 && markerArray[i].id == Id) {
                        tzMap.map.setZoomAndCenter(15, markerArray[i].getPosition());
                        tzMap.map.trigger(markerArray[i], "click");
                        return;
                    }
                }
            }
        }
    },
    // 设置某个覆盖物为中心区域
    setCenterByArea: function (Id) {
        if (typeof Id === "undefined") {
            return;
        }


        var circleArray = tzMap.map.getOverlaysByType("circle");
        for (var i = 0; i < circleArray.length; i++) {
            if (circleArray[i].id == Id) {
                var myArr2 = new Array();
                myArr2.push(circleArray[i]);
                tzMap.map.setFitView(myArr2);
                return;
            }
        }

        var polygonArray = tzMap.map.getOverlaysByType("polygon");
        for (var i = 0; i < polygonArray.length; i++) {
            if (polygonArray[i].id == Id) {
                var myArr = new Array();
                myArr.push(polygonArray[i]);
                tzMap.map.setFitView(myArr);
                return;
            }
        }
    },
    //新增Marker 参数格式： [{lng:'',lat:'',iurl:'',tipTxt:'',content:'',id:''},{lng:'',lat:'',iurl:'',tipTxt:'',content:'',id:''}]
    addPoints: function (pointArray, isCenter) {
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var icon = null, content = "", lng = "", lat = "";
        for (var i = 0; i < pointArray.length; i++) {
            lng = pointArray[i]["lng"], lat = pointArray[i]["lat"];

            if (lat == "" || lng == "") { continue; }

            if (pointArray[i]["iurl"] != "") {
                icon = new MMap.Icon({ size: new MMap.Size(85, 30), image: pointArray[i]["iurl"], imageOffset: new MMap.Pixel(0, 0) });
            }

            var markerOption = {
                position: new MMap.LngLat(lng, lat),
                offset: new MMap.Pixel(-1, -1),
                autoMove: true,
                draggable: false
            };
            if (pointArray[i]["id"] != "" && pointArray[i]["id"] != undefined) {
                markerOption.id = pointArray[i]["id"];
            }
            if (pointArray[i]["content"] != "" && pointArray[i]["content"] != undefined) {
                markerOption.content = pointArray[i]["content"];
            }
            if (icon != null) {
                markerOption.icon = icon;
            }
            var marker = new MMap.Marker(markerOption);
            marker.btype = tzMap.markerOption.btype;
            this.map.addOverlays(marker);

            if (pointArray[i]["content"] != "" && pointArray[i]["content"] != undefined) {
                tzMap.clickZoom(marker);
            }
            // 弹出框
            if (pointArray[i]["tipTxt"] != "" && pointArray[i]["tipTxt"] != undefined) {
                tzMap.openInfoWindow(marker, pointArray[i]["tipTxt"]);
            }
        }
        if (isCenter && pointArray.length == 1 && lat != "" && lng != "") { // 单点时设置中心点
            this.map.setZoomAndCenter(10, new MMap.LngLat(lng, lat));
        }
    },
    // 单个新增 Marker 参数格式： {id:dd[i].id, lng: dd[i].lng, lat: dd[i].lat, icon: imgURL, content: tip, becenter: false }
    addMarker: function (opt) {
        opt = opt || {};
        if (typeof opt.lng === "undefined" || typeof opt.lat === "undefined") {
            return;
        }

        var sizeX = opt.sizeX || 7, // X
             sizeY = opt.sizeY || 18; // 2Y

        if (typeof opt.img != "undefined") {
            tzMap.icon.image = opt.icon;
            tzMap.icon.size = new MMap.Size(2 * sizeX, sizeY);
        }
        var markerOption = {
            id: opt.id || '1',
            position: new MMap.LngLat(opt.lng, opt.lat),
            offset: new MMap.Pixel(-sizeX, -sizeY), // 需要根据图片大小做偏移
            icon: opt.icon || tzMap.defaultIcon,
            autoMove: true,
            draggable: false
        };

        var marker = new MMap.Marker(markerOption);
        marker.btype = tzMap.markerOption.btype;
        tzMap.map.addOverlays(marker);

        if (opt.becenter) {
            tzMap.setZoomAndCenter(opt.lng, opt.lat, 10);
        }

        if (opt.content != "") {
            tzMap.openInfoWindow(marker, opt.content);
        }
    },
    //新增markerLabel 参数格式： {lat:'',lng:'',icon:'',sizeX:10,sizeY:20,content:'',labelContent:'',becenter:false}
    addMarkerLabel: function (opt) {
        opt = opt || {};
        if (typeof opt.lng === "undefined" || typeof opt.lat === "undefined" || typeof (tzMap.map.addOverlays) == "undefined") {
            return;
        }

        var sizeX = opt.sizeX || 7, // X
             sizeY = opt.sizeY || 18; // 2Y

        if (typeof opt.img != "undefined") {
            tzMap.icon.image = opt.icon;
            tzMap.icon.size = new MMap.Size(2 * sizeX, sizeY);
        }
        var markerOption = {
            id: opt.id,
            position: new MMap.LngLat(opt.lng, opt.lat),
            offset: new MMap.Pixel(-sizeX, -sizeY), // 需要根据图片大小做偏移
            icon: opt.icon || tzMap.defaultIcon,
            autoMove: true,
            draggable: false
        };

        var marker = new MMap.Marker(markerOption);
        marker.btype = tzMap.markerOption.btype;
        tzMap.map.addOverlays(marker);

        if (opt.labelContent != '' && typeof (opt.labelContent) != 'undefined') {
            //label
            markerOption.offset = new MMap.Pixel(-sizeX - 50, -sizeY - 16);
            markerOption.content = opt.labelContent;
            markerOption.id = opt.id + "_label";
            markerOption.position = marker.getPosition();
            var label = new MMap.Marker(markerOption);
            label.btype = tzMap.markerOption.btype;
            tzMap.map.addOverlays(label);
        }

        if (opt.content != "") {
            var size = new MMap.Size(550, 0);
            tzMap.openInfoWindow(marker, opt.content, size);
            //tzMap.openInfoWindow(label, opt.content);
        }

        if (opt.becenter) {
            tzMap.setZoomAndCenter(opt.lng, opt.lat, 7);
        }
    },
    addMarkerLabel1: function (opt) {
        opt = opt || {};
        if (typeof opt.lng === "undefined" || typeof opt.lat === "undefined" || typeof (tzMap.map.addOverlays) == "undefined") {
            return;
        }

        var sizeX = opt.sizeX || 7, // X
             sizeY = opt.sizeY || 18; // 2Y

        if (typeof opt.img != "undefined") {
            tzMap.icon.image = opt.icon;
            tzMap.icon.size = new MMap.Size(2 * sizeX, sizeY);
        }
        var markerOption = {
            id: opt.id,
            position: new MMap.LngLat(opt.lng, opt.lat),
            offset: new MMap.Pixel(-sizeX, -sizeY), // 需要根据图片大小做偏移
            icon: opt.icon || tzMap.defaultIcon,
            autoMove: true,
            draggable: false
        };

        var marker = new MMap.Marker(markerOption);
        marker.btype = tzMap.markerOption.btype;
        tzMap.map.addOverlays(marker);

        tzMap.map.bind(marker, "click", function (e) {

            //inforWindow.open(mapObj, marker.getPosition());
            getAdress(opt.lng, opt.lat);
        });

        if (opt.labelContent != '' && typeof (opt.labelContent) != 'undefined') {
            //label
            markerOption.offset = new MMap.Pixel(-sizeX - 50, -sizeY - 16);
            markerOption.content = opt.labelContent;
            markerOption.id = opt.id + "_label";
            markerOption.position = marker.getPosition();
            var label = new MMap.Marker(markerOption);
            label.btype = tzMap.markerOption.btype;
            tzMap.map.addOverlays(label);
        }

        if (opt.content != "") {
            var size = new MMap.Size(550, 0);
            tzMap.openInfoWindow(marker, opt.content, size);
            //tzMap.openInfoWindow(label, opt.content);
        }

        if (opt.becenter) {
            tzMap.setZoomAndCenter(opt.lng, opt.lat, 7);
        }
    },
    updateMarkerLabel: function (opt) {
        opt = opt || {};
        if (typeof opt.lng === "undefined" || typeof opt.lat === "undefined") {
            return;
        }
        var lnglat = new MMap.LngLat(opt.lng, opt.lat);
        var myMarker = tzMap.map.getOverlays(opt.id);
        var myLabel = tzMap.map.getOverlays(opt.id + "_label");
        if (!myMarker) { return; }

        myMarker.setPosition(lnglat);
        //        if (opt.icon != "") {
        //            myMarker.setIcon(opt.icon);
        //        }
        myLabel.setPosition(lnglat);
        if (opt.labelContent != "") {
            myLabel.setContent("<div class='markerlabel'>" + opt.labelContent + '</div>');
        }

        if (opt.content != "") {
            tzMap.openInfoWindow(myMarker, opt.content);
            tzMap.openInfoWindow(myLabel, opt.content);
        }
    },
    // 点击缩放功能
    clickZoom: function (marker) {
        tzMap.map.bind(marker, "click", function (e) {
            // 点击聚合图标时禁用缩放处理
            tzMap.isEnableMousewheel = false;
            // 异步调用
            var mapcall = null || mapCaller;

            if (mapcall != null && mapcall != undefined) {
                mapcall.clickzoom(marker.id);
            }
        });
    },
    //私有方法 打开Infowindow
    openInfoWindow: function (marker, content, size) {
        var option = null;

        if (typeof (size) != "undefined") {
            option = { content: content, autoMove: true, size: size, offset: { x: -225, y: -80} };
        } else {
            option = { content: content, autoMove: true };
        }

        var inforWindow = new MMap.InfoWindow(option);
        tzMap.map.bind(marker, "click", function (e) {
            inforWindow.open(tzMap.map, marker.getPosition());
            tzMap.lastInfowindow = inforWindow;
        });
    },
    closeInfoWindow: function () {
        if (typeof (tzMap.lastInfowindow) != 'undefined' && tzMap.lastInfowindow != null) {
            tzMap.lastInfowindow.close();
        }
    },
    // 私有方法， 缩放处理事件
    _zoomHandler: function (level) {
        var mymiddle = null;
        if (typeof (mapCaller) != "undefined") {
            mymiddle = mapCaller;
        } else {
            return;
        }
        if (mymiddle != null && mymiddle != undefined) {

            var mapBounds = tzMap.map.getBounds(),
                    maxX = mapBounds.northeast.lng,
                    maxY = mapBounds.northeast.lat,
                    minX = mapBounds.southwest.lng,
                    minY = mapBounds.southwest.lat;

            mymiddle.wheelZoom(level, maxX, minX, maxY, minY);
        }
    },
    // 添加线
    addLine: function (pointArray, isCenter, id) {
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var polylinePath = new Array();
        for (var i = 0; i < pointArray.length; i++) {
            polylinePath.push(new MMap.LngLat(pointArray[i]["lng"], pointArray[i]["lat"]));
        }
        tzMap.polylineOption.id = id;
        tzMap.polylineOption.path = polylinePath;
        var polyline = new MMap.Polyline(tzMap.polylineOption);
        polyline.btype = tzMap.polylineOption.btype;
        tzMap.map.addOverlays(polyline);

        if (isCenter) {
            //tzMap.fitAllView();
            tzMap.map.setFitView();
        }
    },
    //添加面 
    addPolygon: function (pointArray, isCenter, content, icon, id, labelContent) {
        if (pointArray == null || pointArray == undefined || pointArray.length < 1) {
            return;
        }
        var polygonPath = new Array();
        for (var i = 0; i < pointArray.length; i++) {
            polygonPath.push(new MMap.LngLat(pointArray[i]["lng"], pointArray[i]["lat"]));
        }
        tzMap.polygonOption.path = polygonPath;
        tzMap.polygonOption.id = id || "1";
        var polygon = new MMap.Polygon(tzMap.polygonOption);
        polygon.btype = tzMap.polygonOption.btype;
        tzMap.map.addOverlays(polygon);

        if (isCenter) {
            tzMap.fitAllView();
        }
        if (content != "" && content != null && typeof (content) !== "undefined") {
            var center = polygon.getBounds().getCenter();
            tzMap.markerOption.btype = tzMap.circleOption.btype;
            tzMap.addMarkerLabel({ id: id + "_center", lat: center.lat, lng: center.lng, icon: icon, sizeX: tzMap.sizeX, sizeY: tzMap.sizeY, content: content, becenter: false, labelContent: labelContent });
            tzMap.markerOption.btype = 0;
        }
    },
    // 添加圆
    addCircle: function (lng, lat, radius, isCenter, content, icon, id, labelContent) {
        tzMap.circleOption.center = new MMap.LngLat(lng, lat);
        tzMap.circleOption.radius = radius;
        tzMap.circleOption.id = id || "1";
        var circle = new MMap.Circle(tzMap.circleOption);
        circle.btype = tzMap.circleOption.btype;
        tzMap.map.addOverlays(circle);

        if (isCenter) {
            tzMap.fitAllView();
        }
        if (content != "" && content != null && typeof (content) !== "undefined") {
            //{id:'',lat:'',lng:'',icon:'',sizeX:10,sizeY:20,content:'',becenter:false}
            tzMap.markerOption.btype = tzMap.circleOption.btype;
            tzMap.addMarkerLabel({ id: id + "_center", lat: lat, lng: lng, icon: icon, sizeX: tzMap.sizeX, sizeY: tzMap.sizeY, content: content, becenter: false, labelContent: labelContent });
            tzMap.markerOption.btype = 0;
        }
    },
    // 清除覆盖物
    clearMap: function () {
        if (tzMap.map != undefined) {
            tzMap.map.clearOverlays();
        }
    },
    // 依据覆盖物类型清除覆盖物
    clearMapByType: function (type) {
        if (typeof type === "undefined" || tzMap.map.getOverlaysByType == null) {
            return;
        }
        // 处理逻辑clearOverlaysByType 参数： marker、polyline、polygon、circle
        if (type == tzOverlayType.MARKER) {
            var markerArray = tzMap.map.getOverlaysByType("marker");
            for (var i = 0; i < markerArray.length; i++) {
                if (markerArray[i].btype == 0) {
                    tzMap.map.removeOverlays(markerArray[i].id);
                }
            }
            return;
        }
        if (type == tzOverlayType.CIRCLE) {
            tzMap.map.clearOverlaysByType("circle");
            return;
        }
        if (type == tzOverlayType.POLYGON || type == tzOverlayType.RECTANGLE) {
            tzMap.map.clearOverlaysByType("polygon");
            return;
        }

        if (type == tzOverlayType.POLYLINE) {
            tzMap.map.clearOverlaysByType("polyline");
            return;
        }
    },
    // 根据Id移除 Marker 
    removeById: function (id) {
        var markerArray = tzMap.map.getOverlaysByType("marker");
        for (var i = 0; i < markerArray.length; i++) {
            if (markerArray[i].id == id) {
                tzMap.map.removeOverlays(id);
            }
        }
    },
    // 依据类型隐藏覆盖物
    hideFeaturesByType: function (btype) {
        // 0 : 车辆图标 ， 1：报警点图标, 2：工地 ，3：搅拌站， 4：线路 
        var markerArray = tzMap.map.getOverlaysByType("marker");
        for (var i = 0; i < markerArray.length; i++) {
            if (markerArray[i].btype == btype) {
                if (typeof markerArray[i].hide == 'undefined') {
                    markerArray[i].setVisible(false);
                } else {
                    markerArray[i].hide();
                }
            }
        }

        var circleArray = tzMap.map.getOverlaysByType("circle");
        for (var i = 0; i < circleArray.length; i++) {
            if (circleArray[i].btype == btype) {
                if (typeof circleArray[i].hide == 'undefined') {
                    circleArray[i].visible == false;
                } else {
                    circleArray[i].hide();
                }
            }
        }

        var polygonArray = tzMap.map.getOverlaysByType("polygon");
        for (var i = 0; i < polygonArray.length; i++) {
            if (polygonArray[i].btype == btype) {
                if (typeof polygonArray[i].hide == 'undefined') {
                    polygonArray[i].visible == false;
                } else {
                    polygonArray[i].hide();
                }
            }
        }

        var polylineArray = tzMap.map.getOverlaysByType("polyline");
        for (var i = 0; i < polylineArray.length; i++) {
            if (polylineArray[i].btype == btype) {
                if (typeof polylineArray[i].hide == 'undefined') {
                    polylineArray[i].visible == false;
                } else {
                    polylineArray[i].hide();
                }
            }
        }

    },
    showFeaturesByType: function (btype) {
        var markerArray = tzMap.map.getOverlaysByType("marker");
        for (var i = 0; i < markerArray.length; i++) {
            if (markerArray[i].btype == btype && markerArray[i].visible == false) {
                markerArray[i].setVisible(true);
            }
        }

        var circleArray = tzMap.map.getOverlaysByType("circle");
        for (var i = 0; i < circleArray.length; i++) {
            if (circleArray[i].btype == btype && circleArray[i].visible == false) {
                circleArray[i].show();
            }
        }

        var polygonArray = tzMap.map.getOverlaysByType("polygon");
        for (var i = 0; i < polygonArray.length; i++) {
            if (polygonArray[i].btype == btype && polygonArray[i].visible == false) {
                polygonArray[i].show();
            }
        }

        var polylineArray = tzMap.map.getOverlaysByType("polyline");
        for (var i = 0; i < polylineArray.length; i++) {
            if (polylineArray[i].btype == btype && polylineArray[i].visible == false) {
                polylineArray[i].show();
            }
        }
    },
    // 自适应视野范围
    fitAllView: function () {
        tzMap.map.setFitView();
    },
    // 滚动缩放事件
    bindMousewheel: function () {
        tzMap.map.bind(tzMap.map, "zoomchange", function (e) {
            var level = tzMap.map.getZoom();
            if (tzMap.isEnableMousewheel) {
                tzMap._zoomHandler(level);
            }
        });

        tzMap.map.bind(tzMap.map, "dragend", function (e) {
            var level = tzMap.map.getZoom();
            alert("111");
            // 大区、省不做事件处理
            if (level <= 6) { return; }
            if (tzMap.isEnableMousewheel) {
                tzMap._zoomHandler(level);
            }
        });
        tzMap.map.setCenter(new MMap.LngLat(106.08, 36.94));
    },
    // 缩放到下一级事件
    zoomNext: function (zoomNextOption) {
        if (zoomNextOption == null || zoomNextOption == undefined) {
            return;
        }
        tzMap.map.setCenter(new MMap.LngLat(zoomNextOption.lng, zoomNextOption.lat));
        tzMap.map.setZoom(parseInt(zoomNextOption.zoomlevel));

        var mymiddle = middleCaller;
        if (mymiddle != null && mymiddle != undefined) {

            var mapBounds = tzMap.map.getBounds(),
            maxX = mapBounds.northeast.lng,
            maxY = mapBounds.northeast.lat,
            minX = mapBounds.southwest.lng,
            minY = mapBounds.southwest.lat;

            mymiddle.zhchById(parseInt(zoomNextOption.zoomlevel), maxX, minX, maxY, minY, zoomNextOption.areaId);
        }
    },
    // 添加实时交通图层
    addTrafficLayer: function () {
        Trafficlay = new MMap.TileLayer({
            tileSize: 256,
            id: "tile_traffic",
            getTileUrl: function (x, y, z) {
                return "http://tm.mapabc.com/trafficengine/mapabc/traffictile?v=1.0&t=1&zoom=" + (17 - z) + "&x=" + x + "&y=" + y;
            }
        });
        tzMap.map.addLayer(Trafficlay);
        //$("#sslk").addClass("curs");
    },
    // 隐藏实时交通图层
    removeTrafficLayer: function () {
        tzMap.map.removeLayer("tile_traffic");
        //$("#sslk").removeClass("curs");
    },
    // 计算两点间距离
    getDistance: function (s, e) {
        if (typeof s === "undefined" || typeof e === "undefined") { return ""; }
        return tzMap.map.getDistance(s, e).toFixed(2);
    },
    // 计算面积
    computeLength: function (latLngArray) {
        if (typeof latLngArray === "undefined" || latLngArray.length < 2) { return ""; }
        var r = 0, l = latLngArray.length;
        for (var i = 0; i < l - 1; i++) {
            r += parseFloat(tzMap.map.getDistance(latLngArray[i], latLngArray[i + 1]));
        }
        return r.toFixed(2);
    },
    map: {},
    isEnableMousewheel: true,
    isOK: false,
    toolbar: null,
    mapOption: {},
    defaultIcon: '../_Css/images/run.png',
    sizeX: 10,
    sizeY: 20,
    mapType: "mapabc",
    lastInfowindow: null,
    markerOption: { id: '', position: null, offset: null, icon: "", autoMove: true, draggable: false, btype: 0 },
    polylineOption: { id: '', path: new Array(), strokeColor: '#0000FF', strokeOpacity: 1, strokeWeight: 2, strokeStyle: 'solid', btype: 4 },
    polygonOption: { id: '', path: new Array(), strokeColor: '#0000FF', strokeOpacity: 0.5, strokeWeight: 2, fillColor: '#1E90FF', fillOpacity: 0.5, btype: 2 },
    circleOption: { id: '', center: null, radius: 5, strokeColor: "#1E90FF", strokeOpacity: 0.9, strokeWeight: 2, fillColor: "#1E90FF", fillOpacity: 0.5, btype: 2 }
}

var tzDraw = {
    // 画电子围栏
    drawFence: function (type) {
        tzDraw.fenceType = type;
        if (type == 0) {
            // 画圆
            tzMap.map.plugin(["MMap.MouseTool"], function () {
                tzDraw.mousetool = new MMap.MouseTool(tzMap.map);
                tzDraw.mousetool.circle();
                tzMap.map.bind(tzDraw.mousetool, "draw", function (e) {
                    tzDraw.rad = e.radius;
                    tzDraw.polygonArr.push(e.center);
                    tzDraw.centerLat = e.center.lat;
                    tzDraw.centerLng = e.center.lng;
                    tzDraw.mousetool.close();
                    drawpageCallback();
                });
            });
        }
        else if (type == 1) {
            // 画多边行
            tzMap.map.plugin(["MMap.MouseTool"], function () {
                tzDraw.mousetool = new MMap.MouseTool(tzMap.map);
                tzDraw.mousetool.polygon(null);
                tzMap.map.bind(tzDraw.mousetool, "draw", function (e) {
                    if (e.path.length > 0) {
                        tzDraw.polygonArr = e.path;
                        var center = e.getBounds().getCenter();
                        tzDraw.centerLat = center.lat;
                        tzDraw.centerLng = center.lng;
                        drawpageCallback();
                    }
                    tzDraw.mousetool.close();
                });
            });
        } else if (type == 2) {
            // 画矩形     
            tzMap.map.plugin(["MMap.MouseTool"], function () {
                tzDraw.mousetool = new MMap.MouseTool(tzMap.map);
                tzDraw.mousetool.rectangle();
                tzMap.map.bind(tzDraw.mousetool, "draw", function (e) {
                    if (e.path.length > 0) {
                        tzDraw.polygonArr = e.path;
                        var center = e.getBounds().getCenter();
                        tzDraw.centerLat = center.lat;
                        tzDraw.centerLng = center.lng;
                        drawpageCallback();
                    }
                    tzDraw.mousetool.close();
                });
            });
        } else if (type == 3) {
            // 画线            
            tzMap.map.plugin(["MMap.MouseTool"], function () {
                tzDraw.mousetool = new MMap.MouseTool(tzMap.map);
                tzDraw.mousetool.polyline();
                tzMap.map.bind(tzDraw.mousetool, "draw", function (e) {
                    if (e.path.length > 0) {
                        tzDraw.polygonArr = e.path;
                        drawpageCallback();
                    }
                    tzDraw.mousetool.close();
                });
            });
        } else {
            // 禁用画图模式
            tzDraw.mousetool.close();
        }

    },
    fenceType: 0,
    rad: 0,
    centerLat: '',
    centerLng: '',
    polygonArr: new Array(),
    mousetool: null
}

function initMap() {
    var LoadDelay = document.getElementById("LoadDelay");
    if (LoadDelay != null) {
        setTimeout('tzMap.init("map")', 500);
    }
    else {
        tzMap.init("map");
    }
    
}

window.onload = initMap;
// 画电子围栏回调页面函数
function drawpageCallback() {   
    if (typeof (onDrawFinished) != "undefined" && onDrawFinished != null) {
        onDrawFinished();
    }
}


//业务相关扩展
var tzOverlayType = { MARKER: 0, POLYLINE: 1, POLYGON: 2, CIRCLE: 3, RECTANGLE: 4 };
// 业务相关扩展属性
function ExMapOption() {  
    // 0 : 车辆图标 ， 1：报警点图标, 2：工地 ，3：搅拌站， 4：线路 
    MMap.Marker.btype = 0;
    MMap.Polygon.btype = 2;
    MMap.Polyline.btyte = 4;
    MMap.Circle.btype = 2;
}

// Bounds获取中心点扩展
MMap.Bounds.prototype.getCenter = function () {
    var centerLng = (this.southwest.lng + this.northeast.lng) / 2,
                 centerLat = (this.southwest.lat + this.northeast.lat) / 2;
    return new MMap.LngLat(centerLng, centerLat);
}

// Bounds 是否包含某经纬度扩展
MMap.Bounds.prototype.contains = function (e) {
    return e.lat > this.southwest.lat && e.lat < this.northeast.lat && e.lng > this.southwest.lng && e.lng < this.northeast.lng;
}

// 圆获取外界Bounds扩展
MMap.Circle.prototype.getBound = function () {
    var bounds = this.getBounds();
    var sw = new MMap.LngLat(bounds.southwest.lng, bounds.northeast.lat),
                 ne = new MMap.LngLat(bounds.northeast.lng, bounds.southwest.lat);
    return new MMap.Bounds(sw, ne);
}

// Circle 是否包含某经纬扩展
MMap.Circle.prototype.contains = function (e) {
    var self = this, obj = this.a;
    return self.getRadius() > obj.getDistance(self.getCenter(), e);
}

// Bounds extend包含某经纬度扩展
MMap.Bounds.prototype.extend = function (e) {
    if (this.contains(e)) {
        return this;
    }
    var lngmax, lngmin, latmax, latmin;
    lngmax = e.lng > this.northeast.lng ? e.lng : this.northeast.lng;
    latmax = e.lat > this.northeast.lat ? e.lat : this.northeast.lat;

    lngmin = e.lng < this.southwest.lng ? e.lng : this.southwest.lng;
    latmin = e.lat < this.southwest.lat ? e.lat : this.southwest.lat;
    var sw = new MMap.LngLat(lngmin, latmin), ea = new MMap.LngLat(lngmax, latmax);

    return new MMap.Bounds(sw, ea);
}

// Polygon对象获取外接矩形扩展
MMap.Polygon.prototype.getBounds = function () {
    var path = this.getPath();
    if (typeof path === "undefined" || path.length < 2) {
        return null;
    }

    var bounds = new MMap.Bounds(path[0], path[1]);

    for (var i = 0; i < path.length; i++) {
        bounds = bounds.extend(path[i]);
    }
    return bounds;
}

// Polygon是否包含某点扩展 方便做拉框查询
MMap.Polygon.prototype.contains = function (e) {
    var bounds = this.getBounds();

    if (bounds != null && !bounds.contains(e)) {
        return false;
    }
    var inPoly = false;
    var path = this.getPath();
    var numPoints = path.length;
    var j = numPoints - 1;

    for (var i = 0; i < numPoints; i++) {
        var vertex1 = path[i];
        var vertex2 = path[j];

        if (vertex1.lng < e.lng && vertex2.lng >= e.lng || vertex2.lng < e.lng && vertex1.lng >= e.lng) {
            if (vertex1.lat + (e.lng - vertex1.lng) / (vertex2.lng - vertex1.lng) * (vertex2.lat - vertex1.lat) < e.lat) {
                inPoly = !inPoly;
            }
        }
        j = i;
    }

    return inPoly;
}

