﻿// create by 王君涛 2012.07
// 设备分布
var colArr = ['GUID', '车号', '所属机构','行驶状况', '正反转', '罐体转速', '行驶速度', '报警数量','轨迹','删除'];

var colModelStr = "[" +
                    "{name: 'VI_GUID', index: 'VI_GUID', align:'center',hidden:true}," +
                    "{name: 'VI_NAME', index: 'VI_NAME', align: 'center', width: 75, hight: 35,sortable:false}," +
                    "{name: 'CI_NAME', index: 'CI_NAME', align: 'center', width: 100, hight: 35,sortable:false}," +
                    "{name: 'ACTIVITY', index: 'ACTIVITY',align:'center', sortable:false,width: 75, height: 35}," +
                    "{name: 'VI_ZHENGFAN', index: 'VI_ZHENGFAN',align:'center', sortable:false,width: 55, height: 35}," +
                    "{name: 'VI_GT_ZHUANSU', index: 'VI_GT_ZHUANSU',align:'center', sortable:false,width: 65, height: 35}," +
                    "{name: 'VI_SPEED', index: 'VI_SPEED',align:'center', sortable:false,width: 75, height: 35}," +
                     "{name: 'ALARMCOUNT', index: 'ALARMCOUNT', align:'center',sortable:false,width: 75, height: 35}," +
                     "{name: 'GUIJI', index: 'GUIJI', align:'center',sortable:false,width: 75, height: 35}," +
                     "{name: 'Del', index: 'Del', align:'center',sortable:false,width: 75, height: 35}" +
                    "]";

var result = eval("(" + colModelStr + ")");

$(function () {
    loadGridData();
    registerMouseOverAndoutEvent();
    setMapHeight();
    updown();
});

function setMapHeight() {
    var parentHeight = parent.$('#tabs').tabs('getSelected').height();
    var mapHeight = parentHeight - 430;
    mapHeight = mapHeight > 300 ? mapHeight : 300;
    H.mapHeight = mapHeight;
    $("#mapWapper").height(mapHeight);
}

function loadMapData(guid){   
    if(guid==""){
        tzMap.clearMap();
        return;
    }
     // 加载点数据
    $.ajax({
        type: "GET",
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?&getVehMapData=true&timeout=" + new Date().getTime(),
        cache: false,
        data: { guid: guid },
        success: function (data) {
            var dd = eval("(" + data + ")");
            if (typeof (dd) == "undefined" || dd.length < 0) {
                return;
            }
            // 0：行驶；1：怠速；2：停留；3：离线；默认：0; 4 熄火
            // {lng:'',lat:'',iurl:'',tipTxt:''}
            var latlngArr = new Array();
            for (var i = 0; i < dd.length; i++) {
                var imgURL = "../_Css/images/off.png",
                tip = "<div>";
                tip += "车号：" + dd[i].vi_name;
                tip += "<br />SIM卡号：" + dd[i].sim;
                tip += "<br />速度：" + dd[i].speed + " 千米/小时";
                tip += "<br />方向：" + dd[i].direction;
                tip += "<br />总里程：" + dd[i].mile + " 千米";
                tip += "<br />行驶状态：" + dd[i].activiey_name;
                tip += "<br />地理位置："+dd[i].address;
                tip += "</div>";


                if (dd[i].activity == "0") {
                    imgURL = "../_Css/images/run.png";
                } else if (dd[i].activity == "1") {
                    imgURL = "../_Css/images/slowspeed.png";
                } else if (dd[i].activity == "2") {
                    imgURL = "../_Css/images/stop.png";
                } else {

                }
                latlngArr.push({ lng: dd[i].lng, lat: dd[i].lat, iurl: imgURL, tipTxt: tip });
            }
            tzMap.clearMap();
            tzMap.addPoints(latlngArr);
        }
    });
}

//加载JqGrid数据
function loadGridData() {
    $("#dataShow").jqGrid({
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfoByCompanyId=true&ci_id=" + $("#hiddenCiid").val(),
        mtype: 'GET',
        datatype: "json",
        colNames: colArr,
        colModel: result,
        rowNum: 10,
        rowList: [10, 20, 30],
        pager: '#pager',
        sortname: 'VI_GUID',
        viewrecords: true,
        multiselect: false,
        rownumbers: true,
        sortorder: "asc",
        jsonReader: {
            id: "VI_GUID", //设置主键列
            page: "page",
            total: "total",
            root: "rows",
            repeatitems: false
        },
        emptyrecords: '无数据',
        altclass: 'jqGridRowStyle',
        height: 253,
        autowidth: true,
        mtype: "GET",
        loadtext: '数据加载中，请稍后..',
        loadComplete: function (data) {
            var guid="";
           if(data.records > 0){
            for(var i =0;i<data.rows.length;i++){
                guid+=data.rows[i].VI_GUID;
                if(i != data.rows.length -1){
                    guid+=",";
                }
            }
           }
           loadMapData(guid);
        },
        loadError: function (xhr, status, error) {
            alert(error);
        },
        ondblClickRow: function (rowid) {
            //如果有数据，才弹出单车对话框
            if (rowid != -1) {
               
            }
        }
    });
}

function search() {
    if(!checkInputControlValue()){
        alert("输入内容含有非法字符！");
        return;
    }
    var vi_name = $("#txtVIName").val();
    var activite = $("#activite").val();
    $("#dataShow").jqGrid('setGridParam', {
        url: '../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfoByCompanyId=true&ci_id=' + $("#hiddenCiid").val()
        + "&vi_name=" + vi_name
        + "&activityState=" + activite
    }).trigger("reloadGrid");
}

function searchByActivite(activite) {
    $("#activite").val(activite);
    search();
}

function delVeh(guid) {
    // 加载点数据
    $.ajax({
        type: "GET",
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?&del=true&timeout=" + new Date().getTime(),
        cache: false,
        data: { guid: guid },
        success: function (data) {
            if (data == "true") {
                alert("删除成功");
            } else {
                alert("删除异常！");
            }
            search();
        }
    });    
}

 function registerMouseOverAndoutEvent(){
            $("#divRunBtn a").mouseover(function(){
                $("#divRunBtn a").css('background-image','url(../_Css/images/map_typebg.png)');
            });
        
            $("#divRunBtn a").mouseout(function(){
                $("#divRunBtn a").css('background-image','');
            });
            
            $("#divIdleBtn a").mouseover(function(){
                $("#divIdleBtn a").css('background-image','url(../_Css/images/map_typebg.png)');
            });
        
            $("#divIdleBtn a").mouseout(function(){
                $("#divIdleBtn a").css('background-image','');
            });
            
            $("#divStopBtn a").mouseover(function(){
                $("#divStopBtn a").css('background-image','url(../_Css/images/map_typebg.png)');
            });
        
            $("#divStopBtn a").mouseout(function(){
                $("#divStopBtn a").css('background-image','');
            });
            
            $("#divOffBtn a").mouseover(function(){
                $("#divOffBtn a").css('background-image','url(../_Css/images/map_typebg.png)');
            });
        
            $("#divOffBtn a").mouseout(function(){
                $("#divOffBtn a").css('background-image','');
            });
            
             $("#divAllBtn a").mouseover(function(){
             
                $("#divAllBtn a").css('background-image','url(../_Css/images/map_typebg.png)');
            });
        
            $("#divAllBtn a").mouseout(function(){
                $("#divAllBtn a").css('background-image','');
            });
        }

        var pos = 0;
        var H = { mapHeight: 304, gridHeight: 253, maxHeight: 672 };

        function updown() {
            $("#img_up").click(function () {
                if (pos == 0) {
                    $(this).hide();
                    $("#img_down").show();
                    $("#listWapper").hide();
                    $("#mapWapper").height(H.maxHeight);
                } else if (pos == -1) {
                    $("#img_down").show();
                    $("#img_up").show();
                    $("#listWapper").show();
                    $("#mapWapper").show();
                    //$("#listWapper").height(H.gridHeight);
                } else {
                    
                }

                pos += 1;
            });

            $("#img_down").click(function () {
                if (pos == 0) {
                    $(this).hide();
                    $("#img_up").show();
                    $("#mapWapper").hide();
                    $("#listWapper").show();
                    //$("#listWapper").height("672");  
                } else if (pos == 1) {
                    //$("#img_down").show();
                    $(this).hide();
                    $("#img_up").show();
                    $("#listWapper").show();
                    $("#mapWapper").show();
                    $("#mapWapper").height(H.mapHeight);
                } else {

                }

                pos -= 1;
            });
        }