﻿// create by 王君涛 2012.08.31
$(function () {
    $(".jquery-btn").button();
    $.messager.defaults = { ok: "确定", cancel: "取消" };
    var height = parent.$("#content").height();
    if ($.browser.msie) {
        $("#vehData").parent("div").css("width", "540px");
        $("#alarmData").parent("div").css("width", "550px");
        $(".mapwapper").parent().css("heigth", "450px");
        height -= 4;
    }
    $("#main").css("height", height + "px");


    btnFunction();
    drawHand();
    drawUnitName();
    registerMouseOverAndoutEvent();
    setTimeout("loadGridData()", 1000);
    setInterval(function () { setPageInterval(); }, 10000);

    setTimeout(function () {
        //$("#btnBuidingSite").click();
        //$("#btnShowLine").click();
        $("#btnsslk").click();
        loadMapData();
    }, 1000);

    $("#btnsslk").toggle(addtrafficLayer, removetrafficLayer);

    $("#tabs").tabs({
        onSelect: function (title) {
            var tabwidth = $("#tabs").width();

            if (title == "当天报警信息") {
                resetWidth("alarmData", tabwidth - 25);
            } else if (title == "车辆查询结果") {
                resetWidth("searchResultData", tabwidth - 25);
            } else {
                resetWidth("vehData", tabwidth - 25);
            }

        }
    });
});

function addtrafficLayer() {
    $("#btnsslk").addClass("ui-state-active");
    $("#btnsslk").val("隐藏实时路况");
    tzMap.addTrafficLayer();
}

function removetrafficLayer() {
    $("#btnsslk").val("显示实时路况");
    tzMap.removeTrafficLayer();
    $("#btnsslk").removeClass("ui-state-active");
}

//设置某个点为缩放中心点
function setCenterById(guid) {
    tzMap.setCenterById(guid);
}
//设置某个地图已加载区域为中心区域
function setCenterByArea(id) { // Array 数组
    tzMap.setCenterByArea(id);
}

function firstExpand() {
    if (document.getElementById("hid_FirstExpand").value == "true") {
        document.getElementById("hid_FirstExpand").value = false;
        loadGridData_Alarm();
        loadGridData_Search();
    }
}
function showUnit() {
    tzWindow.open("divNewCiid", "选择机构", "Vehicle/Tree.aspx?iframeId=tabs");
}

function searchByActivite(activite) {
    $("#activite").val(activite);   
    setPageInterval();
}

function showInfoMessage() {
    $.messager.alert("提示", "请联系我们的客服人员升级功能，热线号码：400-887-6677", 'info');
}

function setPageInterval() {  
    var activite = $("#activite").val();
    $("#vehData").jqGrid('setGridParam', {
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfoByCompanyId=true&ci_id=" + $("#hiddenCiid").val()       
        + "&activityState=" + activite
    }).trigger("reloadGrid");   
}

function GridReLoad() {
    
    $("#vehData").jqGrid('setGridParam', {
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfoByCompanyId=true&ci_id=" + $("#hiddenCiid").val()
    }).trigger("reloadGrid");
    $("#alarmData").jqGrid('setGridParam', {
        url: '../_WebClass/AlarmHandler.ashx?getAlarmToday=true&timespan=' + new Date() + "&ci_id=" + $("#hiddenCiid").val()
    }).trigger("reloadGrid");
    $("#searchResultData").jqGrid('setGridParam', {
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfo=true&ci_id=" + $("#hiddenCiid").val()
    }).trigger("reloadGrid");
    drawUnitName();
}

function drawUnitName() {
    $("#txt_ciid").html($("#hiddenUnitName").val());
    var zhch = $("#txt_ciid").css('width');
    var chch = zhch.substring(0, zhch.length - 2);
    $("#txt_ciid").css('width', (parseInt(chch) + 20) + "px");
}

function btnFunction() {
    $("#btnsslk").addClass("ui-button ui-widget ui-state-default ui-corner-all");    
    $("#btnSelectVeh").toggle(function () {
        $(".mapwapper .draw_sign").show();
        $(this).addClass("ui-state-active");  
    }, function () {
        $(".mapwapper .draw_sign").hide();
        $(this).removeClass("ui-state-active");  
    });   
}

function drawHand() {
    //hand
    $(".hand").hover(
    function () {
        $('#hand_img').css('margin-top', '-26px');
    },
    function () {
        $('#hand_img').css('margin-top', '0px');
    });
    //polygon
    $(".polygon").hover(
    function () {
        $('#polygon_img').css('margin-top', '-26px');
    },
    function () {
        $('#polygon_img').css('margin-top', '0px');
    });

    //square
    $(".square").hover(
    function () {
        $('#square_img').css('margin-top', '-26px');
    },
    function () {
        $('#square_img').css('margin-top', '0px');
    });
    //ellipse
    $(".ellipse").hover(
    function () {
        $('#circle').css('margin-top', '-26px');
    },
    function () {
        $('#circle').css('margin-top', '0px');
    });
}

// 自适应地图视野
function fitview() {
    tzMap.fitAllView();
}
//查询车辆
function searchVeh() {
    tzWindow.open("SearchVeh", "查询车辆", "_XMap/SelectVeh.aspx");
}
// 框选车
function mapVehSelect() {
    $(".mapwapper .draw_sign").show();
}

var resetWidth = function (Id, width) {
    $("#" + Id).jqGrid("setGridWidth", width, true);
};


// 车辆列表
var colArr = ['GUID', '车号', '所属机构', '行驶状况', '正反转', '罐体转速', '行驶速度', '轨迹'];

var colModelStr = "[" +
                    "{name: 'VI_GUID', index: 'VI_GUID', align:'center',hidden:true}," +
                    "{name: 'VI_NAME', index: 'VI_NAME', align: 'center', width: 75, hight: 35,sortable:false}," +
                    "{name: 'CI_NAME', index: 'CI_NAME', align: 'center', width: 100, hight: 35,sortable:false}," +
                    "{name: 'ACTIVITY', index: 'ACTIVITY',align:'center', sortable: 'asc',width: 75, height: 35}," +
                    "{name: 'VI_ZHENGFAN', index: 'VI_ZHENGFAN',align:'center', sortable: 'asc',width: 55, height: 35}," +
                    "{name: 'VI_GT_ZHUANSU', index: 'VI_GT_ZHUANSU',align:'center', sortable: 'asc',width: 65, height: 35}," +
                    "{name: 'VI_SPEED', index: 'VI_SPEED',align:'center', sortable: 'asc',width: 75, height: 35}," +
                     "{name: 'GUIJI', index: 'GUIJI', align:'center',sortable: 'asc',width: 75, height: 35}" +        
                    "]";

var result = eval("(" + colModelStr + ")");


function loadGridData() {
    var girdwidth = $("#tabs").width() - 25;
    $("#vehData").jqGrid({
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfoByCompanyId=true&ci_id=" + $("#hiddenCiid").val(),
        mtype: 'GET',
        datatype: "json",
        colNames: colArr,
        colModel: result,
        rowNum: 20,
        rowList: [10, 20, 30],
        pager: '#pager1',
        sortname: 'VI_GUID',
        viewrecords: true,
        multiselect: false,
        rownumbers: true,
        sortorder: "asc",
        jsonReader: {
            id: "VI_GUID", //设置主键列
            page: "page",
            total: "total",
            root: "rows",
            repeatitems: false
        },
        emptyrecords: '无数据',
        altclass: 'jqGridRowStyle',
        height: '100%',
        width: girdwidth,
        mtype: "GET",
        loadtext: '数据加载中，请稍后..',
        loadComplete: function (data) {
            var guid = "";
            if (data.records > 0) {
                for (var i = 0; i < data.rows.length; i++) {
                    guid += data.rows[i].VI_GUID;
                    if (i != data.rows.length - 1) {
                        guid += ",";
                    }
                }
            }
            //loadMapData(guid);
        },
        loadError: function (xhr, status, error) {
            // alert("加载车机列表出错");
        },
        onSelectRow: function (rowid) {
            if (rowid != -1) {
                setCenterById(rowid);
            }
        },
        ondblClickRow: function (rowid) {
            //如果有数据，才弹出单车对话框
            if (rowid != -1) {

            }
        }
    });
}


function loadMapData() {
    var ci_id = $("#hiddenCiid").val();
    // 加载点数据
    $.ajax({
        type: "GET",
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?&getVehMapData=true&timeout=" + new Date().getTime(),
        cache: false,
        data: { ci_id: ci_id},
        success: function (data) {
            var dd = eval("(" + data + ")");
            if (typeof (dd) == "undefined" || dd.length < 0) {
                return;
            }
            tzMap.clearMapByType(tzOverlayType.MARKER);
            // 0：行驶；1：怠速；2：停留；3：离线；默认：0; 4 熄火
            // {lng:'',lat:'',iurl:'',tipTxt:''}
            var latlngArr = new Array();
            for (var i = 0; i < dd.length; i++) {
                var img_num = Math.ceil(parseFloat(dd[i].direction_num) / 30);
                var imgURL = "../_Css/map/r_" + img_num + ".png";

                if (dd[i].activity == "1") {
                    imgURL = "../_Css/images/stop.png";
                } else if (dd[i].activity == "2") {
                    imgURL = "../_Css/images/run.png";
                } else if (dd[i].activity == "3") {
                    imgURL = "../_Css/images/off.png";
                } else if (dd[i].activity == "") {
                    imgURL = "../_Css/images/off.png"; // 默认为离线
                } else { }
                var tip = "<div >";
                tip += "<iframe src='InfoMap.aspx?lat=" + dd[i].lat + "&lng=" + dd[i].lng + "&icon=" + imgURL + "' width='275px' height='175px' style=' overflow:hidden; border:none; margin:0px 5px 0px 0px; padding:0px; '></iframe></br>";
                tip += "车号：" + dd[i].vi_name;
                // tip += " &nbsp;&nbsp;&nbsp;SIM卡号：" + dd[i].sim;
                tip += "<br />速度：" + dd[i].speed + " 千米/小时";
                tip += "&nbsp;&nbsp;&nbsp;方向：" + dd[i].direction;
                tip += "<br />总里程：" + dd[i].mile + " 千米";
                tip += "<br />行驶状态：" + dd[i].activiey_name;
                tip += "<div style=' width:272px;'>地理位置：" + dd[i].address + "</div>";
                tip += "</div>";
                var text = dd[i].vi_name + "车&nbsp;" + dd[i].speed + "km/h";


                tzMap.addMarkerLabel({ id: dd[i].id, lng: dd[i].lng, lat: dd[i].lat, icon: imgURL, content: tip, labelContent: text, becenter: false, sizeX: 8, sizeY: 16 });
            }
        }
    });
}

// 当日报警信息

var colNameArr = ['AL_ID', '车号', '车牌号', '所属机构', '报警时间', '报警类型', '报警内容'];
var colModelStr_Alarm = "[" +
                    "{name: 'AL_ID', index: 'AL_ID', hidden:true}," +
                     "{name: 'VI_NAME', index: 'VI_NAME', align: 'center',width: 75, height: 35}," +
                    "{name: 'VI_LICENSE', index: 'VI_LICENSE', align: 'center',width: 75, height: 35}," +
                    "{name: 'CI_NAME', index: 'CI_NAME', align: 'center',width: 75, height: 35}," +
                    "{name: 'AL_SYSTEMTIME', index: 'AL_SYSTEMTIME', align: 'center',width: 75, height: 35}," +
                    "{name: 'AT_NAME', index: 'AT_NAME', align: 'center',width: 75, height: 35}," +
                    "{name: 'AL_CONTENT', index: 'AL_CONTENT',hidden:true,align: 'center', width: 200, height: 35}" +
                    "]";

var colModelArr_Alarm = eval("(" + colModelStr_Alarm + ")");


//加载JqGrid数据
function loadGridData_Alarm() {

    $("#alarmData").jqGrid({
        url: '../_WebClass/AlarmHandler.ashx?getAlarmToday=true&timespan=' + new Date(),
        mtype: 'GET',
        datatype: "json",
        colNames: colNameArr,
        colModel: colModelArr_Alarm,
        rowNum: 5,
        rowList: [5, 10, 20],
        pager: '#pager2',
        sortname: 'AL_ID',
        viewrecords: true,
        multiselect: false,
        sortorder: "desc",
        jsonReader: {
            id: "AL_ID", //设置主键列
            page: "page",
            total: "total",
            root: "rows",
            repeatitems: false
        },
        emptyrecords: '无数据',
        altclass: 'jqGridRowStyle',
        height: '100%',
        width: '1136',
        rownumbers: true,
        rownumWidth: 50,
        mtype: "GET",
        loadtext: '数据加载中，请稍后..',
        loadComplete: function (data) {
            
        },
        loadError: function (xhr, status, error) {
           // alert("加载报警列表出错");
        }
    });
}


// 查询结果
var colArr_search = ['GUID', '车号', '所属机构', '行驶状况', '正反转', '罐体转速', '行驶速度', '轨迹'];

var colModelStr_search = "[" +
                    "{name: 'VI_GUID', index: 'VI_GUID', align:'center',hidden:true}," +
                    "{name: 'VI_NAME', index: 'VI_NAME', align: 'center', width: 75, hight: 35,sortable:false}," +
                    "{name: 'CI_NAME', index: 'CI_NAME', align: 'center', width: 100, hight: 35,sortable:false}," +
                    "{name: 'ACTIVITY', index: 'ACTIVITY',align:'center', sortable: 'asc',width: 75, height: 35}," +
                    "{name: 'VI_ZHENGFAN', index: 'VI_ZHENGFAN',align:'center', sortable: 'asc',width: 55, height: 35}," +
                    "{name: 'VI_GT_ZHUANSU', index: 'VI_GT_ZHUANSU',align:'center', sortable: 'asc',width: 65, height: 35}," +
                    "{name: 'VI_SPEED', index: 'VI_SPEED',align:'center', sortable: 'asc',width: 75, height: 35}," +
                     "{name: 'GUIJI', index: 'GUIJI', align:'center',sortable: 'asc',width: 75, height: 35}" +
                    "]";

var result_search = eval("(" + colModelStr + ")");

function loadGridData_Search() {
    $("#searchResultData").jqGrid({
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfo=true&ci_id=" + $("#hiddenCiid").val(),
        mtype: 'GET',
        datatype: "json",
        colNames: colArr_search,
        colModel: result_search,
        rowNum: 5,
        rowList: [5, 10, 20],
        pager: '#pager3',
        sortname: 'VI_GUID',
        viewrecords: true,
        multiselect: false,
        rownumbers: true,
        sortorder: "asc",
        jsonReader: {
            id: "VI_GUID", //设置主键列
            page: "page",
            total: "total",
            root: "rows",
            repeatitems: false
        },
        emptyrecords: '无数据',
        altclass: 'jqGridRowStyle',
        height: '100%',
        width:'1136',
        mtype: "GET",
        loadtext: '数据加载中，请稍后..',
        loadComplete: function (data) {
            
        },
        loadError: function (xhr, status, error) {
           // alert("加载查询结构出错");
        },
        onSelectRow: function (rowid) {
            if (rowid != -1) {
                setCenterById(rowid);
            }
        },
        ondblClickRow: function (rowid) {
            //如果有数据，才弹出单车对话框
            if (rowid != -1) {

            }
        }
    });
}

function loadSearchListBySql() {
       var _url = "../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfo=true&ci_id=" + $("#hiddenCiid").val();
       //clear old data
        $("#searchResultData").clearGridData();
        //reload
        $("#searchResultData").jqGrid('setGridParam', { url: _url }).trigger("reloadGrid");
        $('#tabs').tabs('select', '车辆查询结果');
        $("#main").layout('expand', 'south');
}
function getTrack(guid) {
    tzWindow.open("SingleVehInfo", "单车信息", "VehilceMonitor/VehHistoricalTracking.aspx?vi_id=" + guid);
   // tzWindow.open("SingleVehInfo", "单车信息", "VehilceMonitor/vehicleTrack.aspx?guid=" + guid);
}
function registerMouseOverAndoutEvent() {
    $("#divRunBtn a").mouseover(function () {
        $("#divRunBtn a").css('background-image', 'url(../_Css/images/map_typebg.png)');
    });

    $("#divRunBtn a").mouseout(function () {
        $("#divRunBtn a").css('background-image', '');
    });

    $("#divIdleBtn a").mouseover(function () {
        $("#divIdleBtn a").css('background-image', 'url(../_Css/images/map_typebg.png)');
    });

    $("#divIdleBtn a").mouseout(function () {
        $("#divIdleBtn a").css('background-image', '');
    });

    $("#divStopBtn a").mouseover(function () {
        $("#divStopBtn a").css('background-image', 'url(../_Css/images/map_typebg.png)');
    });

    $("#divStopBtn a").mouseout(function () {
        $("#divStopBtn a").css('background-image', '');
    });

    $("#divOffBtn a").mouseover(function () {
        $("#divOffBtn a").css('background-image', 'url(../_Css/images/map_typebg.png)');
    });

    $("#divOffBtn a").mouseout(function () {
        $("#divOffBtn a").css('background-image', '');
    });

    $("#divAllBtn a").mouseover(function () {

        $("#divAllBtn a").css('background-image', 'url(../_Css/images/map_typebg.png)');
    });

    $("#divAllBtn a").mouseout(function () {
        $("#divAllBtn a").css('background-image', '');
    });
}
