﻿
$(function () {
    loadGridData();
    loadGridData_Alarm();
});


// 车辆列表
var colArr = ['GUID', '车号', '所属机构', '行驶状况', '正反转', '罐体转速', '行驶速度', '行驶方向', '报警数量'];

var colModelStr = "[" +
                    "{name: 'VI_GUID', index: 'VI_GUID', align:'center',hidden:true}," +
                    "{name: 'VI_NAME', index: 'VI_NAME', align: 'center', width: 75, hight: 35,sortable:false}," +
                    "{name: 'CI_NAME', index: 'CI_NAME', align: 'center', width: 100, hight: 35,sortable:false}," +
                    "{name: 'ACTIVITY', index: 'ACTIVITY',align:'center', sortable: 'asc',width: 75, height: 35}," +
                    "{name: 'VI_ZHENGFAN', index: 'VI_ZHENGFAN',align:'center', sortable: 'asc',width: 55, height: 35}," +
                    "{name: 'VI_GT_ZHUANSU', index: 'VI_GT_ZHUANSU',align:'center', sortable: 'asc',width: 65, height: 35}," +
                    "{name: 'VI_SPEED', index: 'VI_SPEED',align:'center', sortable: 'asc',width: 75, height: 35}," +
                    "{name: 'VI_HANGXIANG', index: 'VI_HANGXIANG',align:'center', sortable: 'asc',width: 75, height: 35}," +
                     "{name: 'ALARMCOUNT', index: 'ALARMCOUNT', align:'center',sortable: 'asc',width: 75, height: 35}," +
                    "]";

var result = eval("(" + colModelStr + ")");

function loadGridData() {
    $("#vehData").jqGrid({
        url: "../VehilceMonitor/Handler/VehDistributionHandler.ashx?getVehInfo=true&ci_id=" + $("#hiddenCiid").val(),
        mtype: 'GET',
        datatype: "json",
        colNames: colArr,
        colModel: result,
        rowNum: 5,
        rowList: [5, 10, 20],
        pager: '#pager1',
        sortname: 'VI_GUID',
        viewrecords: true,
        multiselect: false,
        rownumbers: true,
        sortorder: "asc",
        jsonReader: {
            id: "VI_GUID", //设置主键列
            page: "page",
            total: "total",
            root: "rows",
            repeatitems: false
        },
        emptyrecords: '无数据',
        altclass: 'jqGridRowStyle',
        height: '100%',
        autowidth: false,
        mtype: "GET",
        loadtext: '数据加载中，请稍后..',
        loadComplete: function (data) {
            var guid = "";
            if (data.records > 0) {
                for (var i = 0; i < data.rows.length; i++) {
                    guid += data.rows[i].VI_GUID;
                    if (i != data.rows.length - 1) {
                        guid += ",";
                    }
                }
            }
           // loadMapData(guid);
        },
        loadError: function (xhr, status, error) {
            alert(error);
        },
        ondblClickRow: function (rowid) {
            //如果有数据，才弹出单车对话框
            if (rowid != -1) {

            }
        }
    });
}


// 当日报警信息

var colNameArr = ['AL_ID', '车号', '车牌号', '所属机构', '报警时间', '报警类型', '报警内容'];
var colModelStr_Alarm = "[" +
                    "{name: 'AL_ID', index: 'AL_ID', hidden:true}," +
                     "{name: 'VI_NAME', index: 'VI_NAME', align: 'center',width: 75, height: 35}," +
                    "{name: 'VI_LICENSE', index: 'VI_LICENSE', align: 'center',width: 75, height: 35}," +
                    "{name: 'CI_NAME', index: 'CI_NAME', align: 'center',width: 75, height: 35}," +
                    "{name: 'AL_SYSTEMTIME', index: 'AL_SYSTEMTIME', align: 'center',width: 75, height: 35}," +
                    "{name: 'AT_NAME', index: 'AT_NAME', align: 'center',width: 75, height: 35}," +
                    "{name: 'AL_CONTENT', index: 'AL_CONTENT',align: 'center', width: 200, height: 35}" +
                    "]";

var colModelArr_Alarm = eval("(" + colModelStr_Alarm + ")");


//加载JqGrid数据
function loadGridData_Alarm() {

    $("#alarmData").jqGrid({
        url: '../_WebClass/AlarmHandler.ashx?getAlarmToday=true&timespan=' + new Date(),
        mtype: 'GET',
        datatype: "json",
        colNames: colNameArr,
        colModel: colModelArr_Alarm,
        rowNum: 5,
        rowList: [5, 10, 20],
        pager: '#pager2',
        sortname: 'AL_ID',
        viewrecords: true,
        multiselect: false,
        sortorder: "desc",
        jsonReader: {
            id: "AL_ID", //设置主键列
            page: "page",
            total: "total",
            root: "rows",
            repeatitems: false
        },
        emptyrecords: '无数据',
        altclass: 'jqGridRowStyle',
        height: '100%',
        autowidth: true,
        rownumbers: true,
        rownumWidth: 50,
        mtype: "GET",
        loadtext: '数据加载中，请稍后..',
        loadComplete: function (data) {
            //alert(data);
        },
        loadError: function (xhr, status, error) {
            alert(error);
        }
    });
}
