﻿CREATE TABLE [dbo].[yi25_Admin] (
	[AdminId] [int] IDENTITY (1, 1) NOT NULL ,
	[AminName] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminPassword] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminTrueName] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminSex] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminPhone] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminTel] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminEmail] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminQq] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminMsn] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminTaobao] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminIntro] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminIntropower] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminHandpower] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AdminColumnpower] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[LoginNum] [int] NULL ,
	[EndTime] [datetime] NULL ,
	[EndIp] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_BaseInfo] (
	[BaseInfoId] [int] IDENTITY (1, 1) NOT NULL ,
	[BaseName] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[BaseLogo] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[Author] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[Copyright] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[StatisticsCode] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[GgCode] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[strlanguage] [varchar] (500) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Behavior] (
	[BehaviorId] [int] IDENTITY (1, 1) NOT NULL ,
	[CharIp] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[Area] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[FromURL] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[FirstEnterPage] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[VisitPageDetail] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[VisitPageDetailTime] [nvarchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[CurrentURL] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[OpSystem] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[IeType] [varchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
	[SystemRation] [varchar] (15) COLLATE Chinese_PRC_CI_AS NULL ,
	[Website] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[VisitPagePosition] [varchar] (1000) COLLATE Chinese_PRC_CI_AS NULL ,
	[VisitCount] [int] NULL ,
	[Islogin] [int] NULL ,
	[AddTime] [datetime] NULL ,
	[BehaviorCookie] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[KeyWordUrl] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[KeyWord] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[CurrendtTime] [datetime] NULL ,
	[PreKeyWord] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[KeyWordlocalurl] [text] COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_DefaultFlash] (
	[DefaultFlashId] [int] IDENTITY (1, 1) NOT NULL ,
	[DefaultFlashUrl] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[DefaultFlashLink] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_DownLoad] (
	[DownLoadId] [int] IDENTITY (1, 1) NOT NULL ,
	[ItemId] [int] NULL ,
	[FieldId] [int] NULL ,
	[InfoTitle] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Info] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[Type] [int] NULL ,
	[BigTypeId] [int] NULL ,
	[SmallTypeId] [int] NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[ClickNum] [int] NULL ,
	[UploadInfo] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[UploadInfoName] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[FileSize] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemBigId] [int] NULL ,
	[StaticPage] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddAdmin] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Recomm] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Field] (
	[FieldId] [int] IDENTITY (1, 1) NOT NULL ,
	[FieldName] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[FieldType] [int] NULL ,
	[Type] [int] NULL ,
	[AddTime] [datetime] NULL ,
	[Gradation] [int] NULL ,
	[FieldMarker] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Postion] [int] NULL ,
	[FieldText] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[IsNullColumn] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_FriendLink] (
	[FriendLinkId] [int] IDENTITY (1, 1) NOT NULL ,
	[LinkType] [int] NULL ,
	[LinkAddress] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[LinkInfo] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Explain] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[Gadation] [int] NULL ,
	[AddTime] [datetime] NULL ,
	[LinkName] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Images] (
	[ImagesId] [int] IDENTITY (1, 1) NOT NULL ,
	[ItemId] [int] NULL ,
	[FieldId] [int] NULL ,
	[InfoTitle] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Info] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[Type] [int] NULL ,
	[BigTypeId] [int] NULL ,
	[SmallTypeId] [int] NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[ClickNum] [int] NULL ,
	[UploadInfo] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[UploadInfoName] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemBigId] [int] NULL ,
	[StaticPage] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddAdmin] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Recomm] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Introduce] (
	[IntroduceId] [int] IDENTITY (1, 1) NOT NULL ,
	[FieldId] [int] NULL ,
	[ItemId] [int] NULL ,
	[Info] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[BigTypeId] [int] NULL ,
	[SmallTypeId] [int] NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[ClickNum] [int] NULL ,
	[UploadInfo] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[InfoTitle] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[UploadInfoName] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemBigId] [int] NULL ,
	[StaticPage] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddAdmin] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Recomm] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Item] (
	[ItemId] [int] IDENTITY (1, 1) NOT NULL ,
	[ItemName] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemType] [int] NULL ,
	[ItemOrder] [int] NULL ,
	[Display] [int] NULL ,
	[OpenModel] [int] NULL ,
	[ItemAttribute] [int] NULL ,
	[ItemUrl] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemFolder] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[StaticPage] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[Attribute] [int] NULL ,
	[FlashType] [int] NULL ,
	[FlashUrl] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[FlashLink] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemSmallType] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL ,
	[ItemListStyle] [int] NULL ,
	[ItemListPageNum] [int] NULL ,
	[OriginalReplaceChar] [varchar] (500) COLLATE Chinese_PRC_CI_AS NULL ,
	[ReplaceChar] [varchar] (500) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Job] (
	[JobId] [int] IDENTITY (1, 1) NOT NULL ,
	[ItemId] [int] NULL ,
	[FieldId] [int] NULL ,
	[InfoTitle] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Info] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[Type] [int] NULL ,
	[BigTypeId] [int] NULL ,
	[SmallTypeId] [int] NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[ClickNum] [int] NULL ,
	[UploadInfo] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[UploadInfoName] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemBigId] [int] NULL ,
	[Education] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Experience] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyNature] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[JobDescribe] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[JobAddress] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[StaticPage] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddAdmin] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Recomm] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Message] (
	[MessageId] [int] IDENTITY (1, 1) NOT NULL ,
	[ItemId] [int] NULL ,
	[FieldId] [int] NULL ,
	[InfoTitle] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Info] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[Type] [int] NULL ,
	[BigTypeId] [int] NULL ,
	[SmallTypeId] [int] NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[ClickNum] [int] NULL ,
	[UploadInfo] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[UploadInfoName] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemBigId] [int] NULL ,
	[CompanyName] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[ReInfo] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[Peoper] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[StaticPage] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[MessageFind] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[UserInfoId] [int] NULL ,
	[AddAdmin] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Recomm] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_News] (
	[NewsId] [int] IDENTITY (1, 1) NOT NULL ,
	[FieldId] [int] NULL ,
	[ItemId] [int] NULL ,
	[InfoTitle] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Info] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[Type] [int] NULL ,
	[BigTypeId] [int] NULL ,
	[SmallTypeId] [int] NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[ClickNum] [int] NULL ,
	[UploadInfo] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[Author] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[UploadInfoName] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemBigId] [int] NULL ,
	[StaticPage] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddAdmin] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Recomm] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_OrderList] (
	[OrderListId] [int] IDENTITY (1, 1) NOT NULL ,
	[UserID] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[ShopID] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[Price] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[Address] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[postalcode] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[RequestName] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Tel] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Phone] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Message] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[carry] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[ShopNum] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_PageInfo] (
	[PageInfoId] [int] IDENTITY (1, 1) NOT NULL ,
	[CompanyName] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyAddress] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyPhone] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyTel] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyFax] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[Companyqq] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyPost] [varchar] (20) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyEmail] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyHttp] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyNews] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[CompSynopsis] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[CompanyCase] [varchar] (500) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[Copyright] [varchar] (200) COLLATE Chinese_PRC_CI_AS NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Product] (
	[ProductId] [int] IDENTITY (1, 1) NOT NULL ,
	[ItemId] [int] NULL ,
	[FieldId] [int] NULL ,
	[InfoTitle] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Info] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[BigTypeId] [int] NULL ,
	[SmallTypeId] [int] NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[ClickNum] [int] NULL ,
	[UploadInfo] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[spec] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[datum] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[UploadInfoName] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemBigId] [int] NULL ,
	[ProductMoney] [float] NULL ,
	[StaticPage] [varchar] (300) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddAdmin] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[Recomm] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_Resume] (
	[ResumeId] [int] IDENTITY (1, 1) NOT NULL ,
	[ItemId] [int] NULL ,
	[FieldId] [int] NULL ,
	[InfoTitle] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Info] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[Type] [int] NULL ,
	[BigTypeId] [int] NULL ,
	[SmallTypeId] [int] NULL ,
	[SeoKeyword] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[SeoDescription] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[ClickNum] [int] NULL ,
	[UploadInfo] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[UploadInfoName] [varchar] (2000) COLLATE Chinese_PRC_CI_AS NULL ,
	[ItemBigId] [int] NULL ,
	[UserName] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Sex] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Birth] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Stature] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[BodStatus] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Nation] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Genro] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Birthplace] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[ContactPhone] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[JobLive] [text] COLLATE Chinese_PRC_CI_AS NULL ,
	[StaticPage] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[UserInfoId] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL ,
	[UrlFormat] [int] NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_ShopCart] (
	[ShopCartId] [int] IDENTITY (1, 1) NOT NULL ,
	[UserID] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[ShopID] [int] NULL ,
	[TotalNum] [int] NULL ,
	[AddTime] [datetime] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[yi25_UserInfo] (
	[UserInfoId] [int] IDENTITY (1, 1) NOT NULL ,
	[UserName] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[UserPassword] [varchar] (50) COLLATE Chinese_PRC_CI_AS NULL ,
	[AddTime] [datetime] NULL ,
	[realityname] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[sex] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[Email] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[phone] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[address] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[qq] [varchar] (100) COLLATE Chinese_PRC_CI_AS NULL ,
	[EndTime] [datetime] NULL ,
	[LoginNum] [int] NULL ,
	[Recomm] [int] NULL ,
	[Language] [varchar] (10) COLLATE Chinese_PRC_CI_AS NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[yi25_Admin] WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		[AdminId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Behavior] WITH NOCHECK ADD 
	CONSTRAINT [PK__yi25_Behavior__3DE82FB7] PRIMARY KEY  CLUSTERED 
	(
		[BehaviorId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_OrderList] WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		[OrderListId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_ShopCart] WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		[ShopCartId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_UserInfo] WITH NOCHECK ADD 
	 PRIMARY KEY  CLUSTERED 
	(
		[UserInfoId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Admin] WITH NOCHECK ADD 
	CONSTRAINT [DF__Admin__AddTime__7A3223E8] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__Admin__LoginNum__7B264821] DEFAULT (0) FOR [LoginNum],
	CONSTRAINT [DF__Admin__EndTime__7C1A6C5A] DEFAULT (getdate()) FOR [EndTime]
GO

ALTER TABLE [dbo].[yi25_BaseInfo] WITH NOCHECK ADD 
	CONSTRAINT [DF__BaseInfo__AddTim__05D8E0BE] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Base__strla__336AA144] DEFAULT ('zh-CN') FOR [strlanguage],
	CONSTRAINT [PK_BASEINFO] PRIMARY KEY  NONCLUSTERED 
	(
		[BaseInfoId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Behavior] WITH NOCHECK ADD 
	CONSTRAINT [DF_yi25_Behavior_VisitPageDetailTime] DEFAULT (0) FOR [VisitPageDetailTime],
	CONSTRAINT [DF__yi25_Beha__Visit__3EDC53F0] DEFAULT (1) FOR [VisitCount],
	CONSTRAINT [DF__yi25_Beha__Islog__3FD07829] DEFAULT (0) FOR [Islogin],
	CONSTRAINT [DF__yi25_Beha__AddTi__40C49C62] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Beha__Curre__4865BE2A] DEFAULT (getdate()) FOR [CurrendtTime]
GO

ALTER TABLE [dbo].[yi25_DefaultFlash] WITH NOCHECK ADD 
	CONSTRAINT [DF__DefaultFl__AddTi__08B54D69] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [PK_DEFAULTFLASH] PRIMARY KEY  NONCLUSTERED 
	(
		[DefaultFlashId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_DownLoad] WITH NOCHECK ADD 
	CONSTRAINT [DF_DownLoad_AddTime] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Down__UrlFo__68D28DBC] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [PK_DOWNLOAD] PRIMARY KEY  NONCLUSTERED 
	(
		[DownLoadId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Field] WITH NOCHECK ADD 
	CONSTRAINT [DF_Field_AddTime] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__Field__Postion__3864608B] DEFAULT (1) FOR [Postion],
	CONSTRAINT [DF__Field__IsNullCol__74794A92] DEFAULT (0) FOR [IsNullColumn],
	CONSTRAINT [PK_FIELD] PRIMARY KEY  NONCLUSTERED 
	(
		[FieldId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_FriendLink] WITH NOCHECK ADD 
	CONSTRAINT [DF__FriendLin__Gadat__3D2915A8] DEFAULT (1) FOR [Gadation],
	CONSTRAINT [DF__FriendLin__AddTi__3E1D39E1] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [PK_FRIENDLINK] PRIMARY KEY  NONCLUSTERED 
	(
		[FriendLinkId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Images] WITH NOCHECK ADD 
	CONSTRAINT [DF_Images_AddTime] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Imag__UrlFo__69C6B1F5] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [PK_IMAGES] PRIMARY KEY  NONCLUSTERED 
	(
		[ImagesId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Introduce] WITH NOCHECK ADD 
	CONSTRAINT [DF_Introduce_AddTime] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Intr__UrlFo__6ABAD62E] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [PK_INTRODUCE] PRIMARY KEY  NONCLUSTERED 
	(
		[IntroduceId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Item] WITH NOCHECK ADD 
	CONSTRAINT [DF_Item_AddTime] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Item__UrlFo__7073AF84] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [DF__yi25_Item__ItemL__753864A1] DEFAULT (0) FOR [ItemListStyle],
	CONSTRAINT [DF__yi25_Item__ItemL__762C88DA] DEFAULT (0) FOR [ItemListPageNum],
	CONSTRAINT [PK_ITEM] PRIMARY KEY  NONCLUSTERED 
	(
		[ItemId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Job] WITH NOCHECK ADD 
	CONSTRAINT [DF__Job__AddTime__503BEA1C] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Job__UrlFor__6BAEFA67] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [PK_JOB] PRIMARY KEY  NONCLUSTERED 
	(
		[JobId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Message] WITH NOCHECK ADD 
	CONSTRAINT [DF_Message_AddTime] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Mess__UrlFo__6CA31EA0] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [PK_MESSAGE] PRIMARY KEY  NONCLUSTERED 
	(
		[MessageId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_News] WITH NOCHECK ADD 
	CONSTRAINT [DF_News_AddTime] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_News__UrlFo__6D9742D9] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [PK_NEWS] PRIMARY KEY  NONCLUSTERED 
	(
		[NewsId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_OrderList] WITH NOCHECK ADD 
	CONSTRAINT [DF__OrderList__AddTi__73852659] DEFAULT (getdate()) FOR [AddTime]
GO

ALTER TABLE [dbo].[yi25_PageInfo] WITH NOCHECK ADD 
	CONSTRAINT [DF__PageInfo__AddTim__339FAB6E] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [PK_PAGEINFO] PRIMARY KEY  NONCLUSTERED 
	(
		[PageInfoId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Product] WITH NOCHECK ADD 
	CONSTRAINT [DF_Product_AddTime] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__Product__Product__70A8B9AE] DEFAULT (0.0) FOR [ProductMoney],
	CONSTRAINT [DF__yi25_Prod__UrlFo__6E8B6712] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [PK_PRODUCT] PRIMARY KEY  NONCLUSTERED 
	(
		[ProductId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_Resume] WITH NOCHECK ADD 
	CONSTRAINT [DF__Resume__AddTime__531856C7] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__yi25_Resu__UrlFo__6F7F8B4B] DEFAULT (2) FOR [UrlFormat],
	CONSTRAINT [PK_RESUME] PRIMARY KEY  NONCLUSTERED 
	(
		[ResumeId]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[yi25_ShopCart] WITH NOCHECK ADD 
	CONSTRAINT [DF__ShopCart__AddTim__690797E6] DEFAULT (getdate()) FOR [AddTime]
GO

ALTER TABLE [dbo].[yi25_UserInfo] WITH NOCHECK ADD 
	CONSTRAINT [DF__UserInfo__AddTim__65370702] DEFAULT (getdate()) FOR [AddTime],
	CONSTRAINT [DF__UserInfo__EndTim__756D6ECB] DEFAULT (getdate()) FOR [EndTime],
	CONSTRAINT [DF__UserInfo__LoginN__76619304] DEFAULT (0) FOR [LoginNum]
GO

 CREATE  INDEX [Relationship_5_FK] ON [dbo].[yi25_DownLoad]([FieldId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_10_FK] ON [dbo].[yi25_DownLoad]([ItemId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_3_FK] ON [dbo].[yi25_Images]([FieldId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_11_FK] ON [dbo].[yi25_Images]([ItemId]) ON [PRIMARY]
GO

 CREATE  INDEX [内容_FK] ON [dbo].[yi25_Introduce]([FieldId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_7_FK] ON [dbo].[yi25_Introduce]([ItemId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_4_FK] ON [dbo].[yi25_Message]([FieldId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_12_FK] ON [dbo].[yi25_Message]([ItemId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_2_FK] ON [dbo].[yi25_News]([FieldId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_9_FK] ON [dbo].[yi25_News]([ItemId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_6_FK] ON [dbo].[yi25_Product]([FieldId]) ON [PRIMARY]
GO

 CREATE  INDEX [Relationship_8_FK] ON [dbo].[yi25_Product]([ItemId]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[yi25_DownLoad] ADD 
	CONSTRAINT [FK_DOWNLOAD_RELATIONS_FIELD] FOREIGN KEY 
	(
		[FieldId]
	) REFERENCES [dbo].[yi25_Field] (
		[FieldId]
	)
GO

ALTER TABLE [dbo].[yi25_Images] ADD 
	CONSTRAINT [FK_IMAGES_RELATIONS_FIELD] FOREIGN KEY 
	(
		[FieldId]
	) REFERENCES [dbo].[yi25_Field] (
		[FieldId]
	)
GO

ALTER TABLE [dbo].[yi25_Introduce] ADD 
	CONSTRAINT [FK_INTRODUC_内容_FIELD] FOREIGN KEY 
	(
		[FieldId]
	) REFERENCES [dbo].[yi25_Field] (
		[FieldId]
	)
GO

ALTER TABLE [dbo].[yi25_Message] ADD 
	CONSTRAINT [FK_MESSAGE_RELATIONS_FIELD] FOREIGN KEY 
	(
		[FieldId]
	) REFERENCES [dbo].[yi25_Field] (
		[FieldId]
	)
GO

ALTER TABLE [dbo].[yi25_News] ADD 
	CONSTRAINT [FK_NEWS_RELATIONS_FIELD] FOREIGN KEY 
	(
		[FieldId]
	) REFERENCES [dbo].[yi25_Field] (
		[FieldId]
	)
GO

ALTER TABLE [dbo].[yi25_Product] ADD 
	CONSTRAINT [FK_PRODUCT_RELATIONS_FIELD] FOREIGN KEY 
	(
		[FieldId]
	) REFERENCES [dbo].[yi25_Field] (
		[FieldId]
	)
GO
