﻿SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

create proc Pr_BehaviorCount
@Remark varchar(300)  
as  
declare @sql nvarchar(4000)  
set @sql='select count(BehaviorId) as Num  from yi25_Behavior where '+@Remark+''  
exec sp_Executesql @sql  

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_BehaviorList
@Remark varchar(300),
@pageindex int,
@pagesize int
as
declare @sql nvarchar(4000)
if @pagesize=0
begin
set @sql='select count(BehaviorId) as CountNum  from yi25_Behavior where '+@Remark+''
end 
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *
from yi25_Behavior 
where '+@Remark+' and BehaviorId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' BehaviorId
from yi25_Behavior where '+@Remark+'
) 
'
end
exec sp_Executesql @sql

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

create proc Pr_BehaviorListall
@Remark varchar(300)
as
declare @sql nvarchar(4000)
set @sql='select *  from yi25_Behavior where '+@Remark+''
exec sp_Executesql @sql


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetAllInfo  
@Type int,  
@Language varchar(300),  
@pageindex int,  
@pagesize int  
as  
declare @sql nvarchar(4000)  
begin  
  
if @Type=2  
begin   
if @pagesize=0  
begin  
set @sql='select count(NewsId) as CountNum  from yi25_News where '+@Language+''  
end   
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' NewsId as Id,InfoTitle,SeoDescription,StaticPage,2 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat  
from yi25_News   
where '+@Language+' and NewsId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' NewsId  
from yi25_News where '+@Language+'  
order by NewsId desc)   
order by NewsId desc'  
end  
end  
  
if @Type=3  
begin   
if @pagesize=0  
begin  
set @sql='select count(ImagesId) as CountNum  from yi25_Images where '+@Language+''  
end   
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' ImagesId as Id,InfoTitle,SeoDescription,StaticPage,3 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat  
from yi25_Images   
where '+@Language+' and ImagesId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ImagesId  
from yi25_Images where '+@Language+'  
order by ImagesId desc)   
order by ImagesId desc'  
end  
end  
  
  
if @Type=4  
begin   
if @pagesize=0  
begin  
set @sql='select count(ProductId) as CountNum  from yi25_Product where '+@Language+''  
end   
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' ProductId as Id,InfoTitle,SeoDescription,StaticPage,4 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat  
from yi25_Product   
where '+@Language+' and ProductId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ProductId  
from yi25_Product where '+@Language+'  
order by ProductId desc)   
order by ProductId desc'  
end  
end  
  
if @Type=5  
begin   
if @pagesize=0  
begin  
set @sql='select count(DownLoadId) as CountNum  from yi25_DownLoad where '+@Language+''  
end   
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' DownLoadId as Id,InfoTitle,SeoDescription,StaticPage,5 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat  
from yi25_DownLoad   
where '+@Language+' and DownLoadId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' DownLoadId  
from yi25_DownLoad where '+@Language+'  
order by DownLoadId desc)   
order by DownLoadId desc'  
end  
end  
  
if @Type=7  
begin   
if @pagesize=0  
begin  
set @sql='select count(JobId) as CountNum  from yi25_Job where '+@Language+''  
end   
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' JobId as Id,InfoTitle,SeoDescription,StaticPage,7 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat  
from yi25_Job   
where '+@Language+' and JobId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' JobId  
from yi25_Job where '+@Language+'  
order by JobId desc)   
order by JobId desc'  
end  
end  
  
if @Type=0  
begin   
if @pagesize=0  
begin  
set @sql='select count(Id) as CountNum from (select NewsId as Id  from yi25_News where '+@Language+'    
union all     
select ImagesId as Id from yi25_Images where '+@Language+'     
union all     
select ProductId as Id from yi25_Product where '+@Language+'   
union all     
select DownLoadId as Id from yi25_DownLoad where '+@Language+'   
union all     
select JobId as Id from yi25_Job where '+@Language+') as d '  
end   
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' Id,InfoTitle,SeoDescription,StaticPage,type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat 
from (select NewsId as Id,InfoTitle,SeoDescription,StaticPage,2 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat  from yi25_News where '+@Language+'   
union all     
select ImagesId as Id,InfoTitle,SeoDescription,StaticPage,3 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat from yi25_Images where '+@Language+'    
union all     
select ProductId as Id,InfoTitle,SeoDescription,StaticPage,4 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat from yi25_Product where '+@Language+'   
union all     
select DownLoadId as Id,InfoTitle,SeoDescription,StaticPage,5 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat from yi25_DownLoad where '+@Language+'   
union all     
select JobId as Id,InfoTitle,SeoDescription,StaticPage,7 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId ,UrlFormat from yi25_Job where '+@Language+') as a  
where AddTime not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' AddTime  
from (select NewsId as Id,InfoTitle,SeoDescription,StaticPage,2 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat  from yi25_News where '+@Language+'   
union all     
select ImagesId as Id,InfoTitle,SeoDescription,StaticPage,3 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat from yi25_Images where '+@Language+'     
union all     
select ProductId as Id,InfoTitle,SeoDescription,StaticPage,4 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat from yi25_Product where '+@Language+'   
union all     
select DownLoadId as Id,InfoTitle,SeoDescription,StaticPage,5 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat from yi25_DownLoad where '+@Language+'   
union all     
select JobId as Id,InfoTitle,SeoDescription,StaticPage,7 as type,AddTime,ItemBigId,BigTypeId,SmallTypeId,UrlFormat from yi25_Job where '+@Language+') as d  
)   
'  
end  
end  
  
exec sp_Executesql @sql  
end  


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetBaseInfo
@Language varchar(10)
as
select * from yi25_BaseInfo where Language=@Language

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetDefaultFlash  
@Language varchar(10)  
as  
select * from yi25_DefaultFlash where Language=@Language  

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure Pr_GetFieldById
@FieldId int,
@Language varchar(10)
as
select * from yi25_Field where FieldId=@FieldId and Language=@Language

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure Pr_GetFieldByType  
@Type int,  
@Language varchar(10)  
as  
select *,(select count(FieldId) from yi25_Field where Type=@Type) as countId from yi25_Field where Type=@Type   
order by Gradation asc,AddTime desc  

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetFriendLink
@Language varchar(10)
as
select * from yi25_FriendLink where Language=@Language

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetFriendLinkById
@FriendLinkId int,
@Language varchar(10)
as
select * from yi25_FriendLink where FriendLinkId=@FriendLinkId and Language=@Language

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetFriendLinkByLinkType
@LinkType int,
@Language varchar(10)
as
select * from yi25_FriendLink where LinkType=@LinkType and Language=@Language

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetItemByAttribute
@Attribute int,
@Language varchar(10)
as
select * from yi25_Item where Attribute=@Attribute and Language=@Language order by ItemOrder asc

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetItemById
@ItemId int,
@Language varchar(10)
as
select * from yi25_Item where ItemId=@ItemId and Language=@Language

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetItemByRemark
@Remark varchar(100),
@Language varchar(10)
as
declare @sql nvarchar(200)
set @sql='select * from yi25_Item where ('+@Remark+') and Language='''+@Language+''' order by ItemOrder asc' 
exec sp_Executesql @sql

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetItemByType
@ItemType int,
@Language varchar(10)
as
select * from yi25_Item where ItemType=@ItemType and Language=@Language

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetMod
@Type int,
@ReMark varchar(200),
@pageindex int,
@pagesize int,
@Language varchar(10)
as
declare @sql nvarchar(4000)
begin
if @Type=1
begin
if @PageSize=0
begin
set @sql='select * from yi25_Introduce where '+@ReMark+' and Language='''+@Language+''' order by IntroduceId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(IntroduceId) from yi25_Introduce 
where '+@ReMark+' and Language='''+@Language+''') as countpage 
from yi25_Introduce where '+@ReMark+' and Language='''+@Language+'''
and IntroduceId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' IntroduceId
from yi25_Introduce
where '+@ReMark+' and Language='''+@Language+'''
order by IntroduceId desc) 
order by IntroduceId desc'
end
end
if @Type=2
begin
if @PageSize=0
begin
set @sql='select * from yi25_News where '+@ReMark+' and Language='''+@Language+''' order by NewsId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(NewsId) from yi25_News 
where '+@ReMark+' and Language='''+@Language+''') as countpage 
from yi25_News where '+@ReMark+' and Language='''+@Language+'''
and NewsId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' NewsId
from yi25_News
where '+@ReMark+' and Language='''+@Language+'''
order by NewsId desc) 
order by NewsId desc'
end
end
if @Type=3
begin
if @PageSize=0
begin
set @sql='select * from yi25_Images where '+@ReMark+' and Language='''+@Language+''' order by ImagesId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(ImagesId) from yi25_Images 
where '+@ReMark+' and Language='''+@Language+''') as countpage
from yi25_Images where '+@ReMark+'
and ImagesId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ImagesId
from yi25_Images
where '+@ReMark+' and Language='''+@Language+'''
order by ImagesId desc) 
order by ImagesId desc'
end
end
if @Type=4
begin
if @PageSize=0
begin
set @sql='select * from yi25_Product where '+@ReMark+' and Language='''+@Language+''' order by ProductId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(ProductId) from yi25_Product 
where '+@ReMark+' and Language='''+@Language+''') as countpage
from yi25_Product where '+@ReMark+' and Language='''+@Language+'''
and ProductId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ProductId
from yi25_Product
where '+@ReMark+' and Language='''+@Language+'''
order by ProductId desc) 
order by ProductId desc'
end
end
if @Type=5
begin 
if @PageSize=0
begin
set @sql='select * from yi25_DownLoad where '+@ReMark+' and Language='''+@Language+''' order by DownLoadId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(DownLoadId) from yi25_DownLoad 
where '+@ReMark+' and Language='''+@Language+''') as countpage
from yi25_DownLoad where '+@ReMark+' and Language='''+@Language+'''
and DownLoadId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' DownLoadId
from yi25_DownLoad
where '+@ReMark+' and Language='''+@Language+'''
order by DownLoadId desc) 
order by DownLoadId desc'
end
end

if @Type=6
begin
if @PageSize=0
begin
set @sql='select * from yi25_Message where '+@ReMark+' and Language='''+@Language+''' order by MessageId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(MessageId) from yi25_Message 
where '+@ReMark+' and Language='''+@Language+''') as countpage
from yi25_Message where '+@ReMark+' and Language='''+@Language+'''
and MessageId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' MessageId
from yi25_Message
where '+@ReMark+' and Language='''+@Language+'''
order by MessageId desc) 
order by MessageId desc'
end
end

if @Type=7
begin
if @PageSize=0
begin
set @sql='select * from yi25_Job where '+@ReMark+' and Language='''+@Language+''' order by JobId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(JobId) from yi25_Job 
where '+@ReMark+' and Language='''+@Language+''') as countpage
from yi25_Job where '+@ReMark+' and Language='''+@Language+'''
and JobId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' JobId
from yi25_Job
where '+@ReMark+' and Language='''+@Language+'''
order by JobId desc) 
order by JobId desc'
end
end

if @Type=8
begin
if @PageSize=0
begin
set @sql='select * from yi25_Resume where '+@ReMark+' and Language='''+@Language+''' order by ResumeId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(ResumeId) from yi25_Resume 
where '+@ReMark+' and Language='''+@Language+''') as countpage
from yi25_Resume where '+@ReMark+' and Language='''+@Language+'''
and ResumeId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ResumeId
from yi25_Resume
where '+@ReMark+' and Language='''+@Language+'''
order by ResumeId desc) 
order by ResumeId desc'
end
end

if @Type=9
begin
if @PageSize=0
begin
set @sql='select * from yi25_UserInfo where '+@ReMark+' and Language='''+@Language+''' order by UserInfoId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(UserInfoId) from yi25_UserInfo 
where '+@ReMark+' and Language='''+@Language+''') as countpage
from yi25_UserInfo where '+@ReMark+' and Language='''+@Language+'''
and UserInfoId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' UserInfoId
from yi25_UserInfo
where '+@ReMark+' and Language='''+@Language+'''
order by UserInfoId desc) 
order by UserInfoId desc'
end
end

if @Type=10
begin
if @PageSize=0
begin
set @sql='select * from yi25_OrderList where '+@ReMark+' and Language='''+@Language+''' order by OrderListId desc'
end
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,
(select count(OrderListId) from yi25_OrderList 
where '+@ReMark+' and Language='''+@Language+''') as countpage
from yi25_OrderList where '+@ReMark+' and Language='''+@Language+'''
and OrderListId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' OrderListId
from yi25_OrderList
where '+@ReMark+' and Language='''+@Language+'''
order by OrderListId desc) 
order by OrderListId desc'
end
end

exec sp_Executesql @sql
end


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetMod2  
@Type int,  
@ReMark varchar(200),  
@pageindex int,  
@pagesize int
as  
declare @sql nvarchar(4000)  
begin  
if @Type=1  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_Introduce where '+@ReMark+' order by IntroduceId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(IntroduceId) from yi25_Introduce   
where '+@ReMark+') as countpage   
from yi25_Introduce where '+@ReMark+'  
and IntroduceId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' IntroduceId  
from yi25_Introduce  
where '+@ReMark+'  
order by IntroduceId desc)   
order by IntroduceId desc'  
end  
end  
if @Type=2  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_News where '+@ReMark+' order by NewsId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(NewsId) from yi25_News   
where '+@ReMark+') as countpage   
from yi25_News where '+@ReMark+'  
and NewsId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' NewsId  
from yi25_News  
where '+@ReMark+'  
order by NewsId desc)   
order by NewsId desc'  
end  
end  
if @Type=3  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_Images where '+@ReMark+' order by ImagesId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(ImagesId) from yi25_Images   
where '+@ReMark+') as countpage  
from yi25_Images where '+@ReMark+'  
and ImagesId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ImagesId  
from yi25_Images  
where '+@ReMark+'  
order by ImagesId desc)   
order by ImagesId desc'  
end  
end  
if @Type=4  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_Product where '+@ReMark+' order by ProductId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(ProductId) from yi25_Product   
where '+@ReMark+') as countpage  
from yi25_Product where '+@ReMark+'  
and ProductId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ProductId  
from yi25_Product  
where '+@ReMark+'  
order by ProductId desc)   
order by ProductId desc'  
end  
end  
if @Type=5  
begin   
if @PageSize=0  
begin  
set @sql='select * from yi25_DownLoad where '+@ReMark+' order by DownLoadId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(DownLoadId) from yi25_DownLoad   
where '+@ReMark+') as countpage  
from yi25_DownLoad where '+@ReMark+'  
and DownLoadId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' DownLoadId  
from yi25_DownLoad  
where '+@ReMark+'  
order by DownLoadId desc)   
order by DownLoadId desc'  
end  
end  
  
if @Type=6  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_Message where '+@ReMark+' order by MessageId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(MessageId) from yi25_Message   
where '+@ReMark+') as countpage  
from yi25_Message where '+@ReMark+'  
and MessageId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' MessageId  
from yi25_Message  
where '+@ReMark+'  
order by MessageId desc)   
order by MessageId desc'  
end  
end  
  
if @Type=7  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_Job where '+@ReMark+' order by JobId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(JobId) from yi25_Job   
where '+@ReMark+') as countpage  
from yi25_Job where '+@ReMark+'  
and JobId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' JobId  
from yi25_Job  
where '+@ReMark+'  
order by JobId desc)   
order by JobId desc'  
end  
end  
  
if @Type=8  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_Resume where '+@ReMark+' order by ResumeId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(ResumeId) from yi25_Resume   
where '+@ReMark+') as countpage  
from yi25_Resume where '+@ReMark+'  
and ResumeId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ResumeId  
from yi25_Resume  
where '+@ReMark+'  
order by ResumeId desc)   
order by ResumeId desc'  
end  
end  
  
if @Type=9  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_UserInfo where '+@ReMark+' order by UserInfoId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(UserInfoId) from yi25_UserInfo   
where '+@ReMark+') as countpage  
from yi25_UserInfo where '+@ReMark+'  
and UserInfoId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' UserInfoId  
from yi25_UserInfo  
where '+@ReMark+'  
order by UserInfoId desc)   
order by UserInfoId desc'  
end  
end  
  
if @Type=10  
begin  
if @PageSize=0  
begin  
set @sql='select * from yi25_OrderList where '+@ReMark+' order by OrderListId desc'  
end  
else  
begin  
set @sql='select top '+cast(@pagesize as varchar(20))+' *,  
(select count(OrderListId) from yi25_OrderList   
where '+@ReMark+') as countpage  
from yi25_OrderList where '+@ReMark+'  
and OrderListId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' OrderListId  
from yi25_OrderList  
where '+@ReMark+'  
order by OrderListId desc)   
order by OrderListId desc'  
end  
end  
  
exec sp_Executesql @sql  
end  
  


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetModCount
@Type int,
@ReMark varchar(200),
@Language varchar(10)
as
declare @sql nvarchar(400)
begin
if @Type=1
begin
set @sql='select count(IntroduceId) as countpage from yi25_Introduce 
where '+@ReMark+' and Language='''+@Language+'''
'
end
if @Type=2
begin
set @sql='select count(NewsId) as countpage from yi25_News 
where '+@ReMark+' and Language='''+@Language+'''
'
end
if @Type=3
begin
set @sql='select count(ImagesId) as countpage from yi25_Images 
where '+@ReMark+' and Language='''+@Language+'''
'
end
if @Type=4
begin
set @sql='select count(ProductId) as countpage from yi25_Product 
where '+@ReMark+' and Language='''+@Language+'''
'
end
if @Type=5
begin 
set @sql='select count(DownLoadId) as countpage from yi25_DownLoad 
where '+@ReMark+' and Language='''+@Language+'''
'
end
if @Type=6
begin
set @sql='select count(MessageId) as countpage from yi25_Message 
where '+@ReMark+' and Language='''+@Language+'''
'
end
if @Type=7
begin
set @sql='select count(JobId) as countpage from yi25_Job 
where '+@ReMark+' and Language='''+@Language+'''
'
end
if @Type=8
begin
set @sql='select count(ResumeId) as countpage from yi25_Resume 
where '+@ReMark+' and Language='''+@Language+'''
'
end

if @Type=9
begin
set @sql='select count(UserInfoId) as countpage from yi25_UserInfo 
where '+@ReMark+' and Language='''+@Language+'''
'
end

if @Type=10
begin
set @sql='select count(OrderListId) as countpage from yi25_OrderList 
where '+@ReMark+' and Language='''+@Language+'''
'
end

exec sp_Executesql @sql
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetPageInfo
@Language varchar(10)
as
select * from yi25_PageInfo where Language=@Language

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_GetTable
@StrId varchar(100),
@TableName varchar(100),
@TableId varchar(100),
@Language varchar(10)
as
declare @sql nvarchar(200)
begin
set @sql='select * from  '+@TableName+' where '+@TableId+' in ('+@StrId+') and Language='''+@Language+'''' 
exec sp_Executesql @sql
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_ShopCartPage
@Remark varchar(200),
@pageindex int,
@pagesize int,
@Language varchar(10)
as
declare @sql nvarchar(400)
begin
if @pagesize=0
begin 
set @sql='select * from yi25_ShopCart where '+@ReMark+' and Language='''+@Language+''''
end 
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *
from yi25_ShopCart 
where '+@ReMark+' and Language='''+@Language+''' and ShopCartId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' ShopCartId
from yi25_ShopCart where '+@ReMark+' and Language='''+@Language+'''
order by ShopCartId desc) 
order by ShopCartId desc'
end
exec sp_Executesql @sql
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_deField
@StrId varchar(100)
as
declare @sql nvarchar(200)
begin
set @sql='delete  yi25_Field where FieldId in ('+@StrId+')' 
exec sp_Executesql @sql
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_deTable
@StrId varchar(100),
@TableName varchar(100),
@TableId varchar(100)
as
declare @sql nvarchar(200)
begin
set @sql='delete  '+@TableName+' where '+@TableId+' in ('+@StrId+')' 
exec sp_Executesql @sql
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_delAdmin
@AdminId int
as
delete Admin where AdminId=@AdminId 

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_delFriendLink
@FriendLinkId int
as
delete yi25_FriendLink where FriendLinkId=@FriendLinkId 

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_delShopCart
@Ramrk varchar(200),
@Language varchar(10) 
as
declare @sql nvarchar(400)
begin
set @sql='
delete yi25_ShopCart where '+@Ramrk+' and Language='''+@Language+''''
exec sp_Executesql @sql
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE Proc Pr_getAdmin
@ReMark varchar(100)
as
declare @sql nvarchar(400)
begin
set @sql='select *  from yi25_Admin 
where '+@ReMark+' 
'
end
exec sp_Executesql @sql

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_getAdminPage
@Remark varchar(200),
@pageindex int,
@pagesize int,
@Language varchar(10) 
as
declare @sql nvarchar(400)
begin
if @pagesize=0
begin 
set @sql='select * from yi25_Admin where '+@ReMark+' and Language='''+@Language+''' '
end 
else
begin
set @sql='select top '+cast(@pagesize as varchar(20))+' *,(select count(AdminId) from yi25_Admin) as countpage
from yi25_Admin 
where '+@ReMark+' and Language='''+@Language+'''  and AdminId not in(select top '+cast(@pagesize*@pageindex as varchar(20))+' AdminId
from yi25_Admin where '+@ReMark+' and Language='''+@Language+''' 
order by AdminId desc) 
order by AdminId desc'
end
exec sp_Executesql @sql
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_insAdmin
@AminName varchar(50),
@AdminPassword varchar(50),
@AdminTrueName varchar(50),
@AdminSex varchar(20),
@AdminPhone varchar(50),
@AdminTel varchar(50),
@AdminEmail varchar(50),
@AdminQq varchar(50),
@AdminMsn varchar(50),
@AdminTaobao varchar(50),
@AdminIntro text,
@AdminIntropower varchar(300),
@AdminHandpower varchar(300),
@AdminColumnpower varchar(300),
@EndIp varchar(100),
@Language varchar(10) 
as
insert into yi25_Admin(AminName,AdminPassword,AdminTrueName,AdminSex,AdminPhone,AdminTel,AdminEmail,AdminQq,AdminMsn,AdminTaobao,AdminIntro,
AdminIntropower,AdminHandpower,AdminColumnpower,EndIp,Language)
values(@AminName,@AdminPassword,@AdminTrueName,@AdminSex,@AdminPhone,@AdminTel,@AdminEmail,@AdminQq,@AdminMsn,@AdminTaobao,@AdminIntro,
@AdminIntropower,@AdminHandpower,@AdminColumnpower,@EndIp,@Language)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_insField
@FieldName varchar(50),
@FieldMarker varchar(50),
@FieldType int,
@Type int,
@Gradation int,
@Postion int,
@FieldText varchar(200),
@IsNullColumn int,
@Language varchar(10) 
as
insert into yi25_Field(FieldName,FieldMarker,FieldType,Type,Gradation,Postion,FieldText,IsNullColumn,Language)
values(@FieldName,@FieldMarker,@FieldType,@Type,@Gradation,@Postion,@FieldText,@IsNullColumn,@Language)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_insFriendLink
(
@LinkType int,
@LinkAddress varchar(100),
@LinkInfo varchar(100),
@Explain varchar(200),
@Gadation int,
@LinkName varchar(50),
@Language varchar(10) 
)
as
insert into yi25_FriendLink(LinkType,LinkAddress,LinkInfo,Explain,Gadation,LinkName,Language) 
values(@LinkType,@LinkAddress,@LinkInfo,@Explain,@Gadation,@LinkName,@Language)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_insItem  
@ItemName varchar(50),  
@ItemOrder int,  
@Display int,  
@OpenModel int,   
@ItemAttribute int,  
@ItemUrl varchar(100),  
@ItemType int,  
@ItemFolder varchar(50),  
@StaticPage varchar(50),  
@SeoKeyword text,  
@SeoDescription text,  
@Attribute int,  
@ItemSmallType int,  
@Language varchar(10),
@UrlFormat int   
as  
insert into yi25_Item(ItemName,ItemOrder,Display,OpenModel,ItemAttribute,ItemUrl,ItemType,ItemFolder,StaticPage,SeoKeyword,SeoDescription,Attribute,ItemSmallType,Language,UrlFormat)  
values(@ItemName,@ItemOrder,@Display,@OpenModel,@ItemAttribute,@ItemUrl,@ItemType,@ItemFolder,@StaticPage,@SeoKeyword,@SeoDescription,@Attribute,@ItemSmallType,@Language,@UrlFormat)  

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE Pr_insShopCart
@UserID varchar(50),
@ShopID int,
@TotalNum int,
@Language varchar(10) 
AS 
begin
if exists(select * from yi25_ShopCart where UserID=@UserID and ShopID=@ShopID and Language=@Language)
begin
update yi25_ShopCart set TotalNum=TotalNum+1 where UserID=@UserID and ShopID=@ShopID and Language=@Language
end 
else
begin
	INSERT INTO yi25_ShopCart(
	[UserID],[ShopID],[TotalNum],[Language]
	)VALUES(
	@UserID,@ShopID,@TotalNum,@Language
	)
end
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

create proc Pr_insTableInfo
@TableInfo varchar(200),
@TableInfovalue varchar(200),
@Table varchar(20)
as
declare @sql nvarchar(200)
begin
set @sql='insert into  '+@Table+'('+@TableInfo+') values('+@TableInfovalue+')' 
exec sp_Executesql @sql
end


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

create proc Pr_selBehavior
@CharIp varchar(20)
as
select * from yi25_Behavior where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upAdmin
@AdminId int,
@AminName varchar(50),
@AdminPassword varchar(50),
@AdminTrueName varchar(50),
@AdminSex varchar(20),
@AdminPhone varchar(50),
@AdminTel varchar(50),
@AdminEmail varchar(50),
@AdminQq varchar(50),
@AdminMsn varchar(50),
@AdminTaobao varchar(50),
@AdminIntro text,
@AdminIntropower varchar(300),
@AdminHandpower varchar(300),
@AdminColumnpower varchar(300)
as
update yi25_Admin
set AminName=@AminName,AdminPassword=@AdminPassword,AdminTrueName=@AdminTrueName,AdminSex=@AdminSex,AdminPhone=@AdminPhone,
AdminTel=@AdminTel,AdminEmail=@AdminEmail,AdminQq=@AdminQq,AdminMsn=@AdminMsn,AdminTaobao=@AdminTaobao,AdminIntro=@AdminIntro,
AdminIntropower=@AdminIntropower,AdminHandpower=@AdminHandpower,AdminColumnpower=@AdminColumnpower
where AdminId=@AdminId

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upAdminLogin
@AdminId int,
@EndIp varchar(100)
as
update yi25_Admin set EndTime=getdate(),LoginNum=LoginNum+1,EndIp=@EndIp
where AdminId=@AdminId

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upBaseInfo  
@BaseName varchar(200),  
@BaseLogo varchar(50),  
@SeoKeyword text,  
@SeoDescription text,  
@Author varchar(200),  
@Copyright varchar(200),  
@StatisticsCode text, 
@GgCode text, 
@strlanguage varchar(500),
@Language varchar(10)   
as  
update yi25_BaseInfo set BaseName=@BaseName,BaseLogo=@BaseLogo,SeoKeyword=@SeoKeyword,SeoDescription=@SeoDescription  
,Author=@Author,Copyright=@Copyright,StatisticsCode =@StatisticsCode ,GgCode=@GgCode,strlanguage=@strlanguage,Language=@Language  
where Language=@Language  
if(@@rowcount<1)  
Begin  
insert into yi25_BaseInfo(BaseName,BaseLogo,SeoKeyword,SeoDescription,Author,Copyright,StatisticsCode,GgCode,strlanguage,Language)   
values(@BaseName,@BaseLogo,@SeoKeyword,@SeoDescription,@Author,@Copyright,@StatisticsCode,@GgCode,@strlanguage,@Language)  
end  

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upBehavior
(
@BehaviorCookie varchar(100),
@CharIp varchar(20),
@Area varchar(50),
@FromURL varchar(100),
@FirstEnterPage varchar(100),
@VisitPageDetail text, 
@VisitPageDetailTime varchar(500),
@CurrentURL varchar(100),
@OpSystem varchar(20),
@IeType varchar(15),
@SystemRation varchar(15),
@Website varchar(100), 
@VisitPagePosition varchar(1000),
@KeyWordUrl text,
@KeyWord text,
@Islogin int,
@Flag int,
@PreKeyWord text,
@KeyWordlocalurl text
)
as
declare @bc nvarchar(100)
declare @cutime datetime
begin

select BehaviorId from yi25_Behavior where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp

if(@@rowcount<1)--返回影响的行数
begin
insert into yi25_Behavior(BehaviorCookie,CharIp,Area,FromURL,FirstEnterPage,VisitPageDetail,CurrentURL,OpSystem,IeType,SystemRation,Website,VisitPagePosition,KeyWordUrl,KeyWord,Islogin,PreKeyWord,KeyWordlocalurl)
values(@BehaviorCookie,@CharIp,@Area,@FromURL,@FirstEnterPage,@VisitPageDetail,@CurrentURL,@OpSystem,@IeType,@SystemRation,@Website,@VisitPagePosition,@KeyWordUrl,@KeyWord,@Islogin,@PreKeyWord,@KeyWordlocalurl)
end

else
begin
select @bc=BehaviorCookie,@cutime=CurrendtTime from yi25_Behavior where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp
if @BehaviorCookie=@bc
begin
update yi25_Behavior set VisitPageDetailTime=VisitPageDetailTime+','+cast(datediff(ss,@cutime,getdate()) as varchar(20)),
CurrentURL=@CurrentURL,Islogin=@Islogin,CurrendtTime=getdate() where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp
end 
else
begin
update yi25_Behavior set BehaviorCookie=@BehaviorCookie,VisitPageDetailTime=@VisitPageDetailTime,
CurrentURL=@CurrentURL,Islogin=@Islogin,VisitCount=VisitCount+1,CurrendtTime=getdate() where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp
end
end
end


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

create proc Pr_upBehaviorKey
@KeyWordUrl text,
@KeyWord text,
@PreKeyWord text,
@KeyWordlocalurl text,
@CharIp varchar(20)
as
update yi25_Behavior set KeyWordUrl=@KeyWordUrl,KeyWord=@KeyWord,KeyWordlocalurl=@KeyWordlocalurl,
PreKeyWord=@PreKeyWord where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

create proc Pr_upBehaviorKeyDetail
@VisitPageDetail text, 
@CharIp varchar(20)
as
update yi25_Behavior set VisitPageDetail=@VisitPageDetail
where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

create proc Pr_upBehaviorTime
@CharIp varchar(20)
as
declare @bc nvarchar(100)
declare @cutime datetime
select @bc=BehaviorCookie,@cutime=CurrendtTime from yi25_Behavior where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp

update yi25_Behavior set VisitPageDetailTime=VisitPageDetailTime+','+cast(datediff(ss,@cutime,getdate()) as varchar(20))
where CONVERT(varchar(12),AddTime,111)=
CONVERT(varchar(12),getdate(),111) and CharIp=@CharIp

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upDefaultFlash
@DefaultFlashUrl varchar(200),  
@DefaultFlashLink varchar(200),
@Language varchar(10)  
as  
update yi25_DefaultFlash set DefaultFlashUrl=@DefaultFlashUrl,DefaultFlashLink=@DefaultFlashLink where DefaultFlashId=1 and Language=@Language
if(@@rowcount<1)  
Begin  
insert into yi25_DefaultFlash(DefaultFlashUrl,DefaultFlashLink,Language) values(@DefaultFlashUrl,@DefaultFlashLink,@Language)  
end  

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upField
@FieldId int,
@FieldName varchar(50),
@FieldMarker varchar(50),
@FieldType int,
@Type int,
@Gradation int,
@Postion int,
@FieldText varchar(200),
@IsNullColumn int
as
update yi25_Field
set FieldName=@FieldName,FieldMarker=@FieldMarker,
FieldType=@FieldType,Type=@Type,Gradation=@Gradation,Postion=@Postion,FieldText=@FieldText,IsNullColumn=@IsNullColumn
where FieldId=@FieldId

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upFriendLink
(
@FriendLinkId int,
@LinkType int,
@LinkAddress varchar(100),
@LinkInfo varchar(100),
@Explain varchar(200),
@Gadation int,
@LinkName varchar(50)
)
as
update yi25_FriendLink
set LinkType=@LinkType,LinkAddress=@LinkAddress,LinkInfo=@LinkInfo,
Explain=@Explain,Gadation=@Gadation,LinkName=@LinkName
where FriendLinkId=@FriendLinkId

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upItemFlash    
@ItemId int,    
@FlashType int,    
@FlashUrl varchar(200),    
@FlashLink varchar(200),  
@FlashWidth int,  
@FlashHeight int  
as    
update yi25_Item    
set FlashType=@FlashType,FlashUrl=@FlashUrl,FlashLink=@FlashLink,FlashWidth=@FlashWidth,FlashHeight=@FlashHeight where ItemId=@ItemId   


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upModClickNum
@ModId int,
@Type int,
@ReMark varchar(200)
as
if @Type=1
begin
exec ('update yi25_Introduce set ClickNum=ClickNum+1 where IntroduceId='+@ModId+' and
 '+@ReMark+'')
end
if @Type=2
begin
exec ('update yi25_News set ClickNum=ClickNum+1 where NewsId='+@ModId+' and
 '+@ReMark+'')
end
if @Type=3
begin
exec ('update yi25_Images set ClickNum=ClickNum+1 where ImagesId='+@ModId+' and
 '+@ReMark+'')
end
if @Type=4
begin
exec ('update yi25_Product set ClickNum=ClickNum+1 where ProductId='+@ModId+' and
 '+@ReMark+'') 
end
if @Type=5
begin 
exec ('update yi25_DownLoad set ClickNum=ClickNum+1 where DownLoadId='+@ModId+' and  '+@ReMark+'') 
end
if @Type=6
begin
exec ('update yi25_Message set ClickNum=ClickNum+1 where MessageId='+@ModId+' and
 '+@ReMark+'') 
end
if @Type=7
begin
exec ('update yi25_Job set ClickNum=ClickNum+1 where JobId='+@ModId+' and
 '+@ReMark+'') 
end
if @Type=8
begin
exec ('update yi25_Resume set ClickNum=ClickNum+1 where ResumeId='+@ModId+' and
 '+@ReMark+'') 
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


CREATE proc Pr_upPageInfo  
@CompanyName varchar(50),  
@CompanyAddress varchar(200),  
@CompanyPhone varchar(20),  
@CompanyTel varchar(20),  
@CompanyFax varchar(20),  
@Companyqq varchar(20),  
@CompanyPost varchar(20),  
@CompanyEmail varchar(100),  
@CompanyHttp varchar(100),  
@CompanyNews text,  
@CompSynopsis text,  
@CompanyCase varchar(500),  
@Copyright varchar(200),  
@Language varchar(10)  
as  
update yi25_PageInfo set CompanyName=@CompanyName,CompanyAddress=@CompanyAddress,CompanyPhone=@CompanyPhone,CompanyTel=@CompanyTel  
,CompanyFax=@CompanyFax,Companyqq=@Companyqq,CompanyPost=@CompanyPost,CompanyEmail=@CompanyEmail,CompanyHttp=@CompanyHttp,  
CompanyNews=@CompanyNews,CompSynopsis=@CompSynopsis,CompanyCase=@CompanyCase,Copyright=@Copyright,Language=@Language  
where Language=@Language  
if(@@rowcount<1)  
Begin  
insert into yi25_PageInfo(CompanyName,CompanyAddress,CompanyPhone,CompanyTel,CompanyFax,Companyqq,CompanyPost,CompanyEmail,CompanyHttp,CompanyNews,CompSynopsis,CompanyCase,Copyright,Language)   
values(@CompanyName,@CompanyAddress,@CompanyPhone,@CompanyTel,@CompanyFax,@Companyqq,@CompanyPost,@CompanyEmail,@CompanyHttp,@CompanyNews,@CompSynopsis,@CompanyCase,@Copyright,@Language)   
end  


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upShopCartNum
@ShopCartId int,
@Num int
as
update yi25_ShopCart set TotalNum=@Num where ShopCartId=@ShopCartId

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upTable
@StrId varchar(100),
@TableName varchar(100),
@TableId varchar(100),
@Remark varchar(500)
as
declare @sql nvarchar(200)
begin
set @sql='update  '+@TableName+' set '+@Remark+' where '+@TableId+' in ('+@StrId+')' 
exec sp_Executesql @sql
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upUserLogin
@UserInfoId int
as
update yi25_UserInfo set LoginNum=LoginNum+1,EndTime=getdate() where UserInfoId=@UserInfoId

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO


create PROCEDURE Pr_upUsers
@UsersId int,
@Phone varchar(200),
@Tel varchar(200),
@Email varchar(200),
@TrueName varchar(200),
@Address varchar(200),
@MailNum varchar(200),
@UsersType int
 AS 
	UPDATE Users SET 
[Phone] = @Phone,[Tel] = @Tel,[Email] = @Email,[TrueName] = @TrueName,[Address] = @Address,[MailNum] = @MailNum,[UsersType] = @UsersType
	WHERE UsersId=@UsersId


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc Pr_upsItem  
@ItemId int,  
@ItemName varchar(50),  
@ItemOrder int,  
@Display int,  
@OpenModel int,   
@ItemAttribute int,  
@ItemUrl varchar(100),  
@ItemType int,  
@ItemFolder varchar(50),  
@StaticPage varchar(50),  
@SeoKeyword text,  
@SeoDescription text,  
@Attribute int,  
@ItemSmallType int,
@UrlFormat int
as  
update yi25_Item  
set ItemName=@ItemName,ItemOrder=@ItemOrder,Display=@Display,OpenModel=@OpenModel,  
ItemAttribute=@ItemAttribute,ItemUrl=@ItemUrl,ItemType=@ItemType,ItemFolder=@ItemFolder,  
StaticPage=@StaticPage,SeoKeyword=@SeoKeyword,SeoDescription=@SeoDescription,ItemSmallType=@ItemSmallType,UrlFormat=@UrlFormat
where ItemId=@ItemId  

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE Proc Pr_delBehavior 
@ReMark varchar(100)  
as  
declare @sql nvarchar(400)  
begin  
set @sql='delete yi25_Behavior   
where '+@ReMark+'   
'  
end  
exec sp_Executesql @sql 

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE INDEX BehaviorTime_index ON yi25_Behavior (AddTime)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE dbo.UspOutputData 
@tablename sysname 
AS 
declare @column varchar(1000) 
declare @columndata varchar(1000) 
declare @sql varchar(4000) 
declare @xtype tinyint 
declare @name sysname 
declare @objectId int 
declare @objectname sysname 
declare @ident int 

set nocount on 
set @objectId=object_id(@tablename) 

if @objectId is null -- 判断对象是否存在 
begin 
print 'The object not exists' 
return 
end 
set @objectname=rtrim(object_name(@objectId)) 

if @objectname is null or charindex(@objectname,@tablename)=0 --此判断不严密 
begin 
print 'object not in current database' 
return 
end 

if OBJECTPROPERTY(@objectId,'IsTable') < > 1 -- 判断对象是否是table 
begin 
print 'The object is not table' 
return 
end 

select @ident=status&0x80 from syscolumns where id=@objectid and status&0x80=0x80 

if @ident is not null 
print 'SET IDENTITY_INSERT '+@TableName+' ON' 

declare syscolumns_cursor cursor

for select c.name,c.xtype from syscolumns c where c.id=@objectid order by c.colid 

open syscolumns_cursor 
set @column='' 
set @columndata='' 
fetch next from syscolumns_cursor into @name,@xtype 

while @@fetch_status < >-1 
begin 
if @@fetch_status < >-2 
begin 
if @xtype not in(189,34,35,99,98) --timestamp不需处理，image,text,ntext,sql_variant 暂时不处理 

begin 
set @column=@column+case when len(@column)=0 then'' else ','end+@name 

set @columndata=@columndata+case when len(@columndata)=0 then '' else ','','','
end 

+case when @xtype in(167,175) then '''''''''+'+@name+'+''''''''' --varchar,char 
when @xtype in(231,239) then '''N''''''+'+@name+'+''''''''' --nvarchar,nchar 
when @xtype=61 then '''''''''+convert(char(23),'+@name+',121)+''''''''' --datetime 
when @xtype=58 then '''''''''+convert(char(16),'+@name+',120)+''''''''' --smalldatetime 
when @xtype=36 then '''''''''+convert(char(36),'+@name+')+''''''''' --uniqueidentifier 
else @name end 

end 

end 

fetch next from syscolumns_cursor into @name,@xtype 

end 

close syscolumns_cursor 
deallocate syscolumns_cursor 

set @sql='set nocount on select ''insert '+@tablename+'('+@column+') values(''as ''--'','+@columndata+','')'' from '+@tablename 

print '--'+@sql 
exec(@sql) 

if @ident is not null 
print 'SET IDENTITY_INSERT '+@TableName+' OFF' 


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO
