﻿function RegCheck(objs) {
	var str = objs.checktype;
	switch (str) {
		case "cn":
			return CnWordRegCheck(objs);
			break;
		case "idnum":
			return IdCardRegCheck(objs);
			break;
		case "num":
			return NumRegCheck(objs);
			break;
		case "mail":
			return EmailRegCheck(objs);
			break;
		case "txt":
			return SpecialWordRegCheck(objs);
			break;
		case "date":
			return DateCheck(objs);
			break;
		case "comp":
			return CompTo(objs);
			break;
	}
}
function DateCheck(obj) {
	if (obj.getAttribute("onclick") != null && obj.getAttribute("onclick").indexOf("showCalendar") > -1) {
		return null;
	}
	if (obj.getAttribute("onfocus") != null && obj.getAttribute("onfocus").indexOf("showCalendar") > -1) {
		return null;
	}
	var reg = /^(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$/;
	var str = obj.value;
	if (!reg.test(str)) {
		return "正确格式为1949-10-01";
	}
	return null;
}
function CompTo(obj) {
	var compel = document.getElementsByName(obj.compto)[0];
	if (obj.value != compel.value) {
		return obj.cnname + "与" + compel.cnname + "不相等";
	}
	return null;
}
function CheckLength(obj) {
	var uplimit = obj.checklength.split("-")[0];
	var downlimit = obj.checklength.split("-")[1];
	if (downlimit == null) {
		reg = eval("/^.{" + uplimit + "}$/");
	}
	else {
		reg = eval("/^.{" + uplimit + "," + downlimit + "}$/");
	}
	var str = obj.value;
	if (!reg.test(str)) {
		return "要求输入" + obj.checklength + "个字符";
	}
	return null;
}
function NumRegCheck(obj) {
	var reg = /^[0-9]*[\.]*[0-9]+$/;
	var str = obj.value;
	if (!reg.test(str)) {
		return "必须为数字";
	}
	return null;
}
function IdCardRegCheck(obj) {
	var str = obj.value;
	var reg = /^\d{14}(\d{1}|\d{4}|(\d{3}[xX]))$/;
	if (!reg.test(str)) {
		return "身份证无效";
	}
	return null;
}
function EmailRegCheck(obj) {
	var str = obj.value;
	var reg = /^([a-zA-Z0-9_-])+@([a-zA-Z0-9_-])+((\.[a-zA-Z0-9_-]{2,3}){1,2})$/;
	if (!reg.test(str)) {
		return "email地址无效";
	}
	return null;
}
function CnWordRegCheck(obj) {
	var str = obj.value;
	var reg = /^[\u4e00-\u9fa5](\s*[\u4e00-\u9fa5])*$/;
	if (!reg.test(str)) {
		return "必须输入中文";
	}
	return null;
}
function SpecialWordRegCheck(obj) {
	var reg = /[\'\"\<\>\&]/g;
	var str = obj.value;
	if (reg.test(str)) {
		return "不允许输入\'\"\<\>\&等字符"
	}
	return null;
}
function CheckForm(obj) {
	var myform = eval("document." + obj.name);
	for (i = 0; i < myform.elements.length; i++) {

		if (myform.elements[i].checktype == null || myform.elements[i].checktype == "notes") continue;
		var formvalue = myform.elements[i].value;

		if ((myform.elements[i].value.Trim() == "") && (myform.elements[i].type == "select-one")) {
			alert("您忘了选择" + myform.elements[i].cnname + "!");
			myform.elements[i].focus();
			return false;
			break;
		}

		if (myform.elements[i].value.Trim() == "") {
			alert("您忘了填写" + myform.elements[i].cnname + "!");
			myform.elements[i].focus();
			return false;
			break;
		}

		if ((myform.elements[i].value.length > myform.elements[i].maxlength)) {
			alert("您填写的" + myform.elements[i].cnname + "字数太多了!");
			myform.elements[i].focus();
			return false;
			break;
		}

		var myobj = myform.elements[i];
		var checkResult = RegCheck(myobj);
		if (checkResult != null) {
			alert(myobj.cnname + "输入有误：" + checkResult);
			myobj.focus();
			return false;
			break;
		}

		if (myform.elements[i].checklength != null) {
			checkResult = CheckLength(myobj);
			if (checkResult != null) {
				alert(myobj.cnname + "输入有误：" + checkResult);
				myobj.focus();
				return false;
				break;
			}
		}
	}
	return true;
}
String.prototype.Trim = function () { return Trim(this); }
String.prototype.LTrim = function () { return LTrim(this); }
String.prototype.RTrim = function () { return RTrim(this); }
function LTrim(str) {
	var i;
	for (i = 0; i < str.length; i++) {
		if (str.charAt(i) != " " && str.charAt(i) != " ") break;
	}
	str = str.substring(i, str.length);
	return str;
}
function RTrim(str) {
	var i;
	for (i = str.length - 1; i >= 0; i--) {
		if (str.charAt(i) != " " && str.charAt(i) != " ") break;
	}
	str = str.substring(0, i + 1);
	return str;
}
function Trim(str) {
	return LTrim(RTrim(str));
} 
