﻿var JsLoader = {};
JsLoader.LoadCount = 0;
JsLoader.LoaderNumber = 0;
JsLoader.Load = function (js, id, callback) {
	var scriptId = document.getElementById(id);
	if (scriptId) {
		if (callback) {
			callback();
		}
		JsLoader.LoaderNumber += 1;
		if (JsLoader.LoaderNumber >= JsLoader.LoadCount) {
			if (JsLoader.OnLoad) {
				JsLoader.OnLoad();
			}
		}
	}
	else {
		var script = document.createElement("script");
		script.id = id;
		script.type = "text/javascript";
		script.onload = script.onreadystatechange = function () {
			if (script.readyState && script.readyState != 'loaded' && script.readyState != 'complete') {
				return;
			}
			script.onreadystatechange = script.onload = null;
			if (callback) {
				callback();
			}
			JsLoader.LoaderNumber += 1;
			if (JsLoader.LoaderNumber >= JsLoader.LoadCount) {
				if (JsLoader.OnLoad) {
					JsLoader.OnLoad();
				}
			}
		};
		script.src = js;
		var head = document.getElementsByTagName('head').item(0);
		head.appendChild(script);
	}
}