﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IEnumerable<MvcEnterprise.Models.DataSet1+DownloadRow>>" %>
<%
	string viewType=ViewData["ViewType"].ToString();
	string viewName = ViewData["ViewName"].ToString();
	if (viewName.ToLower() == "downloadview") viewName = string.Empty;
	var items = Model;
	if (viewType == "OneImgAndList" || viewType == "List")
	{
		if (viewType == "OneImgAndList")
		{
			var imgItem = items.FirstOrDefault(m => !string.IsNullOrEmpty(m.SmallPic));
			if (imgItem != null)
			{
				items = items.SkipWhile(m => m == imgItem);
%>
<div class="OneImgAndList">
	<a title="<%= imgItem.DownloadName %>" href='<%= Url.Action("DownloadView",new {ID = imgItem.ID, viewName = viewName}) %>'>
		<img src="<%= imgItem.SmallPic %>" alt="<%= Html.Encode(imgItem.DownloadName) %>" class="OneImgAndListSmallImg" /></a>
	<p style="_width: 99%; font-weight: bold" class="ellipsis"><a class="ellipsis" title="<%= imgItem.DownloadName %>"
		href='<%= Url.Action("DownloadView",new {ID = imgItem.ID, viewName = viewName}) %>'><%= imgItem.DownloadName%></a>
	</p>
	<p style="word-wrap: break-word; word-break: break-all"><%= imgItem.Content.StripHTML().Trim().Substr(0, 70)%>...
	</p>
</div>
<%
}
		}
%>
<ul class="ListTitle">
	<%foreach (var item in items)
   {%>
	<li><a href='<%= Url.Action("DownloadView",new {ID = item.ID, viewName = viewName}) %>' title='<%= item.DownloadName %>'>
		<%= item.DownloadName %></a>&emsp;</li>
	<%}%>
</ul>
<%
}
	else if (viewType == "Img")
	{
%>
<div style="height: 5px; overflow: hidden"></div>
<ul class="Download">
	<%foreach (var item in items)
   {%>
	<li>
		<div class="prodImg">
			<a href="<%= Url.Action("DownloadView",new {ID = item.ID, viewName = viewName}) %>" title="<%= item.DownloadName %>">
				<img alt="<%= Html.Encode(item.DownloadName) %>" src="<%= item.SmallPic %>" /></a>
		</div>
		<div class="prodName">
			<a href="<%= Url.Action("DownloadView",new {ID = item.ID, viewName = viewName}) %>" title="<%= item.DownloadName %>">
				<%= item.DownloadName %> </a>
		</div>
	</li>
	<%}%>
</ul>
<br class="clearfloat" />
<%
}
%>
