﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<MvcEnterprise.Models.DataSet1+DownloadRow>" %>
<%
	var viewName = Request.QueryString["viewname"];
	if (viewName == null || viewName.ToLower() == "downloadview") viewName = string.Empty;
%>
<div class="Location">
	<%= Html.ActionLink(Language.Context.Global.HomePage, "Index")%>
	<%= ViewData["PageLocation"] %>
	<br class="clearfloat" />
</div>
<div>
	<% if (AdminService.AdminName == "admin")
	{
		Response.Write(Html.ActionLink("【编辑】", "DownloadEdit", "Admin", new { ID = Model.ID }, new { style = "color:#F00;font-weight:bold", target = "_blank" }));%>
	<%} %>
</div>
<div class="WebContent">
	<h1><%= Model.DownloadName %></h1>
	<div>
		<ul style="float: left;line-height:200%;list-style:none">
			<li><%= Language.Context.Download.AddTime %><%= Model.AddTime.ToString("yyyy-MM-dd") %></li>
			<li><%= Language.Context.Download.ClickNumber %><%= Model.ClickNumber %></li>
			<li><%= Language.Context.Download.FileSize %><%= Model.FileSize %></li>
			<li><%= Language.Context.Download.DownloadRight %><%var gm = new MemGroupService().GetModel(Model.GroupID); Response.Write(gm != null ? gm.GroupName : Language.Context.Global.Unknow); %></li>
			<li><%= Language.Context.Download.Url %><%= Html.ActionLink(Language.Context.Download.DownloadNow, "Download", new { ID = Model.ID })%></li>
		</ul>
		<img src="<%= Model.SmallPic %>" alt="<%= Html.Encode(Model.DownloadName) %>" style="float: right" width="130" height="120" />
		<br class="clearfloat" />
	</div>
	<hr />
	<%= Model.Content%>
	<hr />
	<%
		var allModel = new DownloadService().GetAllvisible();
		var pModel = allModel.Where(m => m.ID < Model.ID && m.SortID == Model.SortID).FirstOrDefault();
		string pID = string.Empty,pName,nID = string.Empty,nName;
		if (pModel!=null)
		{
			pID = pModel.ID.ToString();
			pName = pModel.DownloadName;
		}
		else
		{
			pName = Language.Context.Global.NoneOther;
		}
		var nModel = allModel.Where(m => m.ID > Model.ID).LastOrDefault();
		if (nModel != null)
		{
			nID = nModel.ID.ToString();
			nName = nModel.DownloadName;
		}
		else
		{
			nName = Language.Context.Global.NoneOther;
		}
	%>
	<div><%= Language.Context.Download.Tags %><%= Model.Tags %></div>
	<div><% Html.RenderPartial("partial_Favorites"); %></div>
	<ul class="ListTitle">
		<li><a href="<%= string.IsNullOrEmpty(pID) ? "javascript:;" : Url.Action("DownloadView",new {ID = pID, viewName = viewName}) %>"><%= Language.Context.Article.Prev %><%= pName %></a></li>
		<li><a href="<%= string.IsNullOrEmpty(nID) ? "javascript:;" : Url.Action("DownloadView",new {ID = nID, viewName = viewName}) %>"><%= Language.Context.Article.Next %><%= nName %></a></li>
	</ul>
</div>
