﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.BLL.SiteBLL
{
    public class AdminPri
    {
        private KstCMS.Model.SiteModel.AdminUser TTuser = new Model.SiteModel.AdminUser();
        string[] RoleIds;
        public AdminPri(string CurrentUserId)
        {
            TTuser.UserId = CurrentUserId;
            RoleIds = TTuser.UserRole.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
        }
        public bool IsShowMenu(string Menu_Id)
        {
            bool isShow = false;
            AdminRole Role = new AdminRole();
            for (int i = 0; i < RoleIds.Length; i++)
            {
                string RoleId = RoleIds[i].ToString();
                string RoleCode = Role.GetModel(int.Parse(RoleId)).RunCode;
                if (!string.IsNullOrEmpty(RoleCode))
                {
                    string[] MenuIds = RoleCode.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                    for (int j = 0; j < MenuIds.Length; j++)
                    {
                        if (Menu_Id == MenuIds[j].ToString().Trim())
                        {
                            isShow = true;
                            break;
                        }
                    }
                }
                if (isShow)
                {
                    break;
                }
            }
            return isShow;
        }

        public List<KstCMS.Model.SiteModel.SysMenu> Get_MMenuList()
        {
            List<KstCMS.Model.SiteModel.SysMenu> list = new List<Model.SiteModel.SysMenu>();
            string UserRole = "";
            string[] RoleIds = UserRole.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            SysMenu mMenu = new SysMenu();
            System.Data.DataSet dsData = mMenu.GetList();
            foreach (System.Data.DataRow row in dsData.Tables[0].Rows)
            {
                string MenuId = row["MENU_ID"].ToString();
                if (IsShowMenu(MenuId))
                {
                    KstCMS.Model.SiteModel.SysMenu Model = mMenu.GetModel(MenuId);
                    list.Add(Model);
                }
            }
            dsData.Dispose();
            return list;
        }

        public List<KstCMS.Model.SiteModel.SysSubMenu> Get_SumMenuList(string Mid)
        {
            List<KstCMS.Model.SiteModel.SysSubMenu> list = new List<Model.SiteModel.SysSubMenu>();
            string UserRole = "";
            string[] RoleIds = UserRole.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
            SysSubMenu mMenu = new SysSubMenu();
            System.Data.DataSet dsData = mMenu.Get_SubMenuList(Mid);
            foreach (System.Data.DataRow row in dsData.Tables[0].Rows)
            {
                string MenuId = row["MENU_ID"].ToString();
                if (IsShowMenu(MenuId))
                {
                    KstCMS.Model.SiteModel.SysSubMenu Model = mMenu.GetModel(MenuId);
                    list.Add(Model);
                }
            }
            dsData.Dispose();
            return list;
        }

        public bool isHasQX(string UrlPath)
        {
            bool isHax = false;
            string MID = string.Empty;
            string Sid = string.Empty;
            SysMenu MMenu = new SysMenu();
            SysSubMenu SubMenu = new SysSubMenu();
            System.Data.DataSet dsData = MMenu.GetList("MENU_URL='" + UrlPath + "'", string.Empty, 1, "MENU_ID");
            System.Data.DataSet dsData1 = SubMenu.GetList(string.Format("MENU_CODE='{0}'", UrlPath), string.Empty, 1, "MENU_ID");
            if (dsData.Tables[0].Rows.Count > 0)
                MID = dsData.Tables[0].Rows[0][0].ToString();
            if (dsData1.Tables[0].Rows.Count > 0)
                Sid = dsData.Tables[0].Rows[0][0].ToString();
            if (IsShowMenu(MID)||IsShowMenu(Sid))
            {
                isHax = true;
            }
            dsData.Dispose();
            dsData1.Dispose();
            return isHax;
        }


    }
}
