﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.BLL.SiteBLL
{
     [Serializable]
    public class WebMenu:BaseBLL
    {
         private KstCMS.DAL.IWebMenu IWebMenuDAL;

         public WebMenu()
         {
             if (DBType == "1")
                 IWebMenuDAL = new DAL.OleDB.WebMenu();
             //else
                // iWebSiteDAL = new DAL.SqlDB.WebSite();
           
         }

         public void Add(string[] FieldValues, params string[] FieldNames)
         {
             string SiteID = "", MenuDir = "";

             for (int i = 0; i < FieldNames.Length; i++)
             {
                 if (FieldNames[i] == "SiteID")
                     SiteID = FieldValues[i].ToString();
                 if (FieldNames[i] == "MenuDiy")
                     MenuDir = FieldValues[i].ToString();
             }
             if (this.IWebMenuDAL.Exists(int.Parse(SiteID), MenuDir))
             {
                 throw new Exception("文件目录已存在！");
             }
             this.IWebMenuDAL.Add(FieldValues, FieldNames);
         }

         public void Delete(int MenuId)
         {
             this.IWebMenuDAL.Delete(MenuId);
         }

         public void Update(string[] FieldValues, int IndexId, params string[] FieldNames)
         {
             this.IWebMenuDAL.Update(FieldValues, IndexId, FieldNames);
         }

         public KstCMS.Model.SiteModel.WebMenu GetMode(int MenuID, params string[] FieldNames)
         {
             return this.IWebMenuDAL.GetModel(MenuID, FieldNames);
         }

         public System.Data.DataSet Get_AllList(params string[] FieldNames)
         {
             return this.IWebMenuDAL.GetList(string.Empty, "SortNO asc", 0, FieldNames);
         }

         public System.Data.DataSet Get_ActList(params string[] FieldNames)
         {
             return this.IWebMenuDAL.GetList("Act=1", "SortNo asc", 0, FieldNames);
         }

         public System.Data.DataSet Get_SiteMenuList(int SiteId,int Act,params string[] FieldNames)
         {
             System.Data.DataSet dsData = null;
             if (Act == -1)
                 dsData = this.IWebMenuDAL.GetList(string.Format("SiteID={0}", SiteId), "SortNo asc", 0, FieldNames);
             if (Act == 0)
                 dsData = this.IWebMenuDAL.GetList(string.Format("SiteID={0} and Act=0", SiteId), "SortNo asc", 0, FieldNames);
             if (Act ==1)
                 dsData = this.IWebMenuDAL.GetList(string.Format("SiteID={0} and Act=1", SiteId), "SortNo asc", 0, FieldNames);
             return dsData;
         }

    }
}
