﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.BLL.SiteBLL
{
   [Serializable]
    public class WebSite:BaseBLL
    {

        private  KstCMS.DAL.IWebSite iWebSiteDAL;
        public WebSite()
        {
            if (DBType == "1")
                iWebSiteDAL = new DAL.OleDB.WebSite();
            else
                iWebSiteDAL = new DAL.SqlDB.WebSite();
        }

        public int Add(KstCMS.Model.SiteModel.WebSite Model)
        {
            bool isHasSite = iWebSiteDAL.Exists(Model.SiteVer);
            if (isHasSite)
            {
                throw new Exception("创建站点失败，站点版本重复！");
            }
            return iWebSiteDAL.Add(Model);
            
        }

        public void Add(string[] FieldValues, params string[] FieldNames)
        {
            string SiteVer = "";
            for (int i = 0; i < FieldNames.Length; i++)
            {
                if (FieldNames[i] == "SiteVer")
                {
                    SiteVer = FieldValues[i].ToString();
                }
            }
            if (this.iWebSiteDAL.Exists(SiteVer))
            {
                throw new Exception("创建站点失败，站点版本重复！");
            }
            this.iWebSiteDAL.Add(FieldValues, FieldNames);
        }

        public void Delete(int SiteId)
        {
            bool IsDefault = this.iWebSiteDAL.GetModel(SiteId, "DefaultSite").DefaultSite == 1 ? true : false;
            if (IsDefault) throw new Exception("禁止删除默认站点！");
            WebMenu MenuBLL = new WebMenu();
            bool IsHasMenu = MenuBLL.Get_SiteMenuList(SiteId, -1, "MenuID").Tables[0].Rows.Count > 0 ? true : false;
            if (IsHasMenu) throw new Exception("站点已设置了导航,禁止删除！");
            this.iWebSiteDAL.Delete(SiteId);
        }

        public void Update(KstCMS.Model.SiteModel.WebSite Model)
        {
            this.iWebSiteDAL.Update(Model);
        }

        public void Update(string[] FieldValues, int SiteId, params string[] FieldNames)
        {
            this.iWebSiteDAL.Update(FieldValues, SiteId, FieldNames);
        }

        public void Set_DefaultSite(int SiteId)
        {
            this.iWebSiteDAL.Set_DefaultSite(SiteId);
        }

        public bool Exists(int SiteId)
        {
            return this.iWebSiteDAL.Exists(SiteId);
        }

        public int GetMaxId()
        {
            return this.iWebSiteDAL.GetMaxId();
        }

        public KstCMS.Model.SiteModel.WebSite GetModel(int SiteId, params string[] FieldName)
        {
            return this.iWebSiteDAL.GetModel(SiteId, FieldName);
        }

        public System.Data.DataSet Get_AllList(params string[] FieldName)
        {
            return this.iWebSiteDAL.GetList(string.Empty, "SortNO asc", 0, FieldName);
        }

        public System.Data.DataSet Get_ActList(params string[] FieldName)
        {
            return this.iWebSiteDAL.GetList("SiteACT=1", "SortNO asc", 0, FieldName);
        }



    }
}
