﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.DAL.OleDB
{
    [Serializable]
    public class SysMenu:KstCMS.DAL.ISysMenu
    {
        public int Add(KstCMS.Model.SiteModel.SysMenu Model)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Sys_Menu(");
            sb.Append("MENU_ID,MENU_NAME,MENU_IMAGE,MENU_URL) values");
            sb.Append("(@MENU_ID,@MENU_NAME,@MENU_IMAGE,@MENU_URL)");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
                new System.Data.OleDb.OleDbParameter("@MENU_NAME",System.Data.OleDb.OleDbType.VarChar,50),
                new System.Data.OleDb.OleDbParameter("@MENU_NAME",System.Data.OleDb.OleDbType.VarChar,100),
                new System.Data.OleDb.OleDbParameter("@MENU_IMAGE",System.Data.OleDb.OleDbType.VarChar,100),
                new System.Data.OleDb.OleDbParameter("@MENU_URL",System.Data.OleDb.OleDbType.VarChar,100)
            };
            cmdParms[0].Value = Model.MENU_ID;
            cmdParms[1].Value = Model.MENU_NAME;
            cmdParms[2].Value = Model.MENU_IMAGE;
            cmdParms[3].Value = Model.MENU_URL;
            object single = KstSoft.DBUtility.OleDB_Helper.GetSingle(sb.ToString(), cmdParms);
            if (single == null)
            {
                return 1;
            }
            return Convert.ToInt32(single);
        }

        public void Update(KstCMS.Model.SiteModel.SysMenu Model)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("Update Sys_Menu set ");
            sb.Append("MENU_NAME=@MENU_NAME,MENU_IMAGE=@MENU_IMAGE,MENU_URL=@MENU_URL ");
            sb.Append("where MENU_ID=@ID");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
                new System.Data.OleDb.OleDbParameter("@ID",System.Data.OleDb.OleDbType.VarChar,2),
                new System.Data.OleDb.OleDbParameter("@MENU_NAME",System.Data.OleDb.OleDbType.VarChar,100),
                new System.Data.OleDb.OleDbParameter("@MENU_IMAGE",System.Data.OleDb.OleDbType.VarChar,100),
                new System.Data.OleDb.OleDbParameter("@MENU_URL",System.Data.OleDb.OleDbType.VarChar,100)
            };
            cmdParms[0].Value = Model.MENU_ID;
            cmdParms[1].Value = Model.MENU_NAME;
            cmdParms[2].Value = Model.MENU_IMAGE;
            cmdParms[3].Value = Model.MENU_URL;
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString(), cmdParms);
        }

        public void Delete(string MENU_ID)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Sys_Menu where ");
            sb.Append(string.Format("MENU_ID='{0}'", MENU_ID));
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString());
        }

        public System.Data.DataSet GetList(string strWhere, string OrderBy, int Top, params string[] FieldNames)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(Top, FieldNames));
            sb.Append(" from Sys_Menu");
            if (!string.IsNullOrEmpty(strWhere))
            {
                sb.Append(" where " + strWhere);
            }
            if (!string.IsNullOrEmpty(OrderBy))
            {
                sb.Append(" order by " + OrderBy);
            }
            return KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString());
        }

        public KstCMS.Model.SiteModel.SysMenu GetModel(string Menu_ID, params string[] FieldNames)
        {
            KstCMS.Model.SiteModel.SysMenu Model = new Model.SiteModel.SysMenu();
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(0, FieldNames));
            sb.Append(" from Sys_Menu where MENU_ID=@ID");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@ID",System.Data.OleDb.OleDbType.Integer)
           };
            cmdParms[0].Value = Menu_ID;
            System.Data.OleDb.OleDbDataReader dr = KstSoft.DBUtility.OleDB_Helper.ExecuteReader(sb.ToString(), cmdParms);
            if (dr.Read())
            {
                Model.MENU_ID = dr["MENU_ID"].ToString();
                Model.MENU_NAME = dr["MENU_NAME"].ToString();
                Model.MENU_IMAGE = dr["MENU_IMAGE"].ToString();
                Model.MENU_URL = dr["MENU_URL"].ToString();
            }
            dr.Close();
            dr.Dispose();
            return Model;
        }

        public bool Exists(string Menu_Id)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select count(1) from Sys_Menu");
            sb.Append(" where MENU_ID=@menuid ");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[] { new System.Data.OleDb.OleDbParameter("@menuid", System.Data.OleDb.OleDbType.VarChar) };
            cmdParms[0].Value = Menu_Id;
            return KstSoft.DBUtility.OleDB_Helper.Exists(sb.ToString(), cmdParms);
        }


    }
}
