﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.DAL.OleDB
{
    [Serializable]
    public class SysSubMenu:KstCMS.DAL.ISysSubMenu
    {
        public int Add(KstCMS.Model.SiteModel.SysSubMenu Model)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("insert into Sub_Menu(");
            sb.Append("MENU_ID,MENU_NAME,MENU_CODE,MENU_IMAGE) values");
            sb.Append("(@MENU_ID,@MENU_NAME,@MENU_CODE,@MENU_IMAGE)");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
                new System.Data.OleDb.OleDbParameter("@MENU_ID",System.Data.OleDb.OleDbType.VarChar,50),
                new System.Data.OleDb.OleDbParameter("@MENU_NAME",System.Data.OleDb.OleDbType.VarChar,100),
                new System.Data.OleDb.OleDbParameter("@MENU_CODE",System.Data.OleDb.OleDbType.VarChar,100),
                new System.Data.OleDb.OleDbParameter("@MENU_IMAGE",System.Data.OleDb.OleDbType.VarChar,100)
            };
            cmdParms[0].Value = Model.MENU_ID;
            cmdParms[1].Value = Model.MENU_NAME;
            cmdParms[2].Value = Model.MENU_CODE;
            cmdParms[3].Value = Model.MENU_IMAGE;
            object single = KstSoft.DBUtility.OleDB_Helper.GetSingle(sb.ToString(), cmdParms);
            if (single == null)
            {
                return 1;
            }
            return Convert.ToInt32(single);
        }

        public void Update(KstCMS.Model.SiteModel.SysSubMenu Model)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("Update Sub_Menu set ");
            sb.Append("MENU_ID=@MENU_ID,MENU_NAME=@MENU_NAME,MENU_CODE=@MENU_CODE,MENU_IMAGE=@MENU_IMAGE ");
            sb.Append("where ID=@ID");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
                new System.Data.OleDb.OleDbParameter("@ID",System.Data.OleDb.OleDbType.Integer),
                new System.Data.OleDb.OleDbParameter("@MENU_ID",System.Data.OleDb.OleDbType.VarChar,50),
                new System.Data.OleDb.OleDbParameter("@MENU_NAME",System.Data.OleDb.OleDbType.VarChar,100),
                new System.Data.OleDb.OleDbParameter("@MENU_CODE",System.Data.OleDb.OleDbType.VarChar,100),
                new System.Data.OleDb.OleDbParameter("@MENU_IMAGE",System.Data.OleDb.OleDbType.VarChar,100)
            };
            cmdParms[0].Value = Model.ID;
            cmdParms[1].Value = Model.MENU_ID;
            cmdParms[2].Value = Model.MENU_NAME;
            cmdParms[3].Value = Model.MENU_CODE;
            cmdParms[4].Value = Model.MENU_IMAGE;
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString(), cmdParms);
        }

        public void Delete(string Menu_Id)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from Sub_Menu where ");
            sb.Append(string.Format("MENU_ID like {0}%", Menu_Id));
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString());
        }

        public System.Data.DataSet GetList(string strWhere, string OrderBy, int Top, params string[] FieldNames)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(Top, FieldNames));
            sb.Append(" from Sub_Menu");
            if (!string.IsNullOrEmpty(strWhere))
            {
                sb.Append(" where " + strWhere);
            }
            if (!string.IsNullOrEmpty(OrderBy))
            {
                sb.Append(" order by " + OrderBy);
            }
            return KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString());
        }

        public bool Exists(string Menu_Code)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select count(1) from Sub_Menu");
            sb.Append(" where MENU_CODE=@MENU_CODE ");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[] { new System.Data.OleDb.OleDbParameter("@MENU_CODE", System.Data.OleDb.OleDbType.VarChar) };
            cmdParms[0].Value = Menu_Code;
            return KstSoft.DBUtility.OleDB_Helper.Exists(sb.ToString(), cmdParms);
        }

        public KstCMS.Model.SiteModel.SysSubMenu GetModel(int id, params string[] FieldNames)
        {
            KstCMS.Model.SiteModel.SysSubMenu Model = new Model.SiteModel.SysSubMenu();
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(0, FieldNames));
            sb.Append(" from Sub_Menu where ID=@ID");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@ID",System.Data.OleDb.OleDbType.Integer)
           };
            cmdParms[0].Value = id;
            System.Data.OleDb.OleDbDataReader dr = KstSoft.DBUtility.OleDB_Helper.ExecuteReader(sb.ToString(), cmdParms);
            if (dr.Read())
            {
                Model.ID = id;
                Model.MENU_ID = dr["MENU_ID"].ToString();
                Model.MENU_NAME = dr["MENU_NAME"].ToString();
                Model.MENU_IMAGE = dr["MENU_IMAGE"].ToString();
                Model.MENU_CODE = dr["MENU_CODE"].ToString();
            }
            dr.Close();
            dr.Dispose();
            return Model;
        }

        public KstCMS.Model.SiteModel.SysSubMenu GetModel(string Menu_Id, params string[] FieldNames)
        {
            KstCMS.Model.SiteModel.SysSubMenu Model = new Model.SiteModel.SysSubMenu();
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(0, FieldNames));
            sb.Append(" from Sub_Menu where MENU_ID=@ID");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@ID",System.Data.OleDb.OleDbType.VarChar,50)
           };
            cmdParms[0].Value = Menu_Id;
            System.Data.OleDb.OleDbDataReader dr = KstSoft.DBUtility.OleDB_Helper.ExecuteReader(sb.ToString(), cmdParms);
            if (dr.Read())
            {
                Model.ID = Convert.ToInt32(dr["ID"].ToString());
                Model.MENU_ID = dr["MENU_ID"].ToString();
                Model.MENU_NAME = dr["MENU_NAME"].ToString();
                Model.MENU_IMAGE = dr["MENU_IMAGE"].ToString();
                Model.MENU_CODE = dr["MENU_CODE"].ToString();
            }
            dr.Close();
            dr.Dispose();
            return Model;
        }
    }
}
