﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace KstCMS.DAL.OleDB
{
    [Serializable]
    public class WebLM:KstCMS.DAL.IWebLM
    {
        public void Add(string[] FieldValues, params string[] FieldNames)
        {
            KstSoft.DBUtility.OleDB_Helper.DataInsert("WebLM", FieldValues, FieldNames);
        }

        public void Update(string[] FieldValues, int LmId, params string[] FieldNames)
        {
            KstSoft.DBUtility.OleDB_Helper.DataInsert("WebLM", FieldValues, FieldNames);
        }
        public void Delete(int LmId)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("delete from WebLM");
            sb.Append(" where LmID=@id");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
                new System.Data.OleDb.OleDbParameter("@id",System.Data.OleDb.OleDbType.Integer)
            };
            cmdParms[0].Value = LmId;
            KstSoft.DBUtility.OleDB_Helper.ExecuteSql(sb.ToString(), cmdParms);
        }

        public KstCMS.Model.SiteModel.WebLM GetModel(int LmId,params string[] FieldNames)
        {
            KstCMS.Model.SiteModel.WebLM Model = new Model.SiteModel.WebLM();
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(0, FieldNames));
            sb.Append(" from WebLM where LmID=@id");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[]{
               new System.Data.OleDb.OleDbParameter("@id",System.Data.OleDb.OleDbType.Integer)
           };
            cmdParms[0].Value = LmId;
            System.Data.DataSet dsData = KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString(), cmdParms);
            if (dsData.Tables[0].Rows.Count > 0)
            {
                for (int i = 0; i < dsData.Tables[0].Columns.Count; i++)
                {
                    string Field = dsData.Tables[0].Columns[i].ColumnName;
                    GetField(dsData.Tables[0].Rows[0], Field, ref Model);
                }
            }
            return Model;
        }

        public System.Data.DataSet GetList(string strWhere, string OrderBy, int Top, params string[] FieldNames)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append(KstSoft.DBUtility.OleDB_Helper.Get_SelectFieldName(Top, FieldNames));
            sb.Append(" from WebLM");
            if (!string.IsNullOrEmpty(strWhere))
            {
                sb.Append(" where " + strWhere);
            }
            if (!string.IsNullOrEmpty(OrderBy))
            {
                sb.Append(" order by " + OrderBy);
            }
            return KstSoft.DBUtility.OleDB_Helper.Query(sb.ToString());
        }

        public bool Exists(int Id)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select count(1) from WebLM");
            sb.Append(" where LmID=@id ");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[] { new System.Data.OleDb.OleDbParameter("@id", System.Data.OleDb.OleDbType.Integer) };
            cmdParms[0].Value = Id;
            return KstSoft.DBUtility.OleDB_Helper.Exists(sb.ToString(), cmdParms);
        }
        public bool Exists(int SiteId,int MenuId, string HtmlFile)
        {
            StringBuilder sb = new StringBuilder();
            sb.Append("select count(1) from WebMenu");
            sb.Append(" where SiteID=@SiteId and MenuID=@MenuID and uPageFile=@uPageFile");
            System.Data.OleDb.OleDbParameter[] cmdParms = new System.Data.OleDb.OleDbParameter[] { 
                 new System.Data.OleDb.OleDbParameter("@SiteId", System.Data.OleDb.OleDbType.Integer),
                 new System.Data.OleDb.OleDbParameter("@MenuID", System.Data.OleDb.OleDbType.Integer),
                 new System.Data.OleDb.OleDbParameter("@uPageFile", System.Data.OleDb.OleDbType.VarChar,50)
             };
            cmdParms[0].Value = SiteId;
            cmdParms[1].Value = MenuId;
            cmdParms[2].Value = HtmlFile;
            return KstSoft.DBUtility.OleDB_Helper.Exists(sb.ToString(), cmdParms);
        }

        public int GetMaxId()
        {
            return KstSoft.DBUtility.OleDB_Helper.GetMaxID("LmID", "WebLM");
        }

        private void GetField(System.Data.DataRow Row, string FieldName, ref KstCMS.Model.SiteModel.WebLM WebLM)
        {
            string FieldValue = Row[FieldName].ToString();
            switch (FieldName)
            {
                case "LmID":
                    WebLM.LmID = Convert.ToInt32(FieldValue);
                    break;
                case "SiteID":
                    WebLM.SiteID = Convert.ToInt32(FieldValue);
                    break;
                case "MenuID":
                    WebLM.MenuID = Convert.ToInt32(FieldValue);
                    break;
                case "LmName":
                    WebLM.LmName = FieldValue;
                    break;
                case "Content":
                    WebLM.Content = FieldValue;
                    break;
                case "uPageFile":
                    WebLM.HtmlFile = FieldValue;
                    break;
                case "MateKey":
                    WebLM.MetaKey = FieldValue;
                    break;
                case "MateDesc":
                    WebLM.MetaDesc = FieldValue;
                    break;
                case "SortNo":
                    WebLM.SortNo = Convert.ToInt32(FieldValue);
                    break;
                case "Act":
                    WebLM.Act = Convert.ToInt32(FieldValue);
                    break;
                case "TempID":
                    WebLM.TempID = Convert.ToInt32(FieldValue);
                    break;
            }
        }
    }
}
